/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.log.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.status.StatusUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackReconfigure {
    private static final Logger log = LoggerFactory.getLogger(LogbackReconfigure.class);
    private static final String RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION = "Re-registering previous fallback configuration once more as a fallback configuration point";
    private static final String FALLING_BACK_TO_SAFE_CONFIGURATION = "Given previous errors, falling back to previously registered safe configuration.";
    private final long birthdate = System.currentTimeMillis();
    private static final LoggerContext CONTEXT;

    private LogbackReconfigure() {
    }

    public static void reconfigure(InputStream config, LoggerContext context) {
        if (context == null) {
            throw new NullPointerException("LoggerContext must not be null");
        }
        LoggerContext lc = context;
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)lc);
        StatusUtil statusUtil = new StatusUtil((Context)lc);
        List eventList = jc.recallSafeConfiguration();
        URL mainURL = ConfigurationWatchListUtil.getMainWatchURL((Context)lc);
        lc.reset();
        long threshold = System.currentTimeMillis();
        try {
            jc.doConfigure(config);
            if (statusUtil.hasXMLParsingErrors(threshold)) {
                LogbackReconfigure.fallbackConfiguration(lc, eventList, mainURL);
            }
        }
        catch (JoranException e) {
            LogbackReconfigure.fallbackConfiguration(lc, eventList, mainURL);
        }
    }

    public static void reconfigure(InputStream config) {
        if (CONTEXT == null) {
            log.warn("\u5f53\u524d\u65e5\u5fd7\u4e0a\u4e0b\u6587\u4e0d\u662flogback\uff0c\u4e0d\u80fd\u4f7f\u7528\u8be5\u914d\u7f6e\u5668\u91cd\u65b0\u914d\u7f6e");
            return;
        }
        LogbackReconfigure.reconfigure(config, CONTEXT);
    }

    private static List<SaxEvent> removeIncludeEvents(List<SaxEvent> unsanitizedEventList) {
        ArrayList<SaxEvent> sanitizedEvents = new ArrayList<SaxEvent>();
        if (unsanitizedEventList == null) {
            return sanitizedEvents;
        }
        for (SaxEvent e : unsanitizedEventList) {
            if ("include".equalsIgnoreCase(e.getLocalName())) continue;
            sanitizedEvents.add(e);
        }
        return sanitizedEvents;
    }

    private static void fallbackConfiguration(LoggerContext lc, List<SaxEvent> eventList, URL mainURL) {
        List<SaxEvent> failsafeEvents = LogbackReconfigure.removeIncludeEvents(eventList);
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext((Context)CONTEXT);
        ConfigurationWatchList oldCWL = ConfigurationWatchListUtil.getConfigurationWatchList((Context)CONTEXT);
        ConfigurationWatchList newCWL = oldCWL.buildClone();
        if (failsafeEvents == null || failsafeEvents.isEmpty()) {
            log.warn("No previous configuration to fall back on.");
        } else {
            log.warn(FALLING_BACK_TO_SAFE_CONFIGURATION);
            try {
                lc.reset();
                ConfigurationWatchListUtil.registerConfigurationWatchList((Context)CONTEXT, (ConfigurationWatchList)newCWL);
                joranConfigurator.doConfigure(failsafeEvents);
                log.info(RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION);
                joranConfigurator.registerSafeConfiguration(eventList);
                log.info("after registerSafeConfiguration: " + eventList);
            }
            catch (JoranException e) {
                log.error("Unexpected exception thrown by a configuration considered safe.", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "LogbackReconfigure(born:" + this.birthdate + ")";
    }

    static {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        CONTEXT = factory instanceof LoggerContext ? (LoggerContext)factory : null;
    }
}

