/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.log.log4j2.plugin.spring;

import com.joe.utils.log.log4j2.plugin.Log4j2Helper;
import com.joe.utils.log.log4j2.plugin.spring.SpringLookup;
import java.util.HashMap;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.MapLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.spi.LoggerContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class SpringPropUtil {
    private static Environment environment;

    public static void reconfigLog4j2(ApplicationContext context) {
        environment = context.getEnvironment();
        Log4j2Helper.reconfigLog4j2(SpringPropPlugin.class);
    }

    public static void reconfigLog4j2(ApplicationContext applicationContext, LoggerContext context) {
        environment = applicationContext.getEnvironment();
        Log4j2Helper.reconfigLog4j2(SpringPropPlugin.class, context);
    }

    private static class SpringPropPlugin {
        private SpringPropPlugin() {
        }

        @PluginFactory
        public static StrLookup configureSubstitutor(@PluginElement(value="Properties") Property[] properties, @PluginConfiguration Configuration config) {
            if (properties == null) {
                return new Interpolator(config.getProperties());
            }
            HashMap<String, String> map = new HashMap<String, String>(config.getProperties());
            for (Property prop : properties) {
                map.put(prop.getName(), prop.getValue());
            }
            return new SpringLookup(environment, (StrLookup)new Interpolator((StrLookup)new MapLookup(map), config.getPluginPackages()));
        }
    }
}

