/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.log.log4j2.plugin.spring;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.springframework.core.env.Environment;

public class SpringLookup
implements StrLookup {
    private Environment environment;
    private StrLookup defaultLookup;

    public SpringLookup(Environment environment, StrLookup defaultLookup) {
        if (environment == null || defaultLookup == null) {
            throw new NullPointerException("environment or defaultLookup must not be null");
        }
        this.environment = environment;
        this.defaultLookup = defaultLookup;
    }

    public String lookup(String key) {
        String value = this.environment.getProperty(key);
        return value == null ? this.defaultLookup.lookup(key) : value;
    }

    public String lookup(LogEvent event, String key) {
        String value;
        if (event == null && (value = this.lookup(key)) != null) {
            return value;
        }
        return this.defaultLookup.lookup(event, key);
    }
}

