/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.img;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImgUtil {
    private static final Logger log = LoggerFactory.getLogger(ImgUtil.class);

    private ImgUtil() {
    }

    public static void changeAlpha(String oldPath, String newPath, byte alpha) throws IOException {
        ImgUtil.changeAlpha(new FileInputStream(oldPath), new FileOutputStream(newPath), alpha);
    }

    public static void changeAlpha(String oldPath, String newPath, byte alpha, AlphaFilter filter) throws IOException {
        ImgUtil.changeAlpha(new FileInputStream(oldPath), new FileOutputStream(newPath), alpha, filter);
    }

    public static void changeAlpha(InputStream srcInput, OutputStream destOutput, byte alpha) throws IOException {
        ImgUtil.changeAlpha(srcInput, destOutput, alpha, null);
    }

    public static void changeAlpha(InputStream srcInput, OutputStream destOutput, byte alpha, AlphaFilter filter) throws IOException {
        log.debug("\u5f00\u59cb\u52a0\u8f7d\u56fe\u7247");
        BufferedImage old = ImageIO.read(srcInput);
        log.debug("\u56fe\u7247\u52a0\u8f7d\u5b8c\u6bd5\uff0c\u5f00\u59cb\u6539\u53d8\u56fe\u7247\u7684alpha\u503c");
        BufferedImage bufferedImage = new BufferedImage(old.getWidth(), old.getHeight(), 6);
        if (filter == null) {
            filter = (x, y, rgb) -> true;
        }
        for (int x2 = 0; x2 < bufferedImage.getWidth(); ++x2) {
            for (int y2 = 0; y2 < bufferedImage.getHeight(); ++y2) {
                int rgb2 = old.getRGB(x2, y2);
                if (filter.filter(x2, y2, rgb2)) {
                    rgb2 = alpha << 24 | rgb2 & 0xFFFFFF;
                }
                bufferedImage.setRGB(x2, y2, rgb2);
            }
        }
        log.debug("\u56fe\u7247aphasia\u503c\u66f4\u6539\u5b8c\u6bd5");
        ImageIO.write((RenderedImage)bufferedImage, "png", destOutput);
    }

    public static ImgMetadata getImgInfo(String path) throws IOException {
        return ImgUtil.getImgInfo(ImageIO.read(new File(path)));
    }

    public static ImgMetadata getImgInfo(BufferedImage image) {
        ImgMetadata imgMetadata = new ImgMetadata();
        imgMetadata.setHeight(image.getHeight());
        imgMetadata.setWidth(image.getWidth());
        imgMetadata.setPixelSize(image.getColorModel().getPixelSize());
        imgMetadata.setAlpha(image.getColorModel().hasAlpha());
        return imgMetadata;
    }

    public static BufferedImage compression(BufferedImage src, int scale) {
        return ImgUtil.compression(src, scale, scale);
    }

    public static BufferedImage compression(BufferedImage src, int widthScale, int heightScale) {
        int oldWidth = src.getWidth();
        int oldHeight = src.getHeight();
        int width = oldWidth / widthScale + (oldWidth % widthScale > 0 ? 1 : 0);
        int height = oldHeight / heightScale + (oldHeight % heightScale > 0 ? 1 : 0);
        BufferedImage dest = new BufferedImage(width, height, src.getType());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = src.getRGB(x * widthScale, y * heightScale);
                dest.setRGB(x, y, rgb);
            }
        }
        return dest;
    }

    public static BufferedImage copy(BufferedImage image) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        return ImgUtil.copy(image, newImage);
    }

    public static BufferedImage copy(BufferedImage src, BufferedImage dest) {
        dest.getGraphics().drawImage(src, 0, 0, null);
        return dest;
    }

    public static final class ImgMetadata {
        private int width;
        private int height;
        private String name;
        private int pixelSize;
        private boolean alpha;

        ImgMetadata() {
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public String getName() {
            return this.name;
        }

        public int getPixelSize() {
            return this.pixelSize;
        }

        public boolean isAlpha() {
            return this.alpha;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPixelSize(int pixelSize) {
            this.pixelSize = pixelSize;
        }

        public void setAlpha(boolean alpha) {
            this.alpha = alpha;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImgMetadata)) {
                return false;
            }
            ImgMetadata other = (ImgMetadata)o;
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            if (this.getPixelSize() != other.getPixelSize()) {
                return false;
            }
            return this.isAlpha() == other.isAlpha();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getHeight();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + this.getPixelSize();
            result = result * 59 + (this.isAlpha() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ImgUtil.ImgMetadata(width=" + this.getWidth() + ", height=" + this.getHeight() + ", name=" + this.getName() + ", pixelSize=" + this.getPixelSize() + ", alpha=" + this.isAlpha() + ")";
        }
    }

    public static interface AlphaFilter {
        public boolean filter(int var1, int var2, int var3);
    }
}

