/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.img;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import net.glxn.qrgen.QRCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IQRCode {
    private static final Logger logger = LoggerFactory.getLogger(IQRCode.class);

    private IQRCode() {
    }

    public static void create(String data, String fileName, int width, int height) throws IOException {
        IQRCode.create(data, new FileOutputStream(fileName), width, height);
        logger.debug("\u4e8c\u7ef4\u7801\u4fdd\u5b58\u4f4d\u7f6e\u4e3a\uff1a{}", (Object)fileName);
    }

    public static void create(String data, OutputStream out, int width, int height) throws IOException {
        logger.debug("\u751f\u6210\u4e8c\u7ef4\u7801\uff0c\u8981\u751f\u6210\u7684\u56fe\u7247\u7684\u5bbd\u4e3a{}\uff0c\u9ad8\u4e3a{}", (Object)width, (Object)height);
        QRCode code = IQRCode.createQRCode(data, width, height);
        code.writeTo(out);
        out.close();
        logger.debug("\u4e8c\u7ef4\u7801\u751f\u6210\u6210\u529f");
    }

    public static BufferedImage createImg(String data, int width, int height) throws IOException {
        logger.debug("\u751f\u6210\u4e8c\u7ef4\u7801\uff0c\u8981\u751f\u6210\u7684\u56fe\u7247\u7684\u5bbd\u4e3a{}\uff0c\u9ad8\u4e3a{}", (Object)width, (Object)height);
        QRCode code = IQRCode.createQRCode(data, width, height);
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(code.stream().toByteArray()));
        logger.debug("\u4e8c\u7ef4\u7801\u751f\u6210\u6210\u529f");
        return image;
    }

    public static String read(String filePath) throws IOException, NotFoundException {
        BufferedImage image = ImageIO.read(new File(filePath));
        return IQRCode.read(image);
    }

    public static String read(URL url) throws IOException, NotFoundException {
        BufferedImage image = ImageIO.read(url);
        return IQRCode.read(image);
    }

    public static String read(InputStream input) throws IOException, NotFoundException {
        BufferedImage image = ImageIO.read(input);
        return IQRCode.read(image);
    }

    private static QRCode createQRCode(String data, int width, int height) {
        logger.debug("\u751f\u6210\u4e8c\u7ef4\u7801\uff0c\u8981\u751f\u6210\u7684\u56fe\u7247\u7684\u5bbd\u4e3a{}\uff0c\u9ad8\u4e3a{}", (Object)width, (Object)height);
        QRCode code = QRCode.from((String)data);
        code.withCharset("UTF8");
        code.withSize(width, height);
        logger.debug("\u4e8c\u7ef4\u7801\u751f\u6210\u6210\u529f");
        return code;
    }

    private static String read(BufferedImage image) throws NotFoundException {
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
        Result result = new MultiFormatReader().decode(binaryBitmap);
        return result.getText();
    }
}

