/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.ext;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentRootHelper {
    private static final Logger log = LoggerFactory.getLogger(DocumentRootHelper.class);
    private static final String DEFAULT_DOC_ROOT = Thread.currentThread().getContextClassLoader().getResource("").getFile();
    private static final String LOCAL_DOC_ROOT = DEFAULT_DOC_ROOT.replace("target/classes", "src/main/webapp");
    private static final String[] COMMON_DOC_ROOTS = new String[]{"src/main/webapp", "public", "static"};

    public static final File getValidDocumentRoot() {
        File file = DocumentRootHelper.getIDEDocumentRoot();
        file = file != null ? file : DocumentRootHelper.getWarOrJarFileDocumentRoot();
        File file2 = file = file != null ? file : DocumentRootHelper.getExplodedWarFileDocumentRoot();
        if (file == null) {
            log.debug("None of the document roots " + Arrays.asList(COMMON_DOC_ROOTS) + " point to a directory and will be ignored.");
        } else {
            log.debug("Document root: " + file);
        }
        return file;
    }

    private static File getWarOrJarFileDocumentRoot() {
        return DocumentRootHelper.getArchiveFileDocumentRoot(".war");
    }

    private static File getExplodedWarFileDocumentRoot() {
        return DocumentRootHelper.getExplodedWarFileDocumentRoot(DocumentRootHelper.getCodeSourceArchive());
    }

    private static File getIDEDocumentRoot() {
        File docRoot = new File(LOCAL_DOC_ROOT);
        if (docRoot.exists()) {
            log.debug("\u5f53\u524d\u5728IDE\u4e2d\u8fd0\u884c\uff0c\u5e76\u4e14\u627e\u5230\u4e86\u5de5\u4f5c\u7a7a\u95f4");
            return docRoot;
        }
        docRoot = new File(DEFAULT_DOC_ROOT);
        if (docRoot.exists()) {
            log.debug("\u5f53\u524d\u5728IDE\u4e2d\u8fd0\u884c\uff0c\u6ca1\u6709\u627e\u5230\u4e86\u5de5\u4f5c\u7a7a\u95f4\uff0c\u4f46\u662f\u627e\u5230\u4e86classpath\u4e0b\u7684doc-root");
            return docRoot;
        }
        log.debug("\u5f53\u524d\u6ca1\u6709\u5728IDE\u4e2d\u8fd0\u884c");
        return null;
    }

    private static File getArchiveFileDocumentRoot(String extension) {
        File file = DocumentRootHelper.getCodeSourceArchive();
        log.debug("Code archive: " + file);
        if (file != null && file.exists() && !file.isDirectory() && file.getName().toLowerCase().endsWith(extension)) {
            return file.getAbsoluteFile();
        }
        return null;
    }

    private static File getExplodedWarFileDocumentRoot(File codeSourceFile) {
        String path;
        int webInfPathIndex;
        log.debug("Code archive: " + codeSourceFile);
        if (codeSourceFile != null && codeSourceFile.exists() && (webInfPathIndex = (path = codeSourceFile.getAbsolutePath()).indexOf(File.separatorChar + "WEB-INF" + File.separatorChar)) >= 0) {
            path = path.substring(0, webInfPathIndex);
            return new File(path);
        }
        return null;
    }

    private static File getCodeSourceArchive() {
        try {
            URL location;
            CodeSource codeSource = DocumentRootHelper.class.getProtectionDomain().getCodeSource();
            URL uRL = location = codeSource == null ? null : codeSource.getLocation();
            if (location == null) {
                return null;
            }
            String path = location.getPath();
            URLConnection connection = location.openConnection();
            if (connection instanceof JarURLConnection) {
                path = ((JarURLConnection)connection).getJarFile().getName();
            }
            if (path.indexOf("!/") != -1) {
                path = path.substring(0, path.indexOf("!/"));
            }
            return new File(path);
        }
        catch (IOException ex) {
            return null;
        }
    }
}

