/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDTO<T>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(BaseDTO.class);
    private static final long serialVersionUID = 5075924626508128661L;
    private static final Map<String, String> MSG = new HashMap<String, String>();
    private String status;
    private String message;
    private T data;

    public BaseDTO() {
        this.success();
    }

    public BaseDTO(String status) {
        this.setStatus(status);
    }

    public static void addStatus(String status, String msg) {
        MSG.put(status, msg);
    }

    public void systemError() {
        this.setStatus("500");
    }

    private void status(String status, String message) {
        this.status = status;
        this.message = message;
    }

    private void setStatus(String status) {
        this.message = MSG.get(status);
        this.status = status;
    }

    private void success() {
        this.setStatus("200");
    }

    public static <T> BaseDTO<T> buildSuccess() {
        return new BaseDTO<T>();
    }

    public static <T> BaseDTO<T> buildSuccess(T data) {
        BaseDTO<T> dto = new BaseDTO<T>();
        dto.setData(data);
        return dto;
    }

    public static <T> BaseDTO<T> buildError() {
        BaseDTO<T> dto = new BaseDTO<T>();
        super.setStatus("500");
        dto.setMessage("\u7cfb\u7edf\u5f02\u5e38");
        return dto;
    }

    public static <T> BaseDTO<T> buildError(String msg) {
        BaseDTO<T> dto = new BaseDTO<T>();
        super.setStatus("500");
        dto.setMessage(msg);
        return dto;
    }

    public static <T> BaseDTO<T> buildError(String status, String message) {
        BaseDTO<T> dto = new BaseDTO<T>();
        super.status(status, message);
        return dto;
    }

    public static <T> BaseDTO<T> exec(Callable<BaseDTO<T>> callable, String msg, Object ... param) {
        try {
            log.info("\u51fd\u6570\u8c03\u7528");
            BaseDTO<T> dto = callable.call();
            log.info("\u51fd\u6570\u8c03\u7528\u7ed3\u679c\u4e3a\uff1a[{}]", dto);
            return dto;
        }
        catch (Exception e) {
            if (param == null || param.length == 0) {
                log.error(msg, (Throwable)e);
            } else {
                Object[] params = new Object[param.length + 1];
                System.arraycopy(param, 0, params, 0, param.length);
                params[param.length] = e;
                log.error(msg, params);
            }
            return BaseDTO.buildError();
        }
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseDTO)) {
            return false;
        }
        BaseDTO other = (BaseDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "BaseDTO(status=" + this.getStatus() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    static {
        MSG.put("200", "success");
        MSG.put("500", "systemError");
    }
}

