/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtil {
    private static final Logger log = LoggerFactory.getLogger(ThreadUtil.class);
    private static final Map<PoolType, ExecutorService> cache = new HashMap<PoolType, ExecutorService>();
    private static final RejectedExecutionHandler DEFAULT_HANDLER = new ThreadPoolExecutor.AbortPolicy();

    public static void sleep(long time, TimeUnit unit) {
        try {
            if (time <= 0L || unit == null) {
                return;
            }
            Thread.sleep(unit.toMillis(time));
        }
        catch (InterruptedException e) {
            log.warn("\u65f6\u95f4\u53c2\u6570\u4e0d\u6b63\u786e\u6216\u8005\u7ebf\u7a0b\u88ab\u4e2d\u65ad\uff0c\u7ebf\u7a0b\u5c06\u4e0d\u4f1a\u7761\u7720");
            throw new RuntimeException(e);
        }
    }

    public static void sleep(long time) {
        ThreadUtil.sleep(time, TimeUnit.SECONDS);
    }

    public static ExecutorService getOrCreatePool(PoolType type) {
        return ThreadUtil.getOrCreatePool(type, "custom-thread-%d");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getOrCreatePool(PoolType type, String format) {
        ExecutorService service = cache.get((Object)type);
        if (service == null || service.isTerminated() || service.isShutdown()) {
            String.format(format, 0);
            Map<PoolType, ExecutorService> map = cache;
            synchronized (map) {
                if (service == null || service.isTerminated() || service.isShutdown()) {
                    ThreadFactory factory = ThreadUtil.build(format);
                    service = ThreadUtil.build(type, factory);
                    cache.put(type, service);
                }
            }
        }
        return service;
    }

    public static ExecutorService createPool(PoolType type) {
        return ThreadUtil.createPool(type, "custom-thread-%d");
    }

    public static ExecutorService createPool(PoolType type, final String format) {
        String.format(format, 0);
        ThreadFactory factory = new ThreadFactory(){
            AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format(format, this.counter.getAndAdd(1)));
            }
        };
        return ThreadUtil.build(type, factory);
    }

    public static ExecutorService build(PoolType type, ThreadFactory factory) {
        int corePoolSize;
        int maximumPoolSize;
        int keepAliveTime = 10;
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        switch (type) {
            case Singleton: {
                maximumPoolSize = 1;
                corePoolSize = 1;
                break;
            }
            case IO: {
                corePoolSize = Runtime.getRuntime().availableProcessors() * 10;
                maximumPoolSize = Runtime.getRuntime().availableProcessors() * 20;
                break;
            }
            case Calc: {
                corePoolSize = maximumPoolSize = Runtime.getRuntime().availableProcessors() + 1;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("\u5185\u90e8\u5f02\u5e38\uff0c\u672a\u77e5\u7ebf\u7a0b\u6c60\u7c7b\u578b[%s]", type.toString()));
            }
        }
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, workQueue, factory, DEFAULT_HANDLER);
    }

    private static ThreadFactory build(final String format) {
        return new ThreadFactory(){
            AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, String.format(format, this.counter.getAndAdd(1)));
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public static enum PoolType {
        Singleton,
        IO,
        Calc;

    }
}

