/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.concurrent;

import com.joe.utils.collection.LRUCacheMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LockService {
    private static final Map<String, Lock> container = new LRUCacheMap<String, Lock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock getLock(String key) {
        Lock lock = container.get(key);
        if (lock == null) {
            Map<String, Lock> map = container;
            synchronized (map) {
                lock = container.computeIfAbsent(key, k -> new ReentrantLock());
            }
        }
        return lock;
    }

    public static void lock(String key) {
        LockService.getLock(key).lock();
    }

    public static boolean tryLock(String key, int wait) throws InterruptedException {
        return LockService.getLock(key).tryLock(wait, TimeUnit.MILLISECONDS);
    }

    public static void unlock(String key) {
        container.get(key).unlock();
    }
}

