/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common.telnet;

import com.joe.utils.common.Assert;
import com.joe.utils.common.telnet.CommandHandler;
import com.joe.utils.common.telnet.TelnetProtocolHandler;
import com.joe.utils.concurrent.ThreadUtil;
import com.joe.utils.exception.IOExceptionWrapper;
import com.joe.utils.exception.TelnetException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetServer {
    private static final Logger log = LoggerFactory.getLogger(TelnetServer.class);
    private static final int SELECT_TIME_GAP = 1000;
    private AtomicBoolean shutdown = new AtomicBoolean(true);
    private int port = 1234;
    private Selector selector = null;
    private ServerSocketChannel acceptorSvr = null;
    private String host = null;
    private Thread shutdownHook;
    private final CommandHandler handler;

    public TelnetServer(CommandHandler handler) {
        this(1234, handler);
    }

    public TelnetServer(int port, CommandHandler handler) {
        this(null, port, handler);
    }

    public TelnetServer(String host, int port, CommandHandler handler) {
        Assert.isTrue(port > 0, "port must be positive number");
        Assert.notNull(handler, "commondHandler must not be null");
        this.host = host;
        this.port = port;
        this.handler = handler;
        this.shutdownHook = new Thread(this::shutdown);
    }

    public void start() {
        if (this.shutdown.compareAndSet(true, false)) {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            try {
                this.selector = Selector.open();
                this.acceptorSvr = ServerSocketChannel.open();
                if (this.host == null) {
                    this.acceptorSvr.socket().bind(new InetSocketAddress(this.port));
                } else {
                    this.acceptorSvr.socket().bind(new InetSocketAddress(InetAddress.getByName(this.host), this.port));
                }
                this.acceptorSvr.configureBlocking(false);
                this.acceptorSvr.register(this.selector, 16);
                log.info("Listening on port: " + Integer.toString(this.acceptorSvr.socket().getLocalPort()));
                Runnable action = () -> {
                    while (!this.shutdown.get()) {
                        try {
                            this.selector.select(1000L);
                            Set<SelectionKey> selectionKeys = this.selector.selectedKeys();
                            Iterator<SelectionKey> it = selectionKeys.iterator();
                            while (it.hasNext()) {
                                SelectionKey key = it.next();
                                it.remove();
                                try {
                                    this.handlerSelectionKey(key);
                                }
                                catch (Throwable t) {
                                    if (key != null) {
                                        key.cancel();
                                        if (key.channel() != null) {
                                            key.channel().close();
                                        }
                                    }
                                    log.error("An error occurs in telnet session.", t);
                                }
                            }
                        }
                        catch (Throwable t) {
                            log.error("An error occurs in telnet server.", t);
                            if (!this.shutdown.get()) continue;
                            break;
                        }
                    }
                };
                ThreadUtil.createPool(ThreadUtil.PoolType.Singleton, "telnet\u7ebf\u7a0b-%d").execute(action);
            }
            catch (IOException e) {
                log.error("Unable to open telnet.", (Throwable)e);
                throw new IOExceptionWrapper(e);
            }
        }
    }

    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            try {
                this.acceptorSvr.close();
                this.selector.close();
            }
            catch (Throwable t) {
                log.error("An error occurs when shutdown telnet server.", t);
                throw new TelnetException(t);
            }
        }
    }

    private void handlerSelectionKey(SelectionKey key) throws IOException {
        if (!key.isValid()) {
            return;
        }
        if (key.isAcceptable()) {
            ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
            SocketChannel sc = ssc.accept();
            sc.configureBlocking(false);
            sc.register(this.selector, 1, new TelnetProtocolHandler(sc, this.handler));
            sc.write(ByteBuffer.wrap(TelnetProtocolHandler.NEGOTIATION_MESSAGE));
        } else if (key.isReadable()) {
            TelnetProtocolHandler telnetProtocolHandler = (TelnetProtocolHandler)key.attachment();
            telnetProtocolHandler.handle();
        }
    }
}

