/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common.telnet;

import com.joe.utils.common.Assert;
import com.joe.utils.common.StringUtils;
import com.joe.utils.common.telnet.AbstractTerminalTypeMapping;
import com.joe.utils.common.telnet.CommandHandler;
import com.joe.utils.common.telnet.SimpleByteBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetProtocolHandler {
    private static final Logger log = LoggerFactory.getLogger(TelnetProtocolHandler.class);
    private static final int BUFFER_SIZE = 128;
    private static final String TELNET_STRING_END = new String(new byte[]{13, 10});
    public static final String TELNET_SESSION_PROMPT = "JoeKerouac-telnet>";
    public static final byte[] NEGOTIATION_MESSAGE = new byte[]{-1, -5, 1, -1, -5, 3, -1, -3, 31, -1, -3, 24};
    private SocketChannel socketChannel;
    private String telnetCommand;
    private String escCommand;
    private SimpleByteBuffer arkCommandBuffer = new SimpleByteBuffer();
    private String clientTerminalType = AbstractTerminalTypeMapping.getDefaultTerminalType();
    private Map<String, AbstractTerminalTypeMapping> terminalTypeMapping;
    private static final byte IAC = -1;
    private static final byte WILL = -5;
    private static final byte WONT = -4;
    private static final byte DO = -3;
    private static final byte DONT = -2;
    private static final byte SB = -6;
    private static final byte SE = -16;
    private static final byte ECHO = 1;
    private static final byte GA = 3;
    private static final byte NAWS = 31;
    private static final byte TERMINAL_TYPE = 24;
    private static final byte MIN_VISUAL_BYTE = 32;
    private static final byte MAX_VISUAL_BYTE = 126;
    private static final byte SPACE = 32;
    private static final byte ESC = 27;
    private static final byte BS = 8;
    private static final byte LF = 10;
    private static final byte CR = 13;
    private boolean isHandlingCommand;
    private boolean isWill;
    private boolean isWont;
    private boolean isDo;
    private boolean isDont;
    private boolean isSb;
    private boolean isEsc;
    private boolean isCr;
    private CommandHandler handler;

    public TelnetProtocolHandler(SocketChannel sc, CommandHandler handler) {
        this.socketChannel = sc;
        this.terminalTypeMapping = new HashMap<String, AbstractTerminalTypeMapping>();
        this.handler = handler;
        this.terminalTypeMapping.put("ANSI", new AbstractTerminalTypeMapping(8, 127){});
        this.terminalTypeMapping.put("VT100", new AbstractTerminalTypeMapping(127, -1){});
        this.terminalTypeMapping.put("VT200", new AbstractTerminalTypeMapping(127, -1){});
        this.terminalTypeMapping.put("VT320", new AbstractTerminalTypeMapping(8, 127){});
        this.terminalTypeMapping.put("SCO", new AbstractTerminalTypeMapping(-1, 127){});
        this.terminalTypeMapping.put("XTERM", new AbstractTerminalTypeMapping(127, -1){});
        this.reset();
    }

    public void handle() throws IOException {
        int count;
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        while ((count = this.socketChannel.read(byteBuffer)) > 0) {
            byteBuffer.flip();
            for (int i = 0; i < count; ++i) {
                this.byteScanner(byteBuffer.get());
            }
        }
    }

    private void byteScanner(byte b) throws IOException {
        b = (byte)(b & 0xFF);
        if (this.isHandlingCommand) {
            switch (b) {
                case -5: {
                    this.isWill = true;
                    this.telnetCommand = this.telnetCommand + '\ufffc';
                    break;
                }
                case -4: {
                    this.isWont = true;
                    this.telnetCommand = this.telnetCommand + '\ufffe';
                    break;
                }
                case -3: {
                    this.isDo = true;
                    this.telnetCommand = this.telnetCommand + '\ufffc';
                    break;
                }
                case -2: {
                    this.isDont = true;
                    this.telnetCommand = this.telnetCommand + '\ufffc';
                    break;
                }
                case -6: {
                    this.isSb = true;
                    this.telnetCommand = this.telnetCommand + '\ufffa';
                    break;
                }
                default: {
                    this.handleCommand(b);
                    break;
                }
            }
        } else if (b == -1) {
            this.isHandlingCommand = true;
            this.telnetCommand = this.telnetCommand + '\uffff';
        } else {
            this.handleData(b);
        }
    }

    private void handleData(byte b) throws IOException {
        if (this.isEsc) {
            this.escCommand = this.escCommand + (char)b;
            AbstractTerminalTypeMapping.KEYS key = this.terminalTypeMapping.get(this.clientTerminalType).getMatchKeys(this.escCommand);
            this.handleEscCommand(key);
        } else if (b == 27) {
            this.isEsc = true;
        } else if (b == this.terminalTypeMapping.get(this.clientTerminalType).getBackspace()) {
            this.erase();
            this.arkCommandBuffer.backSpace();
            this.render();
        } else if (b == this.terminalTypeMapping.get(this.clientTerminalType).getDel()) {
            this.erase();
            this.arkCommandBuffer.delete();
            this.render();
        } else if (32 <= b && b <= 126) {
            if (this.arkCommandBuffer.getGap() > 0) {
                this.erase();
                this.arkCommandBuffer.insert(b);
                this.render();
            } else {
                this.arkCommandBuffer.insert(b);
                this.socketChannel.write(this.wrapSingleByte(b));
            }
        } else if (b == 10 && !this.isCr || b == 13) {
            this.socketChannel.write(ByteBuffer.wrap(new byte[]{13, 10}));
            this.handleCommand();
        }
        this.isCr = b == 13;
    }

    private void handleCommand() throws IOException {
        this.echoResponse((String)this.handler.apply(this.getArkCommand()));
        this.echoPrompt();
    }

    private void erase() throws IOException {
        int i;
        for (i = 0; i < this.arkCommandBuffer.getPos(); ++i) {
            this.socketChannel.write(this.wrapSingleByte((byte)8));
        }
        for (i = 0; i < this.arkCommandBuffer.getSize(); ++i) {
            this.socketChannel.write(this.wrapSingleByte((byte)32));
        }
        for (i = 0; i < this.arkCommandBuffer.getSize(); ++i) {
            this.socketChannel.write(this.wrapSingleByte((byte)8));
        }
    }

    private void render() throws IOException {
        this.socketChannel.write(ByteBuffer.wrap(this.arkCommandBuffer.getBuffer()));
        for (int i = 0; i < this.arkCommandBuffer.getGap(); ++i) {
            this.socketChannel.write(ByteBuffer.wrap(new byte[]{8}));
        }
    }

    private void handleEscCommand(AbstractTerminalTypeMapping.KEYS key) throws IOException {
        switch (key) {
            case LEFT: {
                if (this.arkCommandBuffer.goLeft()) {
                    this.socketChannel.write(this.wrapSingleByte((byte)8));
                }
                this.reset();
                break;
            }
            case RIGHT: {
                byte b = this.arkCommandBuffer.goRight();
                if (b != -1) {
                    this.socketChannel.write(this.wrapSingleByte(b));
                }
                this.reset();
                break;
            }
            case DEL: {
                this.erase();
                this.arkCommandBuffer.delete();
                this.render();
                this.reset();
                break;
            }
            case UNFINISHED: {
                break;
            }
            case UNKNOWN: {
                this.reset();
                break;
            }
        }
    }

    private void handleCommand(byte b) throws IOException {
        if (b == -16) {
            this.telnetCommand = this.telnetCommand + (char)b;
            this.handleNegotiation();
            this.reset();
        } else if (this.isWill || this.isDo) {
            if (this.isWill && b == 24) {
                this.socketChannel.write(ByteBuffer.wrap(new byte[]{-1, -6, 24, 1, -1, -16}));
            } else if (b != 1 && b != 3 && b != 31) {
                this.telnetCommand = this.telnetCommand + (char)b;
                this.socketChannel.write(ByteBuffer.wrap(this.telnetCommand.getBytes()));
            }
            this.reset();
        } else if (this.isWont || this.isDont) {
            this.telnetCommand = this.telnetCommand + (char)b;
            this.socketChannel.write(ByteBuffer.wrap(this.telnetCommand.getBytes()));
            this.reset();
        } else if (this.isSb) {
            this.telnetCommand = this.telnetCommand + (char)b;
        }
    }

    private void handleNegotiation() throws IOException {
        if (this.telnetCommand.contains(new String(new byte[]{24}))) {
            boolean isSuccess = false;
            this.clientTerminalType = this.telnetCommand.substring(4, this.telnetCommand.length() - 2);
            for (String terminalType : this.terminalTypeMapping.keySet()) {
                if (!this.clientTerminalType.contains(terminalType)) continue;
                isSuccess = true;
                this.clientTerminalType = terminalType;
                this.echoPrompt();
                break;
            }
            if (!isSuccess) {
                this.socketChannel.write(ByteBuffer.wrap("TerminalType negotiate failed.".getBytes()));
                throw new RuntimeException("TerminalType negotiate failed.");
            }
        }
    }

    private void reset() {
        this.isWill = false;
        this.isDo = false;
        this.isWont = false;
        this.isDont = false;
        this.isSb = false;
        this.isHandlingCommand = false;
        this.telnetCommand = "";
        this.isEsc = false;
        this.escCommand = "";
    }

    private String getArkCommand() {
        return new String(this.arkCommandBuffer.getAndClearBuffer());
    }

    private void echoResponse(String content) throws IOException {
        Assert.notNull(content, "Echo message should not be null");
        content = content.replace("\n", TELNET_STRING_END);
        if (StringUtils.isEmpty(content)) {
            content = TELNET_STRING_END;
        } else if (!content.endsWith(TELNET_STRING_END)) {
            content = content + TELNET_STRING_END + TELNET_STRING_END;
        } else if (!content.endsWith(TELNET_STRING_END.concat(TELNET_STRING_END))) {
            content = content + TELNET_STRING_END;
        }
        this.socketChannel.write(ByteBuffer.wrap(content.getBytes()));
    }

    private void echoPrompt() throws IOException {
        this.socketChannel.write(ByteBuffer.wrap(TELNET_SESSION_PROMPT.getBytes()));
    }

    private ByteBuffer wrapSingleByte(byte b) {
        return ByteBuffer.wrap(new byte[]{b});
    }
}

