/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common.telnet;

public class SimpleByteBuffer {
    private static final int BUFFER_CHUNK = 20;
    private byte[] buffer = new byte[20];
    private int pos = 0;
    private int size = 0;

    private void resize() {
        byte[] next = new byte[this.buffer.length << 1];
        System.arraycopy(this.buffer, 0, next, 0, this.buffer.length);
        this.buffer = next;
    }

    public void add(byte b) {
        if (this.size >= this.buffer.length) {
            this.resize();
        }
        this.buffer[this.size++] = b;
    }

    public void insert(byte b) {
        int gap;
        if (this.size >= this.buffer.length) {
            this.resize();
        }
        if ((gap = this.size - this.pos) > 0) {
            System.arraycopy(this.buffer, this.pos, this.buffer, this.pos + 1, gap);
        }
        this.buffer[this.pos++] = b;
        ++this.size;
    }

    public byte goRight() {
        if (this.pos < this.size) {
            return this.buffer[this.pos++];
        }
        return -1;
    }

    public boolean goLeft() {
        if (this.pos > 0) {
            --this.pos;
            return true;
        }
        return false;
    }

    public void backSpace() {
        if (this.pos > 0) {
            System.arraycopy(this.buffer, this.pos, this.buffer, this.pos - 1, this.size - this.pos);
            --this.pos;
            --this.size;
        }
    }

    public void delete() {
        if (this.pos < this.size) {
            System.arraycopy(this.buffer, this.pos + 1, this.buffer, this.pos, this.size - this.pos);
            --this.size;
        }
    }

    public byte[] getBuffer() {
        byte[] data = new byte[this.size];
        System.arraycopy(this.buffer, 0, data, 0, this.size);
        return data;
    }

    public byte[] getAndClearBuffer() {
        byte[] data = new byte[this.size];
        System.arraycopy(this.buffer, 0, data, 0, this.size);
        this.size = 0;
        this.pos = 0;
        return data;
    }

    public int getPos() {
        return this.pos;
    }

    public int getSize() {
        return this.size;
    }

    public int getGap() {
        return this.size - this.pos;
    }
}

