/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common.telnet;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTerminalTypeMapping {
    protected Map<String, KEYS> escKeys;
    protected byte backSpace;
    protected byte del;

    public static String getDefaultTerminalType() {
        return File.separatorChar == '/' ? "XTERM" : "ANSI";
    }

    public AbstractTerminalTypeMapping(byte backSpace, byte del) {
        this.backSpace = backSpace;
        this.del = del;
        this.escKeys = new HashMap<String, KEYS>();
        this.escKeys.put("[C", KEYS.RIGHT);
        this.escKeys.put("[D", KEYS.LEFT);
        this.escKeys.put("[3~", KEYS.DEL);
    }

    public byte getBackspace() {
        return this.backSpace;
    }

    public byte getDel() {
        return this.del;
    }

    public KEYS getMatchKeys(String str) {
        if (this.escKeys.get(str) != null) {
            return this.escKeys.get(str);
        }
        if (this.isPossibleEscKeys(str)) {
            return KEYS.UNFINISHED;
        }
        return KEYS.UNKNOWN;
    }

    protected boolean isPossibleEscKeys(String str) {
        for (String key : this.escKeys.keySet()) {
            if (!key.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    public static enum KEYS {
        RIGHT,
        LEFT,
        DEL,
        UNFINISHED,
        UNKNOWN;

    }
}

