/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.UUID;

public class Tools {
    protected static final DecimalFormat NUMFORMAT = new DecimalFormat("#.00");

    public static boolean contains(Object src, Object ... dests) {
        if (dests == null) {
            throw new NullPointerException("dest must not be null");
        }
        if (src == null) {
            return false;
        }
        for (Object dest : dests) {
            if (src != dest && !src.equals(dest)) continue;
            return true;
        }
        return false;
    }

    public static String createUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String createRandomStr(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            int num = (int)(Math.random() * 75.0) + 48;
            while (num > 57 && num < 65 || num > 90 && num < 97) {
                num = (int)(Math.random() * 75.0) + 48;
            }
            chars[i] = (char)num;
        }
        return new String(chars);
    }

    public static String createRandomNum(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(Math.random() * 10.0 + 48.0);
        }
        return new String(chars);
    }

    public static String dealDouble(BigDecimal bigDecimal) {
        double count = bigDecimal.doubleValue();
        return Tools.dealDouble(count);
    }

    public static String dealDouble(double count) {
        if (count < 0.005 && count > -0.005) {
            return "0.00";
        }
        String result = NUMFORMAT.format(count);
        return result.startsWith(".") ? "0" + result : result;
    }
}

