/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common;

import com.joe.utils.annotation.Nullable;
import com.joe.utils.pattern.PatternUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils {
    private static final Logger log = LoggerFactory.getLogger(StringUtils.class);

    public static String copy(String str, int count) {
        if (str == null) {
            throw new NullPointerException("\u539f\u59cb\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3anull");
        }
        if (count <= 0) {
            throw new IllegalArgumentException("\u6b21\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        if (count == 1) {
            return str;
        }
        if (count == 2) {
            return str + str;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String format(String templet, Object ... args) {
        if (args == null || args.length == 0) {
            return templet;
        }
        for (Object arg : args) {
            templet = templet.replaceFirst("\\{}", String.valueOf(arg));
        }
        return templet;
    }

    public static String replaceBefor(String str, int end, String rp) {
        return StringUtils.replace(str, 0, end, rp);
    }

    public static String replaceAfter(String str, int start, String rp) {
        return StringUtils.replace(str, start, str.length() - 1, rp);
    }

    public static String replace(String str, int start, int end, String rp) {
        if (str == null || start < 0 || start > end || end >= str.length()) {
            throw new IllegalArgumentException("\u53c2\u6570\u975e\u6cd5");
        }
        return str.substring(0, start) + rp + str.substring(end + 1);
    }

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    public static String replace(String inString, String oldPattern, @Nullable String newPattern) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        int index = inString.indexOf(oldPattern);
        if (index == -1) {
            return inString;
        }
        int capacity = inString.length();
        if (newPattern.length() > oldPattern.length()) {
            capacity += 16;
        }
        StringBuilder sb = new StringBuilder(capacity);
        int pos = 0;
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String trim(String str, String arg) {
        if (str == null || arg == null) {
            throw new NullPointerException("str or arg must not be null");
        }
        while (str.startsWith(arg)) {
            str = str.substring(arg.length());
        }
        while (str.endsWith(arg)) {
            str = str.substring(0, str.length() - arg.length());
        }
        return str;
    }

    public static Map<String, String> parseForm(String data) {
        log.info("\u89e3\u6790URL\u53c2\u6570:[{}]", (Object)data);
        if (StringUtils.isEmpty(data)) {
            return Collections.emptyMap();
        }
        String[] params = data.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String str : params) {
            String[] strs = str.split("=");
            if (strs.length > 1) {
                map.put(strs[0], strs[1]);
                continue;
            }
            map.put(strs[0], null);
        }
        log.info("URL\u53c2\u6570[{}]\u89e3\u6790\u4e3a[{}]", (Object)data, map);
        return map;
    }

    public static boolean isEmpty(String arg) {
        return arg == null || arg.trim().isEmpty();
    }

    public static boolean isEmptyAny(String ... args) {
        for (String arg : args) {
            if (!StringUtils.isEmpty(arg)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyAll(String ... args) {
        for (String arg : args) {
            if (StringUtils.isEmpty(arg)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String arg) {
        return PatternUtils.isNumber(arg);
    }

    public static String toFirstUpperCase(String arg) {
        return arg.substring(0, 1).toUpperCase() + arg.substring(1);
    }

    public static long lcs(String arg0, String arg1) {
        if (arg0 == null || arg1 == null) {
            return 0L;
        }
        return StringUtils.lcs(arg0, arg1, 0, 0);
    }

    private static long lcs(String arg0, String arg1, int i, int j) {
        if (arg0.length() == i || arg1.length() == j) {
            return 0L;
        }
        if (arg0.charAt(i) == arg1.charAt(j)) {
            return 1L + StringUtils.lcs(arg0, arg1, ++i, ++j);
        }
        return Math.max(StringUtils.lcs(arg0, arg1, ++i, j), StringUtils.lcs(arg0, arg1, i, ++j));
    }
}

