/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common;

import com.joe.utils.common.StringUtils;
import com.joe.utils.common.exception.ResourceNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHelper {
    private static final Logger log = LoggerFactory.getLogger(ResourceHelper.class);

    public static InputStream getResource(String location) throws ResourceNotFoundException {
        if (StringUtils.isEmpty(location)) {
            throw new NullPointerException("location must not be null");
        }
        log.debug("\u83b7\u53d6\u8d44\u6e90[{}]", (Object)location);
        try {
            if (location.startsWith(ResourceProtocol.FILE.protocol)) {
                return new FileInputStream(new File(location.substring(ResourceProtocol.FILE.protocol.length())));
            }
            if (location.startsWith(ResourceProtocol.URL.protocol)) {
                return new URL(location.substring(ResourceProtocol.URL.protocol.length())).openStream();
            }
            if (location.startsWith(ResourceProtocol.HTTP.protocol)) {
                return new URL(location.substring(ResourceProtocol.HTTP.protocol.length())).openStream();
            }
            if (location.startsWith(ResourceProtocol.HTTPS.protocol)) {
                return new URL(location.substring(ResourceProtocol.HTTPS.protocol.length())).openStream();
            }
            if (location.startsWith(ResourceProtocol.CLASSPATH.protocol)) {
                location = location.substring(ResourceProtocol.CLASSPATH.protocol.length());
            }
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        }
        catch (Throwable e) {
            log.error("\u8d44\u6e90[{}]\u83b7\u53d6\u5931\u8d25", (Object)location, (Object)e);
            throw new ResourceNotFoundException("\u67e5\u627e\u8d44\u6e90[" + location + "]\u5f02\u5e38", e);
        }
    }

    public static enum ResourceProtocol {
        FILE("file://"),
        URL("url://"),
        CLASSPATH("classpath://"),
        HTTP("http://"),
        HTTPS("https://");

        private String protocol;

        private ResourceProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }
    }
}

