/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class LunarCalendar {
    private static final long[] lunarInfo = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 28309L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42448L, 83315L, 21200L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46496L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 21952L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19415L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L};
    private static final String[] Gan = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] Zhi = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final String[] Animals = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};

    public static String animalsYear(int year) {
        return Animals[(year - 4) % 12];
    }

    public static String cyclical(int year) {
        int num = year - 1900 + 36;
        return Gan[num % 10] + Zhi[num % 12];
    }

    public static int[] calElement(int year, int month, int day) {
        int i;
        int[] nongDate = new int[3];
        int temp = 0;
        Date baseDate = new GregorianCalendar(1900, 0, 31).getTime();
        Date objDate = new GregorianCalendar(year, month - 1, day).getTime();
        int offset = Math.round((float)(objDate.getTime() - baseDate.getTime()) / 8.64E7f);
        for (i = 1900; i < 2050 && offset > 0; offset -= temp, ++i) {
            temp = LunarCalendar.lYearDays(i);
        }
        if (offset < 0) {
            offset += temp;
        }
        nongDate[0] = --i;
        int leap = LunarCalendar.leapMonth(i);
        for (i = 1; i < 13 && offset > 0; offset -= temp, ++i) {
            if (leap > 0 && i == leap + 1) {
                --i;
                temp = LunarCalendar.leapDays(nongDate[0]);
                continue;
            }
            temp = LunarCalendar.monthDays(nongDate[0], i);
        }
        if (offset < 0) {
            offset += temp;
        }
        nongDate[1] = --i;
        nongDate[2] = offset + 1;
        return nongDate;
    }

    public static String getChinaDate(int day) {
        String a = "";
        if (day == 10) {
            return "\u521d\u5341";
        }
        if (day == 20) {
            return "\u4e8c\u5341";
        }
        if (day == 30) {
            return "\u4e09\u5341";
        }
        int two = day / 10;
        if (two == 0) {
            a = "\u521d";
        }
        if (two == 1) {
            a = "\u5341";
        }
        if (two == 2) {
            a = "\u5eff";
        }
        int one = day % 10;
        switch (one) {
            case 1: {
                a = a + "\u4e00";
                break;
            }
            case 2: {
                a = a + "\u4e8c";
                break;
            }
            case 3: {
                a = a + "\u4e09";
                break;
            }
            case 4: {
                a = a + "\u56db";
                break;
            }
            case 5: {
                a = a + "\u4e94";
                break;
            }
            case 6: {
                a = a + "\u516d";
                break;
            }
            case 7: {
                a = a + "\u4e03";
                break;
            }
            case 8: {
                a = a + "\u516b";
                break;
            }
            case 9: {
                a = a + "\u4e5d";
            }
        }
        return a;
    }

    public static int[] today() {
        Calendar today = Calendar.getInstance();
        int year = today.get(1);
        int month = today.get(2) + 1;
        int date = today.get(5);
        return LunarCalendar.calElement(year, month, date);
    }

    private static int lYearDays(int year) {
        int sum = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            if ((lunarInfo[year - 1900] & (long)i) == 0L) continue;
            ++sum;
        }
        return sum + LunarCalendar.leapDays(year);
    }

    private static int leapDays(int year) {
        if (LunarCalendar.leapMonth(year) != 0) {
            if ((lunarInfo[year - 1900] & 0x10000L) != 0L) {
                return 30;
            }
            return 29;
        }
        return 0;
    }

    private static int leapMonth(int year) {
        return (int)(lunarInfo[year - 1900] & 0xFL);
    }

    private static int monthDays(int year, int month) {
        if ((lunarInfo[year - 1900] & (long)(65536 >> month)) == 0L) {
            return 29;
        }
        return 30;
    }
}

