/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common;

import com.joe.utils.common.StringUtils;
import com.joe.utils.concurrent.ThreadUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMail {
    private static final Logger logger = LoggerFactory.getLogger(JMail.class);
    private static final Future<Boolean> ERROR = new Future<Boolean>(){

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Boolean get() throws InterruptedException, ExecutionException {
            return false;
        }

        @Override
        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return false;
        }
    };
    private Session mailSession;
    private String username;
    private String host;
    private String protocol;
    private String password;
    private Transport transport;
    private ExecutorService executor;

    private JMail(Properties properties) {
        Properties properties1 = properties;
        this.mailSession = Session.getDefaultInstance((Properties)properties1);
        this.username = properties1.getProperty("mail.username");
        this.host = properties1.getProperty("mail.host");
        this.password = properties1.getProperty("mail.password");
        this.protocol = properties1.getProperty("mail.protocol");
        this.executor = ThreadUtil.createPool(ThreadUtil.PoolType.IO);
    }

    public static JMail getInstance(Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties must not be null");
        }
        return new JMail(properties);
    }

    public Future<Boolean> sendEmail(EmailBody body, String to, String title) {
        return this.sendEmail(body, to, title, null, null);
    }

    public Future<Boolean> sendEmail(EmailBody body, String to, String title, JMailCallback callback) {
        return this.sendEmail(body, to, title, null, callback);
    }

    public Future<Boolean> sendEmail(EmailBody body, String to, String title, FilePart[] fileParts) {
        return this.sendEmail(body, to, title, fileParts, null);
    }

    public Future<Boolean> sendEmail(EmailBody body, String to, String title, FilePart[] fileParts, JMailCallback callback) {
        if (StringUtils.isEmpty(to) || body == null && fileParts == null) {
            logger.debug("\u90ae\u4ef6\u6ca1\u6709\u8bbe\u7f6e\u63a5\u6536\u4eba\u6216\u8005\u6ca1\u6709\u6b63\u6587");
            this.execCallback(false, body, to, title, fileParts, null, this, callback);
            return ERROR;
        }
        EmailTask task = new EmailTask(body, to, title, fileParts, callback);
        return this.executor.submit(task);
    }

    private void execCallback(boolean result, EmailBody body, String to, String title, FilePart[] fileParts, Throwable error, JMail mail, JMailCallback callback) {
        if (callback != null) {
            callback.call(result, body, to, title, fileParts, error, mail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConnectStatus() throws MessagingException {
        if (this.transport != null) {
            if (this.transport.isConnected()) {
                logger.debug("\u5f53\u524d\u90ae\u7bb1\u5904\u4e8e\u5728\u7ebf\u72b6\u6001");
                return true;
            }
            JMail jMail = this;
            synchronized (jMail) {
                if (!this.transport.isConnected()) {
                    try {
                        logger.debug("\u5f53\u524d\u90ae\u7bb1\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u5173\u95ed\u91cd\u65b0\u5f00\u542f");
                        this.transport.close();
                    }
                    catch (Exception e) {
                        logger.error("\u5173\u95ed\u73b0\u6709\u7684transport\u5f02\u5e38");
                    }
                    return this.connect();
                }
                logger.debug("\u5f53\u524d\u90ae\u7bb1\u5904\u4e8e\u5728\u7ebf\u72b6\u6001");
                return true;
            }
        }
        JMail jMail = this;
        synchronized (jMail) {
            if (this.transport != null) {
                return this.checkConnectStatus();
            }
            return this.connect();
        }
    }

    private boolean connect() throws MessagingException {
        logger.debug("\u5f00\u59cb\u52a0\u8f7d\u90ae\u7bb1\u914d\u7f6e");
        this.transport = this.mailSession.getTransport(this.protocol);
        this.transport.connect(this.host, this.username, this.password);
        logger.debug("\u90ae\u7bb1\u914d\u7f6e\u52a0\u8f7d\u5b8c\u6bd5");
        return true;
    }

    private void close() {
        if (this.transport != null && this.transport.isConnected()) {
            try {
                this.transport.close();
                logger.debug("\u90ae\u4ef6\u5ba2\u6237\u7aef\u5173\u95ed\u5b8c\u6210");
            }
            catch (MessagingException e) {
                logger.debug("\u5173\u95ed\u90ae\u4ef6\u5ba2\u6237\u7aef\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private class EmailTask
    implements Callable<Boolean> {
        private EmailBody body;
        private String to;
        private String title;
        private FilePart[] fileParts;
        private JMailCallback callback;

        public EmailTask(EmailBody body, String to, String title, FilePart[] fileParts, JMailCallback callback) {
            this.body = body;
            this.to = to;
            this.title = title;
            this.fileParts = fileParts;
            this.callback = callback;
        }

        @Override
        public Boolean call() {
            MimeMessage msg;
            try {
                logger.debug("\u51c6\u5907\u53d1\u9001\u90ae\u4ef6");
                msg = new MimeMessage(JMail.this.mailSession);
                logger.debug("\u5f00\u59cb\u8bbe\u7f6e\u6d88\u606f\u5934");
                msg.setFrom((Address)new InternetAddress(JMail.this.username));
                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to));
                msg.setSubject(this.title);
                logger.debug("\u6d88\u606f\u5934\u8bbe\u7f6e\u5b8c\u6bd5\uff0c\u5f00\u59cb\u8bbe\u7f6e\u6b63\u6587");
                MimeMultipart msgPart = new MimeMultipart("mixed");
                msg.setContent((Multipart)msgPart);
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setContent((Object)this.body.body, (this.body.html ? "text/html" : "text/plain") + ";charset=" + Charset.defaultCharset().name());
                msgPart.addBodyPart((BodyPart)bodyPart);
                logger.debug("\u6b63\u6587\u8bbe\u7f6e\u5b8c\u6bd5\uff0c\u5f00\u59cb\u6dfb\u52a0\u9644\u4ef6");
                if (this.fileParts != null && this.fileParts.length != 0) {
                    for (FilePart filePart : this.fileParts) {
                        MimeBodyPart attach = new MimeBodyPart();
                        attach.attachFile(filePart.getFile());
                        attach.setFileName(filePart.getName());
                        msgPart.addBodyPart((BodyPart)attach);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u90ae\u4ef6\u6d88\u606f\u751f\u6210\u5931\u8d25", (Throwable)e);
                JMail.this.execCallback(false, this.body, this.to, this.title, this.fileParts, e, JMail.this, this.callback);
                return false;
            }
            logger.debug("\u5f00\u59cb\u53d1\u9001\u90ae\u4ef6");
            try {
                logger.debug("\u68c0\u67e5\u5ba2\u6237\u7aef\u72b6\u6001");
                JMail.this.checkConnectStatus();
                logger.debug("\u5ba2\u6237\u7aef\u72b6\u6001\u68c0\u67e5\u5b8c\u6bd5\uff0c\u51c6\u5907\u53d1\u9001");
                JMail.this.transport.sendMessage((Message)msg, msg.getAllRecipients());
                logger.debug("\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
                JMail.this.execCallback(true, this.body, this.to, this.title, this.fileParts, null, JMail.this, this.callback);
                return true;
            }
            catch (Exception e) {
                logger.error("\u90ae\u4ef6\u53d1\u9001\u5f02\u5e38", (Throwable)e);
                JMail.this.execCallback(false, this.body, this.to, this.title, this.fileParts, e, JMail.this, this.callback);
                return false;
            }
        }
    }

    public static interface JMailCallback {
        public void call(boolean var1, EmailBody var2, String var3, String var4, FilePart[] var5, Throwable var6, JMail var7);
    }

    public static class EmailBody {
        private String body;
        private boolean html = false;

        public EmailBody(String body, boolean html) {
            this.body = body;
            this.html = html;
        }

        public String getBody() {
            return this.body;
        }

        public boolean isHtml() {
            return this.html;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public void setHtml(boolean html) {
            this.html = html;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EmailBody)) {
                return false;
            }
            EmailBody other = (EmailBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            return this.isHtml() == other.isHtml();
        }

        protected boolean canEqual(Object other) {
            return other instanceof EmailBody;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            result = result * 59 + (this.isHtml() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "JMail.EmailBody(body=" + this.getBody() + ", html=" + this.isHtml() + ")";
        }
    }

    public static class FilePart {
        private File file;
        private String name;

        public FilePart(File file, String name) {
            if (file == null || StringUtils.isEmpty(name)) {
                throw new NullPointerException("\u6587\u4ef6\u548c\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.file = file;
            this.name = name;
        }

        public File getFile() {
            return this.file;
        }

        public String getName() {
            return this.name;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilePart)) {
                return false;
            }
            FilePart other = (FilePart)o;
            if (!other.canEqual(this)) {
                return false;
            }
            File this$file = this.getFile();
            File other$file = other.getFile();
            if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FilePart;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "JMail.FilePart(file=" + this.getFile() + ", name=" + this.getName() + ")";
        }
    }
}

