/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common;

import com.joe.utils.collection.ByteArray;
import com.joe.utils.common.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger log = LoggerFactory.getLogger(IOUtils.class);

    public static String read(InputStream in, String charset) throws IOException {
        log.debug("\u5f00\u59cb\u4ece\u6d41\u4e2d\u8bfb\u53d6\u5185\u5bb9");
        charset = charset == null ? "UTF8" : charset;
        int bufSize = 256;
        log.debug("\u6587\u672c\u7f16\u7801\u4e3a\uff1a{}\uff0c\u7f13\u51b2\u533a\u5927\u5c0f\u4e3a{}byte", (Object)charset, (Object)bufSize);
        return new String(IOUtils.read(in, bufSize), charset);
    }

    public static byte[] read(InputStream in) throws IOException {
        return IOUtils.read(in, 256);
    }

    public static void saveAsFile(String data, String charset, String addr) throws IOException {
        charset = StringUtils.isEmpty(charset) ? "UTF8" : charset;
        IOUtils.saveAsFile(data.getBytes(charset), addr);
    }

    public static void saveAsFile(byte[] data, String addr) throws IOException {
        log.debug("\u5c06\u5b57\u8282\u6570\u636e\u4fdd\u5b58\u5230\u672c\u5730\u6587\u4ef6");
        File file = new File(addr);
        if (!file.exists() && !file.getParentFile().mkdirs()) {
            log.error("\u521b\u5efa\u76ee\u5f55{}\u5931\u8d25", (Object)addr);
        }
        log.debug("\u4fdd\u5b58\u8def\u5f84\u4e3a\uff1a{}", (Object)file.getAbsolutePath());
        FileOutputStream out = new FileOutputStream(file);
        out.write(data);
        out.flush();
        out.close();
        log.debug("\u6587\u4ef6\u4fdd\u5b58\u5b8c\u6bd5");
    }

    public static byte[] read(InputStream in, int bufSize) throws IOException {
        int len;
        log.debug("\u5f00\u59cb\u4ece\u6d41\u4e2d\u8bfb\u53d6\u6570\u636e\uff0c\u7f13\u51b2\u533a\u5927\u5c0f\u4e3a{}byte", (Object)bufSize);
        ByteArray array = new ByteArray();
        byte[] buffer = new byte[bufSize];
        while ((len = in.read(buffer, 0, buffer.length)) != -1) {
            array.append(buffer, 0, len);
        }
        log.debug("\u8bfb\u53d6\u5b8c\u6bd5");
        return array.getData();
    }

    public static InputStream convert(byte[] data) {
        return new ByteArrayInputStream(data);
    }

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed[{}]\u65f6\u5f02\u5e38\uff0c\u5ffd\u7565", (Object)closeable, (Object)e);
        }
    }
}

