/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common;

import com.joe.utils.common.IOUtils;
import com.joe.utils.common.Tools;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDCard {
    private static final Logger logger = LoggerFactory.getLogger(IDCard.class);
    private static Map<String, String> AREA = new TreeMap<String, String>((o1, o2) -> {
        Integer i1 = Integer.parseInt(o1);
        Integer i2 = Integer.parseInt(o2);
        return i1 - i2;
    });
    private static int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static char[] DIVISOR = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
    private static String[] HK = new String[]{"710000", "810000", "820000"};
    private static final Pattern AREA_PATTERN = Pattern.compile("(.*)?\u5e02");
    private static final Pattern ID_CARD_PATTERN = Pattern.compile("[0-9]{17}[0-9|x|X]");

    public static String create(String borthday) {
        if (!Pattern.matches("[0-9]{8}", borthday)) {
            return null;
        }
        String card = "";
        int r1 = (int)(Math.random() * (double)AREA.size());
        int i = 0;
        for (String befor : AREA.keySet()) {
            if (r1 == i) {
                card = card + befor;
                break;
            }
            ++i;
        }
        card = card + borthday;
        int r2 = (int)(Math.random() * 899.0 + 100.0);
        card = card + r2;
        byte[] idCardByte = card.getBytes();
        int sum = 0;
        for (int j = 0; j < 17; ++j) {
            sum += (idCardByte[j] - 48) * POWER[j];
        }
        int mod = sum % 11;
        char calcLast = DIVISOR[mod];
        card = card + calcLast;
        return card;
    }

    public static boolean check(String idCard) {
        int mod;
        char calcLast;
        Matcher matcher = ID_CARD_PATTERN.matcher(idCard);
        if (!matcher.matches()) {
            logger.error("\u8eab\u4efd\u8bc1\u683c\u5f0f\u4e0d\u5bf9{}", (Object)idCard);
            return false;
        }
        byte[] idCardByte = idCard.getBytes();
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            sum += (idCardByte[i] - 48) * POWER[i];
        }
        char last = idCardByte[17] == 120 || idCardByte[17] == 88 ? (char)'X' : (char)idCardByte[17];
        if (last != (calcLast = DIVISOR[mod = sum % 11])) {
            logger.error("\u52a0\u6743\u7801\u9519\u8bef{}", (Object)idCard);
            return false;
        }
        return true;
    }

    public static String getProvince(String idCard) {
        return AREA.get(idCard.substring(0, 2) + "0000");
    }

    public static String getArea(String idCard) {
        String area;
        String pre = idCard.substring(0, 6);
        if (AREA.get(pre) == null) {
            logger.warn("\u5730\u533a\u4e0d\u5b58\u5728\u6216\u8005\u5730\u533a\u5df2\u4e0d\u5728\u6700\u65b0\u884c\u653f\u533a\u5212\u4ee3\u7801\u4e2d");
        }
        if (Tools.contains(pre, HK)) {
            area = AREA.get(pre + "0000");
        } else {
            String province = AREA.get(idCard.substring(0, 2) + "0000");
            Matcher areamM = AREA_PATTERN.matcher(province);
            StringBuilder sb = new StringBuilder();
            if (!areamM.matches()) {
                sb.append(AREA.get(idCard.substring(0, 4) + "00"));
            }
            sb.append(AREA.get(idCard.substring(0, 6)));
            area = sb.toString();
        }
        return area;
    }

    public static int getSex(String idCard) {
        int sexInt = Integer.parseInt(idCard.substring(16, 17));
        return sexInt % 2;
    }

    public static int getAge(String idCard) {
        int year = Integer.parseInt(idCard.substring(6, 10));
        int monthDay = Integer.parseInt(idCard.substring(10, 14));
        Calendar calendar = Calendar.getInstance();
        int nowYear = calendar.get(1);
        int nowMonthDay = calendar.get(2) * 100 + calendar.get(5);
        int age = nowMonthDay > monthDay ? nowYear - year : nowYear - year - 1;
        if (age < 0) {
            logger.warn("\u8eab\u4efd\u8bc1\u5e74\u9f84\u5e94\u8be5\u5927\u4e8e\u7b49\u4e8e0\uff0c\u4f46\u662f\u5b9e\u9645\u5e74\u9f84\u4e3a{}", (Object)age);
        }
        return age;
    }

    static {
        try {
            String[] areas;
            InputStream input = IDCard.class.getClassLoader().getResourceAsStream("text");
            String areaStr = IOUtils.read(input, "UTF8");
            input.close();
            String data = areaStr.replaceAll("(\\s)+", ";");
            for (String str : areas = data.split(";")) {
                String[] entity = str.split("=");
                AREA.put(entity[0], entity[1]);
            }
        }
        catch (Exception e) {
            logger.error("\u5730\u533a\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }
}

