/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class FormDataBuilder {
    private Map<String, Object> datas;

    private FormDataBuilder(boolean sort) {
        this(sort, null);
    }

    private FormDataBuilder(boolean sort, Map<String, ?> data) {
        this.datas = sort ? new TreeMap<String, Object>() : new HashMap<String, Object>();
        if (data != null && !data.isEmpty()) {
            this.datas.putAll(data);
        }
    }

    public FormDataBuilder form(String key, Object value) {
        this.datas.put(key, value == null ? "" : value);
        return this;
    }

    public FormDataBuilder del(String key) {
        this.datas.remove(key);
        return this;
    }

    public String data() {
        StringBuilder sb = new StringBuilder();
        this.datas.forEach((k, v) -> sb.append("&").append((String)k).append("=").append(String.valueOf(v)));
        return sb.toString().substring(1);
    }

    public String data(boolean useUrlencode, String charset) {
        StringBuilder sb = new StringBuilder();
        if (useUrlencode) {
            this.datas.forEach((k, v) -> sb.append("&").append((String)k).append("=").append(this.urlencode(String.valueOf(v), charset)));
        } else {
            this.datas.forEach((k, v) -> sb.append("&").append((String)k).append("=").append(String.valueOf(v)));
        }
        return sb.toString().substring(1);
    }

    private String urlencode(String data, String charset) {
        try {
            return URLEncoder.encode(String.valueOf(data), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static FormDataBuilder builder() {
        return FormDataBuilder.builder(false, null);
    }

    public static FormDataBuilder builder(Map<String, ?> data) {
        return new FormDataBuilder(false, data);
    }

    public static FormDataBuilder builder(boolean sort) {
        return FormDataBuilder.builder(sort, null);
    }

    public static FormDataBuilder builder(boolean sort, Map<String, ?> data) {
        return new FormDataBuilder(sort, data);
    }
}

