/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);
    private static final Map<String, DateTimeFormatter> FORMATTER_CACHE = new HashMap<String, DateTimeFormatter>();
    public static final String BASE = "yyyy-MM-dd HH:mm:ss";
    public static final String SHORT = "yyyy-MM-dd";
    public static final String TIME = "HH:mm:ss";

    private DateUtil() {
    }

    public static String convert(String date, String format, String newFormat) {
        return DateUtil.getFormatDate(newFormat, DateUtil.parse(date, format));
    }

    public static int getYearDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }

    public static int getMonthDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }

    public static Date parse(String date, String format) {
        LocalDateTime time = DateUtil.getTime(format, date);
        return Date.from(time.toInstant(ZoneOffset.ofTotalSeconds(28800)));
    }

    public static long calc(Date arg0, Date arg1, DateUnit dateUnit) {
        return DateUtil.calc(arg0.toInstant(), arg1.toInstant(), dateUnit);
    }

    public static long calc(String arg0, String arg1, String format, DateUnit dateUnit) {
        try {
            return DateUtil.calc(DateUtil.getTime(format, arg0), DateUtil.getTime(format, arg1), dateUnit);
        }
        catch (Exception e) {
            logger.error("\u65e5\u671f\u8ba1\u7b97\u51fa\u9519", (Throwable)e);
            return -1L;
        }
    }

    public static Date add(DateUnit dateUnit, int amount, String date, String format) {
        LocalDateTime localDateTime = DateUtil.getTime(format, date);
        localDateTime = localDateTime.plus(amount, DateUtil.create(dateUnit));
        return Date.from(localDateTime.toInstant(ZoneOffset.ofTotalSeconds(28800)));
    }

    public static Date add(DateUnit dateUnit, int amount, Date date) {
        return Date.from(date.toInstant().plus((long)amount, DateUtil.create(dateUnit)));
    }

    public static Date add(DateUnit dateUnit, int amount) {
        return DateUtil.add(dateUnit, amount, new Date());
    }

    public static String getFormatDate(String format) {
        return DateUtil.getFormatDate(format, new Date());
    }

    public static String getFormatDate(String format, String zoneId) {
        return DateUtil.getFormatDate(format, new Date(), zoneId);
    }

    public static String getFormatDate(String format, Date date) {
        return DateUtil.getFormatDate(format, date, ZoneId.systemDefault().getId());
    }

    public static String getFormatDate(String format, Date date, String zoneId) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        return dateTimeFormatter.format(date.toInstant().atZone(ZoneId.of(zoneId)).toLocalDateTime());
    }

    public static boolean beforeNow(String date, String format, DateUnit dateUnit) {
        logger.debug("\u6307\u5b9a\u65e5\u671f\u4e3a\uff1a{}", (Object)date);
        return DateUtil.calc(new Date(), DateUtil.parse(date, format), dateUnit) > 0L;
    }

    public static boolean isToday(long time) {
        return DateUtil.isToday(new Date(time));
    }

    public static boolean isToday(String date, String format) {
        String now = DateUtil.getFormatDate(SHORT);
        String target = DateUtil.getFormatDate(SHORT, DateUtil.parse(date, format));
        return now.equals(target);
    }

    public static boolean isToday(Date time) {
        String now = DateUtil.getFormatDate(SHORT);
        String target = DateUtil.getFormatDate(SHORT, time);
        return now.equals(target);
    }

    private static LocalDateTime getTime(String format, String date) {
        LocalDateTime time;
        TemporalAccessor accessor;
        DateTimeFormatter formatter = FORMATTER_CACHE.get(format);
        if (formatter == null) {
            formatter = DateTimeFormatter.ofPattern(format);
            FORMATTER_CACHE.put(format, formatter);
        }
        if ((accessor = formatter.parse(date)).isSupported(ChronoField.DAY_OF_YEAR) && accessor.isSupported(ChronoField.SECOND_OF_DAY)) {
            time = LocalDateTime.from(accessor);
        } else if (accessor.isSupported(ChronoField.SECOND_OF_DAY)) {
            LocalTime localTime = LocalTime.from(accessor);
            time = localTime.atDate(LocalDate.now());
        } else if (accessor.isSupported(ChronoField.DAY_OF_YEAR)) {
            LocalDate localDate = LocalDate.from(accessor);
            time = localDate.atTime(LocalTime.now());
        } else {
            throw new DateUtilException("\u65e5\u671f\u7c7b\u89e3\u6790\u5f02\u5e38\uff0c\u65f6\u95f4\u4e3a\uff1a" + date + "\uff1b\u683c\u5f0f\u4e3a\uff1a" + format);
        }
        return time;
    }

    private static long calc(Temporal arg0, Temporal arg1, DateUnit dateUnit) {
        return DateUtil.create(dateUnit).between(arg1, arg0);
    }

    private static ChronoUnit create(DateUnit dateUnit) {
        switch (dateUnit) {
            case YEAR: {
                return ChronoUnit.YEARS;
            }
            case MONTH: {
                return ChronoUnit.MONTHS;
            }
            case DAY: {
                return ChronoUnit.DAYS;
            }
            case HOUR: {
                return ChronoUnit.HOURS;
            }
            case MINUTE: {
                return ChronoUnit.MINUTES;
            }
            case SECOND: {
                return ChronoUnit.SECONDS;
            }
        }
        throw new DateUtilException("\u6ca1\u6709\u5355\u4f4d\uff1a" + (Object)((Object)dateUnit));
    }

    static class DateUtilException
    extends RuntimeException {
        private static final long serialVersionUID = 474205378026735176L;

        public DateUtilException(String message) {
            super(message);
        }
    }

    public static enum DateUnit {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }
}

