/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common;

import com.joe.utils.common.Assert;
import java.io.InputStream;

public class ClassUtils {
    private static final char PACKAGE_SEPARATOR = '.';
    public static final String CLASS_FILE_SUFFIX = ".class";

    public static InputStream getClassAsStream(Class<?> clazz) {
        return clazz.getResourceAsStream(ClassUtils.getClassFileName(clazz));
    }

    public static String getClassFileName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        String className = clazz.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return className.substring(lastDotIndex + 1) + CLASS_FILE_SUFFIX;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null && (loader = ClassUtils.class.getClassLoader()) == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public static <T> Class<T> loadClass(String className) throws ClassNotFoundException {
        return ClassUtils.getDefaultClassLoader().loadClass(className);
    }

    public static <T> Class<T> loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
        return loader.loadClass(className);
    }
}

