/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.joe.utils.collection.LRUCacheMap;
import com.joe.utils.common.StringUtils;
import com.joe.utils.common.exception.BeanException;
import com.joe.utils.parse.xml.XmlNode;
import com.joe.utils.type.ReflectUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtils {
    private static final Logger log = LoggerFactory.getLogger(BeanUtils.class);
    private static final LRUCacheMap<Class<?>, CustomPropertyDescriptor[]> CACHE = new LRUCacheMap();
    private static final LRUCacheMap<Class<?>, Field[]> FIELD_CACHE = new LRUCacheMap();
    private static final LRUCacheMap<FieldCache, CustomPropertyDescriptor> FIELD_DESC_CACHE = new LRUCacheMap();

    public static Map<String, T> convert(Object pojo, Class<? extends Annotation> annotationType) {
        return BeanUtils.convert(pojo, annotationType, true);
    }

    public static <T> Map<String, T> convert(Object pojo, Class<? extends Annotation> annotationType, boolean hasNull) {
        log.debug("\u83b7\u53d6[{}]\u7684\u5b57\u6bb5\u6620\u5c04\uff0c\u4f7f\u7528\u6ce8\u89e3[{}]\u7684\u503c\u4f5c\u4e3a\u522b\u540d", pojo, annotationType);
        if (pojo == null) {
            return Collections.emptyMap();
        }
        if (annotationType != null && !JsonProperty.class.isAssignableFrom(annotationType) && !XmlNode.class.isAssignableFrom(annotationType)) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6ce8\u89e3\u7c7b\u578b\uff1a" + annotationType);
        }
        Field[] fields = BeanUtils.getAllFields(pojo.getClass());
        HashMap<String, T> map = new HashMap<String, T>();
        if (fields.length == 0) {
            return Collections.emptyMap();
        }
        for (Field field : fields) {
            String name;
            log.debug("\u83b7\u53d6\u5b57\u6bb5[{}]\u7684\u503c", (Object)field);
            JsonProperty jsonProperty = field.getDeclaredAnnotation(JsonProperty.class);
            XmlNode xmlNode = field.getDeclaredAnnotation(XmlNode.class);
            if (annotationType == null) {
                name = BeanUtils.getName(jsonProperty, xmlNode, field);
            } else if (JsonProperty.class.isAssignableFrom(annotationType)) {
                name = BeanUtils.getName(jsonProperty, null, field);
            } else if (XmlNode.class.isAssignableFrom(annotationType)) {
                name = BeanUtils.getName(null, xmlNode, field);
            } else {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6ce8\u89e3\u7c7b\u578b\uff1a" + annotationType);
            }
            T value = BeanUtils.getProperty(pojo, field.getName());
            if (value == null && !hasNull) {
                log.debug("\u5b57\u6bb5[{}]\u503c\u4e3anull\uff0c\u5f53\u524d\u4e0d\u5305\u542bnull\u503c\uff0c\u5ffd\u7565\u5b57\u6bb5[{}]", (Object)name, (Object)name);
                continue;
            }
            map.put(name, value);
        }
        log.debug("\u83b7\u53d6[{}]\u7684\u5b57\u6bb5\u6620\u5c04map\u4e3a[{}]", pojo, map);
        return map;
    }

    public static boolean setProperty(Object obj, String propName, Object value) {
        log.debug("\u5f00\u59cb\u4e3a{}\u7684{}\u5b57\u6bb5\u5199\u5165\u503c{}", new Object[]{obj, propName, value});
        if (obj == null || StringUtils.isEmpty(propName)) {
            log.warn("\u5199\u5165\u6570\u503c\u5931\u8d25\uff0c\u53c2\u6570\u5b58\u5728\u7a7a\u503c");
            return false;
        }
        Class<?> clazz = obj.getClass();
        Field field = BeanUtils.getField(clazz, propName);
        try {
            field.set(obj, value);
            log.debug("\u5199\u5165\u6210\u529f");
            return true;
        }
        catch (Exception e) {
            log.error("\u5199\u5165\u6570\u503c\u5931\u8d25\uff0c\u5199\u5165\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public static <T> T getProperty(Object obj, String propName) {
        log.debug("\u5f00\u59cb\u83b7\u53d6{}\u7684{}\u5b57\u6bb5\u7684\u503c", obj, (Object)propName);
        if (obj == null || StringUtils.isEmpty(propName)) {
            log.warn("\u83b7\u53d6\u5b57\u6bb5\u503c\u5931\u8d25\uff0c\u53c2\u6570\u5b58\u5728\u7a7a\u503c");
            return null;
        }
        Field field = BeanUtils.getField(obj.getClass(), propName);
        try {
            log.debug("\u6210\u529f\u83b7\u53d6\u5230[{}]\u7684[{}]\u5b57\u6bb5", obj.getClass(), (Object)propName);
            Object value = field.get(obj);
            return (T)value;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6{}\u7684{}\u5b57\u6bb5\u503c\u5931\u8d25", new Object[]{obj, propName, e});
            throw new BeanException("\u83b7\u53d6[" + obj.getClass() + "]\u7684\u5b57\u6bb5[" + propName + "]\u7684\u503c\u5931\u8d25", e);
        }
    }

    public static <E> E copy(Object source, Class<E> targetClass) {
        E target;
        if (source == null || targetClass == null) {
            return null;
        }
        String targetClassName = targetClass.getName();
        log.debug("\u751f\u6210{}\u7684\u5b9e\u4f8b", (Object)targetClassName);
        try {
            target = targetClass.newInstance();
        }
        catch (Exception e) {
            log.error("target\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801\uff1b\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
            return null;
        }
        return BeanUtils.copy(target, source);
    }

    public static <E> E copy(E dest, Object ... sources) {
        if (dest == null || sources == null || sources.length == 0) {
            return dest;
        }
        for (Object obj : sources) {
            if (dest == obj) continue;
            BeanUtils.copy(dest, obj);
        }
        return dest;
    }

    public static <E> E copy(E dest, Object source) {
        if (dest == null || source == null) {
            return dest;
        }
        if (dest == source) {
            return dest;
        }
        Class<?> destClass = dest.getClass();
        Class<?> sourceClass = source.getClass();
        String sourceName = sourceClass.getName();
        log.debug("\u5f00\u59cb\u83b7\u53d6{}\u7684\u5b57\u6bb5\u8bf4\u660e", (Object)sourceName);
        CustomPropertyDescriptor[] descriptors = BeanUtils.getPropertyDescriptors(sourceClass);
        if (descriptors.length == 0) {
            log.debug("\u6e90{}\u4e2d\u4e0d\u5b58\u5728\u5df2\u7ecf\u58f0\u660e\u7684\u5b57\u6bb5", (Object)sourceName);
            return dest;
        }
        String targetClassName = destClass.getName();
        for (CustomPropertyDescriptor descriptor : descriptors) {
            String name = descriptor.getName();
            try {
                Field field = descriptor.getField();
                CustomPropertyDescriptor propertyDescriptor = BeanUtils.buildDescriptor(field, destClass);
                if (propertyDescriptor == null) {
                    log.debug("\u76ee\u6807{}\u4e2d\u4e0d\u5b58\u5728\u5df2\u7ecf\u58f0\u660e\u7684\u5b57\u6bb5[{}]", (Object)targetClassName, (Object)field.getName());
                    continue;
                }
                if (propertyDescriptor.getWriteMethod() == null) {
                    log.debug("\u76ee\u6807{}\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5[{}]\u7684write\u65b9\u6cd5", (Object)targetClassName, (Object)field.getName());
                    continue;
                }
                if (descriptor.getReadMethod() == null) {
                    log.debug("\u6e90{}\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5[{}]\u7684read\u65b9\u6cd5", (Object)sourceName, (Object)field.getName());
                    continue;
                }
                propertyDescriptor.getWriteMethod().invoke(dest, descriptor.getReadMethod().invoke(source, new Object[0]));
                log.info("copy {}.{} to {}.{}", new Object[]{source.getClass().getName(), name, targetClassName, name});
            }
            catch (Exception e) {
                log.warn("copy\u4e2d\u590d\u5236{}\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u5ffd\u7565\u8be5\u5b57\u6bb5", (Object)name, (Object)e);
            }
        }
        return dest;
    }

    public static <E, S> List<E> copy(List<S> sourceList, Class<E> targetClass) {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<E> list = new ArrayList<E>(sourceList.size());
        if (!(sourceList instanceof ArrayList)) {
            sourceList = new ArrayList<S>(sourceList);
        }
        for (S source : sourceList) {
            E e = BeanUtils.copy(source, targetClass);
            if (e == null) continue;
            list.add(e);
        }
        return list;
    }

    public static CustomPropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws NullPointerException {
        if (clazz == null) {
            throw new NullPointerException("clazz\u4e3anull");
        }
        CustomPropertyDescriptor[] descriptors = (CustomPropertyDescriptor[])CACHE.get(clazz);
        if (descriptors != null) {
            log.debug("\u83b7\u53d6Class {} \u7684\u8bf4\u660e\u65f6\u53d1\u73b0\u7f13\u5b58\u4e2d\u6709\uff0c\u53d6\u51fa\u7f13\u5b58\u4e2d\u7684\u8bf4\u660e\u8fd4\u56de", clazz);
            return descriptors;
        }
        Field[] fields = BeanUtils.getAllFields(clazz);
        descriptors = new CustomPropertyDescriptor[fields.length];
        if (fields.length == 0) {
            log.debug("\u6e90{}\u4e2d\u4e0d\u5b58\u5728\u5df2\u7ecf\u58f0\u660e\u7684\u5b57\u6bb5", (Object)clazz.getName());
            CACHE.put(clazz, descriptors);
            return descriptors;
        }
        int j = 0;
        for (Field field : fields) {
            CustomPropertyDescriptor descriptor = BeanUtils.buildDescriptor(field, clazz);
            if (descriptor == null) continue;
            descriptors[j++] = descriptor;
        }
        if (j < descriptors.length) {
            log.debug("\u6784\u5efa\u6784\u6210\u4e2d\u53d1\u751f\u4e86\u5f02\u5e38\uff0c\u6570\u7ec4\u4e2d\u6709null\uff0c\u9664\u53bbnull");
            CustomPropertyDescriptor[] propertyDescriptor = new CustomPropertyDescriptor[j];
            System.arraycopy(descriptors, 0, propertyDescriptor, 0, j);
            CACHE.put(clazz, propertyDescriptor);
            return propertyDescriptor;
        }
        log.debug("\u6784\u5efa\u6ca1\u6709\u5f02\u5e38\uff0c\u6784\u5efa\u6210\u529f");
        CACHE.put(clazz, descriptors);
        return descriptors;
    }

    public static Field[] getAllFields(Class<?> clazz) {
        Field[] result = (Field[])FIELD_CACHE.get(clazz);
        if (result != null) {
            return result;
        }
        log.debug("\u83b7\u53d6\u7c7b{}\u7684\u5b57\u6bb5", clazz);
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            fields.addAll(Arrays.asList(BeanUtils.getAllFields(clazz.getSuperclass())));
        }
        log.debug("\u7c7b{}\u7684\u5b57\u6bb5\u4e3a\uff1a{}", clazz, fields);
        result = fields.toArray(new Field[fields.size()]);
        FIELD_CACHE.put(clazz, result);
        for (Field field : result) {
            try {
                field.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public static Field getField(Class<?> clazz, String name) {
        Field[] fields;
        for (Field field : fields = BeanUtils.getAllFields(clazz)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    private static CustomPropertyDescriptor buildDescriptor(Field field, Class<?> clazz) {
        FieldCache fieldCache = new FieldCache(field, clazz);
        if (FIELD_DESC_CACHE.containsKey(fieldCache)) {
            return (CustomPropertyDescriptor)FIELD_DESC_CACHE.get(fieldCache);
        }
        String name = field.getName();
        CustomPropertyDescriptor customPropertyDescriptor = null;
        try {
            if (ReflectUtil.isFinal(field)) {
                log.debug("\u5b57\u6bb5{}\u662ffinal\u7c7b\u578b\uff0c\u5c1d\u8bd5\u4e3a\u8be5\u5b57\u6bb5\u521b\u5efa\u8bf4\u660e", (Object)name);
                customPropertyDescriptor = BeanUtils.tryBuildFinal(field, clazz);
            } else {
                log.debug("\u5b57\u6bb5\u4e0d\u662ffinal\u7c7b\u578b\uff0c\u5f00\u59cb\u6784\u5efa\u5b57\u6bb5{}\u7684\u8bf4\u660e", (Object)name);
                customPropertyDescriptor = BeanUtils.convert(field, new PropertyDescriptor(name, clazz), clazz);
            }
        }
        catch (IntrospectionException e) {
            log.info("\u5c1d\u8bd5\u81ea\u5b9a\u4e49\u6784\u5efaPropertyDescriptor");
            Method writeMethod = null;
            String methodName = StringUtils.toFirstUpperCase(name);
            Method readMethod = BeanUtils.getMethod("get" + methodName, clazz, new Class[0]);
            if (readMethod == null) {
                readMethod = BeanUtils.getMethod("is" + methodName, clazz, new Class[0]);
            }
            if (readMethod != null) {
                writeMethod = BeanUtils.getMethod("set" + methodName, clazz, readMethod.getReturnType());
            }
            if (writeMethod == null) {
                log.warn("\u8bf4\u660e\u6784\u5efa\u5931\u8d25\uff0c\u5ffd\u7565{}\u5b57\u6bb5", (Object)field.getName(), (Object)e);
            }
            log.info("\u81ea\u5b9a\u4e49\u6784\u5efaPropertyDescriptor\u6210\u529f");
            try {
                customPropertyDescriptor = BeanUtils.convert(field, new PropertyDescriptor(name, readMethod, writeMethod), clazz);
            }
            catch (IntrospectionException e1) {
                log.info("\u6784\u5efa\u5931\u8d25\uff0c\u5ffd\u7565\u5b57\u6bb5[{}]", (Object)field.getName(), (Object)e1);
            }
        }
        FIELD_DESC_CACHE.put(fieldCache, customPropertyDescriptor);
        return customPropertyDescriptor;
    }

    private static String getName(JsonProperty jsonProperty, XmlNode xmlNode, Field field) {
        String name = jsonProperty != null ? jsonProperty.value() : (xmlNode != null ? xmlNode.name() : field.getName());
        return name;
    }

    private static Method getMethod(String methodName, Class<?> clazz, Class<?> ... args) {
        Method method;
        try {
            method = clazz.getMethod(methodName, args);
        }
        catch (NoSuchMethodException e1) {
            method = null;
        }
        return method;
    }

    private static CustomPropertyDescriptor tryBuildFinal(Field field, Class<?> clazz) throws IntrospectionException {
        String readMethodName;
        String name = field.getName();
        log.debug("\u5c1d\u8bd5\u4e3afinal\u7c7b\u578b\u7684\u5b57\u6bb5{}\u521b\u5efa\u5b57\u6bb5\u8bf4\u660e", (Object)name);
        if (Boolean.class.isAssignableFrom(field.getType())) {
            log.debug("\u5b57\u6bb5\u662fboolean\u7c7b\u578b");
            readMethodName = name.startsWith("is") ? name : "is" + StringUtils.toFirstUpperCase(name);
        } else {
            log.debug("\u5b57\u6bb5\u4e0d\u662fboolean\u7c7b\u578b");
            readMethodName = "get" + StringUtils.toFirstUpperCase(name);
        }
        log.debug("\u731c\u6d4bfinal\u7c7b\u578b\u7684\u5b57\u6bb5{}\u7684read\u65b9\u6cd5\u540d\u4e3a{}", (Object)name, (Object)readMethodName);
        return BeanUtils.convert(field, new PropertyDescriptor(name, clazz, readMethodName, null), clazz);
    }

    private static CustomPropertyDescriptor convert(Field field, PropertyDescriptor descriptor, Class<?> clazz) {
        if (descriptor == null) {
            return null;
        }
        return new CustomPropertyDescriptor(descriptor.getName(), descriptor.getReadMethod(), descriptor.getWriteMethod(), clazz, field);
    }

    public static final class CustomPropertyDescriptor {
        private final String name;
        private final Method writeMethod;
        private final Method readMethod;
        private final Class<?> clazz;
        private final Field field;
        private Class<?> type;

        public CustomPropertyDescriptor(String name, Method readMethod, Method writeMethod, Class<?> clazz, Field field) {
            this.name = name;
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
            this.clazz = clazz;
            this.field = field;
            this.type = field.getType();
            if (readMethod != null) {
                readMethod.setAccessible(true);
            }
            if (writeMethod != null) {
                writeMethod.setAccessible(true);
            }
        }

        public boolean isGeneralType() {
            return ReflectUtil.isGeneralType(this.type);
        }

        public boolean isBasic() {
            return ReflectUtil.isBasic(this.type);
        }

        public Class<?> getRealType() {
            return this.type;
        }

        public String getTypeName() {
            return this.type.getName();
        }

        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return this.field.getAnnotation(clazz);
        }

        public String getName() {
            return this.name;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Field getField() {
            return this.field;
        }
    }

    private static final class FieldCache {
        private final Field field;
        private final Class<?> clazz;

        public FieldCache(Field field, Class<?> clazz) {
            if (field == null || clazz == null) {
                throw new NullPointerException("\u5b57\u6bb5\u548c\u5bf9\u5e94\u7684class\u4e0d\u80fd\u4e3anull");
            }
            this.field = field;
            this.clazz = clazz;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof FieldCache) {
                FieldCache fieldCache = (FieldCache)obj;
                return fieldCache.clazz.equals(this.clazz) && this.field.equals(fieldCache.field);
            }
            return false;
        }
    }
}

