/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common;

import com.joe.utils.common.DateUtil;

public class Assert {
    public static void isTimeZone(String beginTime, String endTime, String format) {
        DateUtil.parse(beginTime, format);
        DateUtil.parse(endTime, format);
        if (beginTime.compareTo(endTime) > 0) {
            throw new IllegalArgumentException("\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
    }

    public static void isTrue(boolean flag) {
        Assert.isTrue(flag, null);
    }

    public static void isTrue(boolean flag, String msg) {
        if (!flag) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isFalse(boolean flag) {
        Assert.isFalse(flag, null);
    }

    public static void isFalse(boolean flag, String msg) {
        if (flag) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void notNull(Object obj) {
        Assert.notNull(obj, null);
    }

    public static void notNull(Object obj, String msg) {
        if (obj == null) {
            throw new NullPointerException(msg);
        }
    }

    public static void notNull(Object[] objs) {
        Assert.notNull(objs, null);
    }

    public static void notNull(Object[] objs, String msg) {
        if (objs == null) {
            throw new NullPointerException(msg);
        }
        for (Object obj : objs) {
            Assert.notNull(obj, msg);
        }
    }
}

