/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Algorithm {
    public static <T> List<T> lcs(List<T> arg0, List<T> arg1, Comparator<T> comparator) {
        if (arg0 == null || arg1 == null) {
            return Collections.emptyList();
        }
        return Algorithm.lcs(arg0, arg1, comparator, 0, 0);
    }

    private static <T> List<T> lcs(List<T> arg0, List<T> arg1, Comparator<T> comparator, int i, int j) {
        if (arg0.size() == i || arg1.size() == j) {
            return new ArrayList(Math.min(arg0.size(), arg1.size()));
        }
        if (comparator.compare(arg0.get(i), arg1.get(j)) == 0) {
            T t = arg0.get(i);
            List<T> list = Algorithm.lcs(arg0, arg1, comparator, i + 1, j + 1);
            list.add(t);
            return list;
        }
        List<T> l1 = Algorithm.lcs(arg0, arg1, comparator, i + 1, j);
        List<T> l2 = Algorithm.lcs(arg0, arg1, comparator, i, j + 1);
        return l1.size() > l2.size() ? l1 : l2;
    }

    public static <T extends Comparable<T>> List<T> lcs(List<T> arg0, List<T> arg1) {
        if (arg0 == null || arg1 == null) {
            return Collections.emptyList();
        }
        return Algorithm.lcs(arg0, arg1, 0, 0);
    }

    private static <T extends Comparable<T>> List<T> lcs(List<T> arg0, List<T> arg1, int i, int j) {
        if (arg0.size() == i || arg1.size() == j) {
            return new ArrayList(Math.min(arg0.size(), arg1.size()));
        }
        if (arg0.get(i) != null && arg1.get(j) != null && ((Comparable)arg0.get(i)).compareTo(arg1.get(j)) == 0) {
            Comparable t = (Comparable)arg0.get(i);
            List<T> list = Algorithm.lcs(arg0, arg1, i + 1, j + 1);
            list.add(t);
            return list;
        }
        List<T> l1 = Algorithm.lcs(arg0, arg1, i + 1, j);
        List<T> l2 = Algorithm.lcs(arg0, arg1, i, j + 1);
        return l1.size() > l2.size() ? l1 : l2;
    }
}

