/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.collection;

import com.joe.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Tree<T> {
    private static final String ROOT = "root";
    private final Node<T> root = new Node<Object>("root", null);

    public T getData(String name) {
        Node<T> node = this.root.getNode(name);
        return node == null ? null : (T)node.getData();
    }

    public List<T> getAllChildData(String name) {
        Node<T> node = this.root.getNode(name);
        if (node == null) {
            return Collections.emptyList();
        }
        Map<String, Node<T>> nodeList = node.getChilds();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList datas = new ArrayList(nodeList.size());
        node.getChilds().values().forEach(n -> datas.add(n.getData()));
        return datas;
    }

    public T updateData(String name, T data) {
        Node<T> node = this.root.getNode(name);
        T old = null;
        if (node != null) {
            old = node.setData(data);
        }
        return old;
    }

    public boolean exit(String name) {
        return this.root.getNode(name) != null;
    }

    public void add(String name, T data) {
        this.root.addChild(name, data);
    }

    public void delete(String name) {
        this.delete(name, false);
    }

    public void delete(String name, boolean recursion) {
        this.root.delete(name, recursion);
    }

    public void clear() {
        this.root.getChilds().clear();
    }

    public static class Node<T> {
        private static final String SYMBOL = "/";
        private final String name;
        private final String prex;
        private final Node<T> parent;
        private T data;
        private final Map<String, Node<T>> childs;

        Node(String name, String prex, T data, Node<T> parent) {
            this.name = name;
            this.prex = prex;
            this.data = data;
            this.parent = parent;
            this.childs = new ConcurrentHashMap<String, Node<T>>();
        }

        Node(String name, T data) {
            this(name, SYMBOL, data, null);
        }

        public void clear() {
            this.childs.clear();
        }

        public void deleteSelf() {
            if (this.isRoot()) {
                throw new IllegalStateException("root node can't be delete self");
            }
            this.parent.childs.remove(this.getName());
        }

        public String getFullName() {
            return this.prex + this.name;
        }

        public String getName() {
            return this.name;
        }

        public T getData() {
            return this.data;
        }

        public T setData(T data) {
            T old = this.data;
            this.data = data;
            return old;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public Node<T> addChild(String name, T data) {
            if (name == null || name.isEmpty()) {
                throw new NullPointerException("node name must not be null or empty");
            }
            if (!(name = StringUtils.trim(name, SYMBOL)).contains(SYMBOL)) {
                Node<T> node = new Node<T>(name, this.getFullName() + SYMBOL, data, this);
                Node<T> old = this.addChildNode(name, node);
                if (old != null) {
                    old.setData(data);
                }
                return old;
            }
            String[] names = name.split(SYMBOL);
            Node<Object> oldNode = this;
            for (String str : names) {
                Node<Object> node = new Node<Object>(str, oldNode.getFullName() + SYMBOL, null, oldNode);
                Node<Object> old = oldNode.addChildNode(str, node);
                oldNode = old == null ? node : old;
            }
            oldNode.setData(data);
            return oldNode;
        }

        public boolean hasChilds() {
            return !this.childs.isEmpty();
        }

        public Node<T> getParent() {
            return this.parent;
        }

        public Map<String, Node<T>> getChilds() {
            return this.childs;
        }

        public Node<T> getNode(String name) {
            if (name == null || name.isEmpty()) {
                throw new NullPointerException("node name must not be null or empty");
            }
            if (!(name = StringUtils.trim(name, SYMBOL)).contains(SYMBOL)) {
                return this.childs.get(name);
            }
            String[] names = name.split(SYMBOL);
            Node<T> node = this;
            for (String str : names) {
                if ((node = node.getNode(str)) != null) continue;
                return null;
            }
            return node;
        }

        public void delete(String name, boolean recursion) {
            if (name == null || name.isEmpty()) {
                throw new NullPointerException("node name must not be null or empty");
            }
            Node<T> node = this.getNode(name = StringUtils.trim(name, SYMBOL));
            if (node == null) {
                return;
            }
            if (!recursion && node.hasChilds()) {
                throw new IllegalStateException("node[" + name + "] hava child node , can't be delete");
            }
            node.deleteSelf();
        }

        public Node<T> addChildNode(String name, Node<T> node) {
            return this.childs.putIfAbsent(name, node);
        }
    }
}

