/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.collection;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class FixedQueue<E>
extends ArrayBlockingQueue<E>
implements Queue<E> {
    private static final long serialVersionUID = 159601021495564389L;
    private final Object lock = new Object();
    private int maxSize;

    public FixedQueue() {
        this(500);
    }

    public FixedQueue(int capacity) {
        super(capacity);
        if (capacity <= 0) {
            capacity = 500;
        }
        this.maxSize = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        Object object = this.lock;
        synchronized (object) {
            if (this.size() > this.maxSize) {
                this.poll();
            }
            return super.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Object object = this.lock;
        synchronized (object) {
            if (this.size() > this.maxSize) {
                this.poll();
            }
            return super.offer(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.size() > this.maxSize) {
                this.poll();
            }
            super.put(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.size() > this.maxSize) {
                this.poll();
            }
            return super.offer(e, timeout, unit);
        }
    }
}

