/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.collection;

import com.joe.utils.collection.CollectionException;
import com.joe.utils.math.MathUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public final class CollectionUtil {
    public static Object[][] matrixTransform(Object[][] datas) {
        if (datas.length == 0 || datas[0].length == 0) {
            return datas;
        }
        int column = datas.length;
        int row = datas[0].length;
        Object[][] newData = new Object[row][column];
        for (int i = 0; i < row; ++i) {
            Object[] list = new Object[column];
            for (int j = 0; j < column; ++j) {
                list[j] = datas[j][i];
            }
            newData[i] = list;
        }
        return newData;
    }

    public static <T> List<List<T>> matrixTransform(List<List<T>> datas) {
        if (datas.size() == 0 || datas.get(0).size() == 0) {
            return datas;
        }
        int column = datas.size();
        int row = datas.get(0).size();
        ArrayList<List<T>> newData = new ArrayList<List<T>>(row);
        for (int i = 0; i < row; ++i) {
            ArrayList<T> list = new ArrayList<T>(column);
            for (int j = 0; j < column; ++j) {
                list.add(datas.get(j).get(i));
            }
            newData.add(list);
        }
        return newData;
    }

    public static boolean safeIsEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean safeIsEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static ByteBuffer grow(ByteBuffer buffer, int size) {
        return CollectionUtil.grow(buffer, 0, buffer.capacity(), size);
    }

    public static ByteBuffer grow(ByteBuffer buffer, int offset, int len, int size) {
        ByteBuffer newBuffer;
        if ((size | offset | len) <= 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        if (offset >= buffer.capacity()) {
            throw new ArrayIndexOutOfBoundsException("offset\u5fc5\u987b\u5c0f\u4e8e\u539f\u7f13\u51b2\u533a\u7684capacity");
        }
        if (offset + len > buffer.capacity()) {
            len = buffer.capacity() - offset;
        }
        if (buffer.capacity() == Integer.MAX_VALUE) {
            throw new OutOfMemoryError("\u5f53\u524d\u7f13\u51b2\u533a\u5df2\u7ecf\u8fbe\u5230\u6700\u5927\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6269\u5bb9");
        }
        int newSize = buffer.capacity() + size;
        if (newSize < 0) {
            throw new OutOfMemoryError("buffer\u539f\u5927\u5c0f\u4e3a\uff1a" + buffer.capacity() + "\uff1b\u8981\u6269\u5bb9\u7684\u5927\u5c0f\u4e3a\uff1a" + size + "\uff1b\u5927\u4e8eint\u6700\u5927\u503c\uff0c\u8bf7\u8c03\u6574size");
        }
        if (buffer.isDirect()) {
            newBuffer = ByteBuffer.allocateDirect(newSize);
            byte[] data = new byte[len];
            buffer.position(offset);
            buffer.get(data);
            newBuffer.put(data);
        } else {
            newBuffer = ByteBuffer.allocate(newSize);
            byte[] data = buffer.array();
            newBuffer.put(data, offset, len);
        }
        newBuffer.position(len);
        return newBuffer;
    }

    public static <T> List<T> innerJoin(List<List<T>> list, BiFunction<T, T, T> function) {
        if (list == null || function == null) {
            throw new NullPointerException("list or function must not be null");
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        List<List<T>> result = CollectionUtil.innerJoin(list.get(0), list.get(1), function);
        if (list.size() == 2) {
            return CollectionUtil.merge(result);
        }
        for (int i = 2; i < list.size(); ++i) {
            List l1 = list.get(i);
            ArrayList temp = new ArrayList();
            result.stream().forEach(l -> temp.addAll(CollectionUtil.innerJoin(l, l1, function)));
            result = temp;
        }
        return CollectionUtil.merge(result);
    }

    public static <T> List<T> merge(List<List<T>> list) {
        ArrayList result = new ArrayList();
        list.stream().forEach(result::addAll);
        return result;
    }

    public static <T> List<List<T>> innerJoin(List<T> l1, List<T> l2, BiFunction<T, T, T> function) {
        if (l1 == null || l2 == null) {
            throw new NullPointerException("inner join arrays must not be null");
        }
        if (l1.isEmpty() && l2.isEmpty()) {
            return Collections.emptyList();
        }
        if (l1.isEmpty()) {
            return Collections.singletonList(l2);
        }
        if (l2.isEmpty()) {
            return Collections.singletonList(l1);
        }
        ArrayList result = new ArrayList(l1.size() * l2.size());
        l1.stream().forEach(t1 -> {
            ArrayList l = new ArrayList();
            l2.stream().forEach(t2 -> l.add(function.apply(t1, t2)));
            result.add(l);
        });
        return result;
    }

    public static <T> List<List<T>> permutations(List<T> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        long size = MathUtil.factorial(list.size());
        if (size > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("\u5168\u6392\u5217\u7ed3\u679c\u96c6\u5927\u5c0f\u4e3a[" + size + "]\uff0c\u8d85\u8fc7\u6570\u7ec4\u80fd\u5bb9\u7eb3\u7684\u6700\u5927\u7ed3\u679c");
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>((int)size);
        CollectionUtil.permutations(result, list, 0);
        return null;
    }

    public static <K, V> void clear(Map<K, V> map) {
        if (map != null) {
            map.clear();
        }
    }

    public static <T> void clear(Collection<T> collection) {
        if (collection != null) {
            collection.clear();
        }
    }

    public static <T> void remove(List<T> list, List<Integer> removes) {
        if (!(list instanceof ArrayList)) {
            list = new ArrayList<T>(list);
        }
        int flag = 0;
        for (int i = 0; i < removes.size(); ++i) {
            if (flag >= removes.get(i)) {
                throw new CollectionException("\u5220\u9664\u96c6\u5408\u4e2d\u591a\u4e2a\u5143\u7d20\u65f6\u6307\u9488\u5e94\u8be5\u6309\u7167\u4ece\u5c0f\u5230\u5927\u7684\u987a\u5e8f\u6392\u5e8f");
            }
            flag = removes.get(i);
            list.remove(flag - i);
        }
    }

    public static <T> void permutations(List<List<T>> result, List<T> args, int index) {
        if (index == args.size() - 2) {
            ArrayList<T> temp1 = new ArrayList<T>(args.size());
            temp1.addAll(args);
            Collections.swap(temp1, index, index + 1);
            result.add(temp1);
            ArrayList<T> temp2 = new ArrayList<T>(args.size());
            temp2.addAll(args);
            result.add(temp2);
            return;
        }
        CollectionUtil.permutations(result, args, index + 1);
        for (int i = index; i < args.size() - 1; ++i) {
            ArrayList<T> temp = new ArrayList<T>(args.size());
            temp.addAll(args);
            Collections.swap(temp, index, i + 1);
            CollectionUtil.permutations(result, temp, index + 1);
        }
    }
}

