/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.collection;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ByteArray
implements Iterable<Byte> {
    private volatile int modCount = 0;
    private byte[] datas = null;
    private int size = 0;

    public ByteArray() {
        this(256);
    }

    public ByteArray(byte[] initial) {
        this.datas = new byte[initial.length * 3 / 2];
        this.size = 0;
        this.append(initial);
    }

    public ByteArray(int initial) {
        this.datas = new byte[initial];
        this.size = 0;
    }

    public void append(byte[] data, int start, int len) {
        if (len <= 0) {
            return;
        }
        byte[] newData = new byte[len];
        System.arraycopy(data, 0, newData, 0, len);
        this.append(newData);
    }

    public void append(byte[] data) {
        if (data.length >= this.datas.length - this.size) {
            byte[] newData = new byte[this.datas.length + data.length + this.datas.length / 2];
            System.arraycopy(this.datas, 0, newData, 0, this.size);
            this.datas = newData;
        }
        System.arraycopy(data, 0, this.datas, this.size, data.length);
        this.size += data.length;
        ++this.modCount;
    }

    public void append(byte data) {
        if (0 >= this.datas.length - this.size) {
            byte[] newData = new byte[256 + this.size];
            System.arraycopy(this.datas, 0, newData, 0, this.size);
            this.datas = newData;
        }
        this.datas[this.size] = data;
        ++this.size;
        ++this.modCount;
    }

    public byte[] getData() {
        byte[] data = new byte[this.size];
        System.arraycopy(this.datas, 0, data, 0, this.size);
        return data;
    }

    public int size() {
        return this.size;
    }

    public byte get(int index) throws IndexOutOfBoundsException {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("\u6570\u7ec4\u5927\u5c0f\u4e3a\uff1a" + this.size + ";\u4e0b\u6807\u4e3a\uff1a" + index);
        }
        return this.datas[index];
    }

    public void replace(byte data, int index) throws IndexOutOfBoundsException {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("\u6570\u7ec4\u5927\u5c0f\u4e3a\uff1a" + this.size + ";\u4e0b\u6807\u4e3a\uff1a" + index);
        }
        this.datas[index] = data;
    }

    @Override
    public Iterator<Byte> iterator() {
        return new ByteArrayIterator(this);
    }

    private class ByteArrayIterator
    implements Iterator<Byte> {
        int expectedModCount;
        private final ByteArray byteArray;
        private int point;

        ByteArrayIterator(ByteArray byteArray2) {
            this.expectedModCount = ByteArray.this.modCount;
            this.point = 0;
            this.byteArray = byteArray2;
        }

        @Override
        public boolean hasNext() {
            return this.byteArray.size > this.point;
        }

        @Override
        public Byte next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("\u6ca1\u6709\u66f4\u591a\u6570\u636e\u4e86");
            }
            this.checkForComodification();
            return this.byteArray.get(this.point++);
        }

        final void checkForComodification() {
            if (ByteArray.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

