/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.cluster.redis;

import com.joe.utils.cluster.redis.RedisBaseConfig;

public class RedisSingleServerConfig
extends RedisBaseConfig {
    private String address;
    private int subscriptionConnectionMinimumIdleSize = 1;
    private int subscriptionConnectionPoolSize = 50;
    private int connectionMinimumIdleSize = 10;
    private int connectionPoolSize = 64;
    private int database = 0;
    private boolean dnsMonitoring = false;
    private long dnsMonitoringInterval = 5000L;

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisSingleServerConfig)) {
            return false;
        }
        RedisSingleServerConfig other = (RedisSingleServerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        if (this.getSubscriptionConnectionMinimumIdleSize() != other.getSubscriptionConnectionMinimumIdleSize()) {
            return false;
        }
        if (this.getSubscriptionConnectionPoolSize() != other.getSubscriptionConnectionPoolSize()) {
            return false;
        }
        if (this.getConnectionMinimumIdleSize() != other.getConnectionMinimumIdleSize()) {
            return false;
        }
        if (this.getConnectionPoolSize() != other.getConnectionPoolSize()) {
            return false;
        }
        if (this.getDatabase() != other.getDatabase()) {
            return false;
        }
        if (this.isDnsMonitoring() != other.isDnsMonitoring()) {
            return false;
        }
        return this.getDnsMonitoringInterval() == other.getDnsMonitoringInterval();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RedisSingleServerConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        result = result * 59 + this.getSubscriptionConnectionMinimumIdleSize();
        result = result * 59 + this.getSubscriptionConnectionPoolSize();
        result = result * 59 + this.getConnectionMinimumIdleSize();
        result = result * 59 + this.getConnectionPoolSize();
        result = result * 59 + this.getDatabase();
        result = result * 59 + (this.isDnsMonitoring() ? 79 : 97);
        long $dnsMonitoringInterval = this.getDnsMonitoringInterval();
        result = result * 59 + (int)($dnsMonitoringInterval >>> 32 ^ $dnsMonitoringInterval);
        return result;
    }

    public String getAddress() {
        return this.address;
    }

    public int getSubscriptionConnectionMinimumIdleSize() {
        return this.subscriptionConnectionMinimumIdleSize;
    }

    public int getSubscriptionConnectionPoolSize() {
        return this.subscriptionConnectionPoolSize;
    }

    public int getConnectionMinimumIdleSize() {
        return this.connectionMinimumIdleSize;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public int getDatabase() {
        return this.database;
    }

    public boolean isDnsMonitoring() {
        return this.dnsMonitoring;
    }

    public long getDnsMonitoringInterval() {
        return this.dnsMonitoringInterval;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setSubscriptionConnectionMinimumIdleSize(int subscriptionConnectionMinimumIdleSize) {
        this.subscriptionConnectionMinimumIdleSize = subscriptionConnectionMinimumIdleSize;
    }

    public void setSubscriptionConnectionPoolSize(int subscriptionConnectionPoolSize) {
        this.subscriptionConnectionPoolSize = subscriptionConnectionPoolSize;
    }

    public void setConnectionMinimumIdleSize(int connectionMinimumIdleSize) {
        this.connectionMinimumIdleSize = connectionMinimumIdleSize;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public void setDnsMonitoring(boolean dnsMonitoring) {
        this.dnsMonitoring = dnsMonitoring;
    }

    public void setDnsMonitoringInterval(long dnsMonitoringInterval) {
        this.dnsMonitoringInterval = dnsMonitoringInterval;
    }

    @Override
    public String toString() {
        return "RedisSingleServerConfig(address=" + this.getAddress() + ", subscriptionConnectionMinimumIdleSize=" + this.getSubscriptionConnectionMinimumIdleSize() + ", subscriptionConnectionPoolSize=" + this.getSubscriptionConnectionPoolSize() + ", connectionMinimumIdleSize=" + this.getConnectionMinimumIdleSize() + ", connectionPoolSize=" + this.getConnectionPoolSize() + ", database=" + this.getDatabase() + ", dnsMonitoring=" + this.isDnsMonitoring() + ", dnsMonitoringInterval=" + this.getDnsMonitoringInterval() + ")";
    }
}

