/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.cluster.redis;

import com.joe.utils.cluster.redis.RedisBaseConfig;
import com.joe.utils.cluster.redis.RedisClusterManager;
import com.joe.utils.cluster.redis.RedisSingleServerConfig;
import com.joe.utils.common.BeanUtils;
import java.util.HashMap;
import java.util.Map;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;

public class RedisClusterManagerFactory {
    private static final Map<RedisBaseConfig, RedisClusterManager> CACHE = new HashMap<RedisBaseConfig, RedisClusterManager>();
    private static final Object lock = new Object();

    public static RedisClusterManager getInstance(String host, int port) {
        return RedisClusterManagerFactory.getInstance(host, port, null);
    }

    public static RedisClusterManager getInstance(String host, int port, String password) {
        return RedisClusterManagerFactory.getInstance(RedisClusterManagerFactory.buildRedisConfig(host, port, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedisClusterManager getInstance(RedisBaseConfig redisBaseConfig) {
        if (!CACHE.containsKey(redisBaseConfig)) {
            Object object = lock;
            synchronized (object) {
                if (!CACHE.containsKey(redisBaseConfig)) {
                    CACHE.put(redisBaseConfig, RedisClusterManagerFactory.newInstance(redisBaseConfig));
                }
            }
        }
        return CACHE.get(redisBaseConfig);
    }

    public static RedisClusterManager newInstance(String host, int port) {
        return RedisClusterManagerFactory.newInstance(host, port, null);
    }

    public static RedisClusterManager newInstance(String host, int port, String password) {
        return RedisClusterManagerFactory.newInstance(RedisClusterManagerFactory.buildRedisConfig(host, port, password));
    }

    public static RedisClusterManager newInstance(RedisBaseConfig redisBaseConfig) {
        return new RedisClusterManager(RedisClusterManagerFactory.buildRedissonClient(redisBaseConfig));
    }

    public static RedisSingleServerConfig buildRedisConfig(String host, int port, String password) {
        RedisSingleServerConfig config = new RedisSingleServerConfig();
        config.setAddress(host + ":" + port);
        config.setPassword(password);
        return config;
    }

    private static RedissonClient buildRedissonClient(RedisBaseConfig redisBaseConfig) {
        Config config = new Config();
        if (!(redisBaseConfig instanceof RedisSingleServerConfig)) {
            throw new IllegalArgumentException("\u4f4d\u7f6e\u7684\u914d\u7f6e\u7c7b\u578b\uff1a" + redisBaseConfig.getClass());
        }
        RedisSingleServerConfig redisSingleServerConfig = (RedisSingleServerConfig)redisBaseConfig;
        SingleServerConfig singleServerConfig = config.useSingleServer();
        BeanUtils.copy(singleServerConfig, (Object)redisSingleServerConfig);
        singleServerConfig.setAddress(redisSingleServerConfig.getAddress());
        return Redisson.create((Config)config);
    }
}

