/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.cluster.redis;

import com.joe.utils.cluster.ClusterManager;
import com.joe.utils.cluster.Topic;
import com.joe.utils.cluster.redis.RedisTopic;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.redisson.api.RObject;
import org.redisson.api.RedissonClient;

public class RedisClusterManager
implements ClusterManager {
    private RedissonClient redissonClient;

    RedisClusterManager(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    @Override
    public Lock getLock(String name) {
        return this.redissonClient.getLock(name);
    }

    @Override
    public ReadWriteLock getReadWriteLock(String name) {
        return this.redissonClient.getReadWriteLock(name);
    }

    @Override
    public <V> BlockingDeque<V> getBlockingDeque(String name) {
        return this.redissonClient.getBlockingDeque(name);
    }

    @Override
    public <V> BlockingQueue<V> getBlockingQueue(String name) {
        return this.redissonClient.getBlockingQueue(name);
    }

    @Override
    public <V> List<V> getList(String name) {
        return this.redissonClient.getList(name);
    }

    @Override
    public <K, V> Map<K, V> getMap(String name) {
        return this.redissonClient.getMap(name);
    }

    @Override
    public <K, V> ConcurrentMap<K, V> getConcurrentMap(String name) {
        return this.redissonClient.getMap(name);
    }

    @Override
    public <K> Set<K> getSet(String name) {
        return this.redissonClient.getSet(name);
    }

    @Override
    public <M> Topic<M> getTopic(String name) {
        return new RedisTopic(this.redissonClient.getTopic(name));
    }

    @Override
    public void shutdown() {
        this.redissonClient.shutdown();
    }

    @Override
    public boolean free(Object obj) {
        if (obj instanceof RObject) {
            RObject rObject = (RObject)obj;
            return rObject.delete();
        }
        return false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.redissonClient.shutdown();
    }
}

