/*
 * Decompiled with CFR 0.152.
 */
package com.joe.utils.cluster;

import com.joe.utils.cluster.Topic;
import com.joe.utils.cluster.redis.RedisBaseConfig;
import com.joe.utils.cluster.redis.RedisClusterManager;
import com.joe.utils.cluster.redis.RedisClusterManagerFactory;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public interface ClusterManager {
    public Lock getLock(String var1);

    public ReadWriteLock getReadWriteLock(String var1);

    public <V> BlockingDeque<V> getBlockingDeque(String var1);

    public <V> BlockingQueue<V> getBlockingQueue(String var1);

    public <V> List<V> getList(String var1);

    public <K, V> Map<K, V> getMap(String var1);

    public <K, V> ConcurrentMap<K, V> getConcurrentMap(String var1);

    public <K> Set<K> getSet(String var1);

    public <M> Topic<M> getTopic(String var1);

    public boolean free(Object var1);

    public void shutdown();

    public static RedisClusterManager getInstance(String host, int port) throws MalformedURLException {
        return RedisClusterManagerFactory.getInstance(host, port);
    }

    public static RedisClusterManager getInstance(String host, int port, String password) throws MalformedURLException {
        return RedisClusterManagerFactory.getInstance(host, port, password);
    }

    public static RedisClusterManager getInstance(RedisBaseConfig redisBaseConfig) {
        return RedisClusterManagerFactory.getInstance(redisBaseConfig);
    }
}

