/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.component;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.PerTicketManager;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenManager;

public class WeixinTokenComponentCreator
extends TokenCreator {
    private final PerTicketManager perTicketManager;
    private final TokenManager componentTokenManager;

    public WeixinTokenComponentCreator(PerTicketManager perTicketManager, TokenManager componentTokenManager) {
        this.perTicketManager = perTicketManager;
        this.componentTokenManager = componentTokenManager;
    }

    public String key0() {
        return String.format("mp_token_component_%s_%s", this.perTicketManager.getThirdId(), this.perTicketManager.getAuthAppId());
    }

    public Token create() throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("component_appid", (Object)this.perTicketManager.getThirdId());
        obj.put("authorizer_appid", (Object)this.perTicketManager.getAuthAppId());
        obj.put("authorizer_refresh_token", (Object)this.perTicketManager.getAccessTicket());
        WeixinResponse response = this.weixinExecutor.post(String.format("https://api.weixin.qq.com/cgi-bin/component/api_authorizer_token?component_access_token=%s", this.componentTokenManager.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        return new Token(obj.getString("access_token"), obj.getLongValue("expires_in") * 1000L);
    }
}

