/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.mp.model.Following;
import com.foxinmy.weixin4j.mp.model.User;
import com.foxinmy.weixin4j.mp.type.Lang;
import com.foxinmy.weixin4j.token.TokenManager;
import java.util.ArrayList;
import java.util.List;

public class UserApi
extends MpApi {
    private final TokenManager tokenManager;

    public UserApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public User getUser(String openId) throws WeixinException {
        return this.getUser(openId, Lang.zh_CN);
    }

    public User getUser(String openId, Lang lang) throws WeixinException {
        String user_info_uri = this.getRequestUri("api_user_info_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(user_info_uri, token.getAccessToken(), openId, lang.name()), new URLParameter[0]);
        return (User)response.getAsObject((TypeReference)new TypeReference<User>(){});
    }

    public List<User> getUsers(String ... openIds) throws WeixinException {
        return this.getUsers(Lang.zh_CN, openIds);
    }

    public List<User> getUsers(Lang lang, String ... openIds) throws WeixinException {
        String api_users_info_uri = this.getRequestUri("api_users_info_uri");
        StringBuilder parameter = new StringBuilder();
        parameter.append("{\"user_list\": [");
        for (String openId : openIds) {
            parameter.append("{\"openid\": \"").append(openId).append("\"");
            parameter.append(",\"lang\": \"").append(lang.name()).append("\"").append("},");
        }
        parameter.delete(parameter.length() - 1, parameter.length());
        parameter.append("]}");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(api_users_info_uri, token.getAccessToken()), parameter.toString());
        return JSON.parseArray((String)response.getAsJson().getString("user_info_list"), User.class);
    }

    public Following getFollowing(String nextOpenId) throws WeixinException {
        Following following = this.getFollowingOpenIds(nextOpenId);
        if (following.getCount() > 0) {
            ArrayList<User> users = new ArrayList<User>(following.getCount());
            for (int i = 1; i <= (int)Math.ceil((double)following.getCount() / 100.0); ++i) {
                users.addAll(this.getUsers(following.getOpenIds().subList((i - 1) * 100, Math.min(i * 100, following.getCount())).toArray(new String[0])));
            }
            following.setUserList(users);
        }
        return following;
    }

    public Following getFollowingOpenIds(String nextOpenId) throws WeixinException {
        String following_uri = this.getRequestUri("following_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(following_uri, token.getAccessToken(), nextOpenId == null ? "" : nextOpenId), new URLParameter[0]);
        JSONObject result = response.getAsJson();
        Following following = (Following)JSON.toJavaObject((JSON)result, Following.class);
        if (following.getCount() > 0) {
            following.setOpenIds(JSON.parseArray((String)result.getJSONObject("data").getString("openid"), String.class));
        }
        return following;
    }

    public List<User> getAllFollowing() throws WeixinException {
        ArrayList<User> userList = new ArrayList<User>();
        String nextOpenId = null;
        Following f = null;
        while ((f = this.getFollowing(nextOpenId)).hasContent()) {
            userList.addAll(f.getUserList());
            nextOpenId = f.getNextOpenId();
        }
        return userList;
    }

    public List<String> getAllFollowingOpenIds() throws WeixinException {
        ArrayList<String> openIds = new ArrayList<String>();
        String nextOpenId = null;
        Following f = null;
        while ((f = this.getFollowingOpenIds(nextOpenId)).hasContent()) {
            openIds.addAll(f.getOpenIds());
            nextOpenId = f.getNextOpenId();
        }
        return openIds;
    }

    public ApiResult remarkUserName(String openId, String remark) throws WeixinException {
        String username_remark_uri = this.getRequestUri("username_remark_uri");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("openid", (Object)openId);
        obj.put("remark", (Object)remark);
        WeixinResponse response = this.weixinExecutor.post(String.format(username_remark_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }
}

