/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.foxinmy.weixin4j.cache.CacheStorager;
import com.foxinmy.weixin4j.cache.FileCacheStorager;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.entity.FormUrlEntity;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.mp.oldpayment.OrderV2;
import com.foxinmy.weixin4j.mp.oldpayment.PayPackageV2;
import com.foxinmy.weixin4j.mp.oldpayment.RefundRecordV2;
import com.foxinmy.weixin4j.mp.oldpayment.RefundResultV2;
import com.foxinmy.weixin4j.mp.oldpayment.WeixinOldPayAccount;
import com.foxinmy.weixin4j.mp.oldpayment.WeixinOldPaymentSignature;
import com.foxinmy.weixin4j.mp.token.WeixinTokenCreator;
import com.foxinmy.weixin4j.payment.PayRequest;
import com.foxinmy.weixin4j.sign.WeixinPaymentSignature;
import com.foxinmy.weixin4j.sign.WeixinSignature;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.type.IdQuery;
import com.foxinmy.weixin4j.type.SignType;
import com.foxinmy.weixin4j.type.mch.BillType;
import com.foxinmy.weixin4j.type.mch.RefundType;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.DateUtil;
import com.foxinmy.weixin4j.util.DigestUtil;
import com.foxinmy.weixin4j.util.MapUtil;
import com.foxinmy.weixin4j.util.RandomUtil;
import com.foxinmy.weixin4j.util.StringUtil;
import com.foxinmy.weixin4j.util.Weixin4jConfigUtil;
import com.foxinmy.weixin4j.xml.ListsuffixResultDeserializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class PayOldApi
extends MpApi {
    private final WeixinOldPayAccount weixinPayAccount;
    private final TokenManager tokenManager;
    private final WeixinSignature weixinMD5Signature;
    private final WeixinOldPaymentSignature weixinSignature;

    public PayOldApi() {
        this((CacheStorager<Token>)new FileCacheStorager());
    }

    public PayOldApi(CacheStorager<Token> cacheStorager) {
        this((WeixinOldPayAccount)((Object)JSON.parseObject((String)Weixin4jConfigUtil.getValue((String)"account"), WeixinOldPayAccount.class)), cacheStorager);
    }

    public PayOldApi(WeixinOldPayAccount weixinPayAccount, CacheStorager<Token> cacheStorager) {
        if (weixinPayAccount == null) {
            throw new IllegalArgumentException("weixinPayAccount must not be empty");
        }
        if (cacheStorager == null) {
            throw new IllegalArgumentException("cacheStorager must not be empty");
        }
        this.weixinPayAccount = weixinPayAccount;
        this.tokenManager = new TokenManager((TokenCreator)new WeixinTokenCreator(weixinPayAccount.getId(), weixinPayAccount.getSecret()), cacheStorager);
        this.weixinMD5Signature = new WeixinPaymentSignature(weixinPayAccount.getPartnerKey());
        this.weixinSignature = new WeixinOldPaymentSignature(weixinPayAccount.getPaySignKey(), weixinPayAccount.getPartnerKey());
    }

    public WeixinOldPayAccount getWeixinPayAccount() {
        return this.weixinPayAccount;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public WeixinOldPaymentSignature getWeixinPaymentSignature() {
        return this.weixinSignature;
    }

    public String createPayJsRequestJson(String body, String outTradeNo, double totalFee, String notifyUrl, String createIp) {
        PayPackageV2 payPackage = new PayPackageV2(this.weixinPayAccount.getPartnerId(), body, outTradeNo, totalFee, notifyUrl, createIp);
        return this.createPayJsRequestJson(payPackage);
    }

    public String createPayJsRequestJson(PayPackageV2 payPackage) {
        PayRequest payRequest = new PayRequest(this.weixinPayAccount.getId(), this.weixinSignature.sign(payPackage));
        payRequest.setPaySign(this.weixinSignature.sign(payRequest));
        payRequest.setSignType(SignType.SHA1);
        return JSON.toJSONString((Object)payRequest);
    }

    public String createNativePayRequestURL(String productId) {
        HashMap<String, String> map = new HashMap<String, String>();
        String timestamp = DateUtil.timestamp2string();
        String noncestr = RandomUtil.generateString((int)16);
        map.put("appid", this.weixinPayAccount.getId());
        map.put("timestamp", timestamp);
        map.put("noncestr", noncestr);
        map.put("productid", productId);
        map.put("appkey", this.weixinPayAccount.getPaySignKey());
        String sign = this.weixinSignature.sign(map);
        String nativepay_uri = this.getRequestUri("nativepay_old_uri");
        return String.format(nativepay_uri, sign, this.weixinPayAccount.getId(), productId, timestamp, noncestr);
    }

    public OrderV2 queryOrder(IdQuery idQuery) throws WeixinException {
        String orderquery_uri = this.getRequestUri("orderquery_old_uri");
        Token token = (Token)this.tokenManager.getCache();
        StringBuilder sb = new StringBuilder();
        sb.append(idQuery.getType().getName()).append("=").append(idQuery.getId());
        sb.append("&partner=").append(this.weixinPayAccount.getPartnerId());
        String part = sb.toString();
        sb.append("&key=").append(this.weixinPayAccount.getPartnerKey());
        String sign = DigestUtil.MD5((String)sb.toString()).toUpperCase();
        sb.delete(0, sb.length());
        sb.append(part).append("&sign=").append(sign);
        String timestamp = DateUtil.timestamp2string();
        JSONObject obj = new JSONObject();
        obj.put("appid", (Object)this.weixinPayAccount.getId());
        obj.put("appkey", (Object)this.weixinPayAccount.getPaySignKey());
        obj.put("package", (Object)sb.toString());
        obj.put("timestamp", (Object)timestamp);
        String signature = this.weixinSignature.sign(obj);
        obj.clear();
        obj.put("appid", (Object)this.weixinPayAccount.getId());
        obj.put("package", (Object)sb.toString());
        obj.put("timestamp", (Object)timestamp);
        obj.put("app_signature", (Object)signature);
        obj.put("sign_method", (Object)SignType.SHA1.name().toLowerCase());
        WeixinResponse response = this.weixinExecutor.post(String.format(orderquery_uri, token.getAccessToken()), obj.toJSONString());
        String order_info = response.getAsJson().getString("order_info");
        OrderV2 order = (OrderV2)JSON.parseObject((String)order_info, OrderV2.class, (Feature[])new Feature[]{Feature.IgnoreNotMatch});
        if (order.getRetCode() != 0) {
            throw new WeixinException(Integer.toString(order.getRetCode()), order.getRetMsg());
        }
        return order;
    }

    protected RefundResultV2 applyRefund(InputStream certificate, IdQuery idQuery, String outRefundNo, double totalFee, double refundFee, String opUserId, Map<String, String> mopara) throws WeixinException {
        String refund_uri = this.getRequestUri("refundapply_old_uri");
        WeixinResponse response = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("input_charset", Consts.UTF_8.name());
            map.put("service_version", "1.1");
            map.put("partner", this.weixinPayAccount.getPartnerId());
            map.put("out_refund_no", outRefundNo);
            map.put("total_fee", Integer.toString(DateUtil.formatYuan2Fen((double)totalFee)));
            map.put("refund_fee", Integer.toString(DateUtil.formatYuan2Fen((double)refundFee)));
            map.put(idQuery.getType().getName(), idQuery.getId());
            if (StringUtil.isBlank((CharSequence)opUserId)) {
                opUserId = this.weixinPayAccount.getPartnerId();
            }
            map.put("op_user_id", opUserId);
            if (mopara != null && !mopara.isEmpty()) {
                map.putAll(mopara);
            }
            String sign = this.weixinMD5Signature.sign(map);
            map.put("sign", sign.toUpperCase());
            SSLContext ctx = null;
            KeyStore ks = null;
            String jksPwd = "";
            File jksFile = new File(String.format("%s%stenpay_cacert.jks", System.getProperty("java.io.tmpdir"), File.separator));
            if (!jksFile.exists()) {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Certificate cert = cf.generateCertificate(PayOldApi.class.getResourceAsStream("cacert.pem"));
                ks = KeyStore.getInstance("JKS");
                ks.load(null, null);
                ks.setCertificateEntry("tenpay", cert);
                FileOutputStream os = new FileOutputStream(jksFile);
                ks.store(os, jksPwd.toCharArray());
                os.close();
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            ks = KeyStore.getInstance("JKS");
            FileInputStream is = new FileInputStream(jksFile);
            ks.load(is, jksPwd.toCharArray());
            tmf.init(ks);
            is.close();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            ks = KeyStore.getInstance("PKCS12");
            ks.load(certificate, this.weixinPayAccount.getPartnerId().toCharArray());
            kmf.init(ks, this.weixinPayAccount.getPartnerId().toCharArray());
            ctx = SSLContext.getInstance("TLS");
            ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
            response = this.weixinExecutor.createSSLRequestExecutor(ctx).get(String.format("%s?%s", refund_uri, FormUrlEntity.formatParameters(map)), new URLParameter[0]);
        }
        catch (WeixinException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WeixinException((Throwable)e);
        }
        finally {
            if (certificate != null) {
                try {
                    certificate.close();
                }
                catch (IOException e) {}
            }
        }
        return (RefundResultV2)response.getAsObject((TypeReference)new TypeReference<RefundResultV2>(){});
    }

    public RefundResultV2 applyRefund(InputStream certificate, IdQuery idQuery, String outRefundNo, double totalFee, double refundFee, String opUserId, String opUserPasswd) throws WeixinException {
        HashMap<String, String> mopara = new HashMap<String, String>();
        mopara.put("op_user_passwd", DigestUtil.MD5((String)opUserPasswd));
        return this.applyRefund(certificate, idQuery, outRefundNo, totalFee, refundFee, opUserId, mopara);
    }

    public RefundResultV2 applyRefund(InputStream certificate, IdQuery idQuery, String outRefundNo, double totalFee, double refundFee, String opUserId, String opUserPasswd, String recvUserId, String reccvUserName, RefundType refundType) throws WeixinException {
        HashMap<String, String> mopara = new HashMap<String, String>();
        mopara.put("op_user_passwd", DigestUtil.MD5((String)opUserPasswd));
        if (StringUtil.isNotBlank((CharSequence)recvUserId)) {
            mopara.put("recv_user_id", recvUserId);
        }
        if (StringUtil.isNotBlank((CharSequence)reccvUserName)) {
            mopara.put("reccv_user_name", reccvUserName);
        }
        if (refundType != null) {
            mopara.put("refund_type", Integer.toString(refundType.getVal()));
        }
        return this.applyRefund(certificate, idQuery, outRefundNo, totalFee, refundFee, opUserId, mopara);
    }

    public File downloadBill(Date billDate, BillType billType, String billPath) throws WeixinException {
        if (billDate == null) {
            Calendar now = Calendar.getInstance();
            now.add(5, -1);
            billDate = now.getTime();
        }
        if (billType == null) {
            billType = BillType.ALL;
        }
        String formatBillDate = DateUtil.fortmat2yyyyMMdd((Date)billDate);
        String fileName = String.format("weixin4j_bill_%s_%s_%s.txt", formatBillDate, billType.name().toLowerCase(), this.weixinPayAccount.getId());
        File file = new File(String.format("%s%s%s", billPath, File.separator, fileName));
        if (file.exists()) {
            return file;
        }
        String downloadbill_uri = this.getRequestUri("downloadbill_old_uri");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("spid", this.weixinPayAccount.getPartnerId());
        map.put("trans_time", DateUtil.fortmat2yyyy_MM_dd((Date)billDate));
        map.put("stamp", DateUtil.timestamp2string());
        map.put("cft_signtype", "0");
        map.put("mchtype", Integer.toString(billType.getVal()));
        map.put("key", this.weixinPayAccount.getPartnerKey());
        String sign = DigestUtil.MD5((String)MapUtil.toJoinString(map, (boolean)false, (boolean)false));
        map.put("sign", sign.toLowerCase());
        WeixinResponse response = this.weixinExecutor.get(String.format("%s?%s", downloadbill_uri, FormUrlEntity.formatParameters(map)), new URLParameter[0]);
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Consts.GBK));
            reader = new BufferedReader(new InputStreamReader(response.getBody(), Consts.GBK));
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new WeixinException((Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ignore) {}
        }
        return file;
    }

    public RefundRecordV2 queryRefund(IdQuery idQuery) throws WeixinException {
        String refundquery_uri = this.getRequestUri("refundquery_old_uri");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("input_charset", Consts.UTF_8.name());
        map.put("partner", this.weixinPayAccount.getPartnerId());
        map.put(idQuery.getType().getName(), idQuery.getId());
        String sign = this.weixinMD5Signature.sign(map);
        map.put("sign", sign.toLowerCase());
        WeixinResponse response = this.weixinExecutor.get(String.format(refundquery_uri, FormUrlEntity.formatParameters(map)), new URLParameter[0]);
        return (RefundRecordV2)ListsuffixResultDeserializer.deserialize((String)response.getAsString(), RefundRecordV2.class);
    }

    public ApiResult deliverNotify(String openId, String transid, String outTradeNo, boolean status, String statusMsg) throws WeixinException {
        String delivernotify_uri = this.getRequestUri("delivernotify_old_uri");
        Token token = (Token)this.tokenManager.getCache();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", this.weixinPayAccount.getId());
        map.put("appkey", this.weixinPayAccount.getPaySignKey());
        map.put("openid", openId);
        map.put("transid", transid);
        map.put("out_trade_no", outTradeNo);
        map.put("deliver_timestamp", DateUtil.timestamp2string());
        map.put("deliver_status", status ? "1" : "0");
        map.put("deliver_msg", statusMsg);
        map.put("app_signature", this.weixinSignature.sign(map));
        map.put("sign_method", SignType.SHA1.name().toLowerCase());
        WeixinResponse response = this.weixinExecutor.post(String.format(delivernotify_uri, token.getAccessToken()), JSON.toJSONString(map));
        return response.getAsResult();
    }

    public ApiResult updateFeedback(String openId, String feedbackId) throws WeixinException {
        String payfeedback_uri = this.getRequestUri("payfeedback_old_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(payfeedback_uri, token.getAccessToken(), openId, feedbackId), new URLParameter[0]);
        return response.getAsResult();
    }
}

