/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Button;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.mp.model.Menu;
import com.foxinmy.weixin4j.mp.model.MenuMatchRule;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.type.ButtonType;
import com.foxinmy.weixin4j.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class MenuApi
extends MpApi {
    private final TokenManager tokenManager;
    private final ParseProcess buttonProcess = new ExtraProcessor(){

        public void processExtra(Object object, String key, Object value) {
            ((Button)object).setContent(String.valueOf(value));
        }
    };

    public MenuApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public ApiResult createMenu(List<Button> buttons) throws WeixinException {
        String menu_create_uri = this.getRequestUri("menu_create_uri");
        JSONObject obj = new JSONObject();
        obj.put("button", buttons);
        return this.createMenu0(menu_create_uri, obj).getAsResult();
    }

    private WeixinResponse createMenu0(String url, JSONObject data) throws WeixinException {
        return this.weixinExecutor.post(String.format(url, this.tokenManager.getAccessToken()), JSON.toJSONString((Object)data, (SerializeFilter)new NameFilter(){

            public String process(Object object, String name, Object value) {
                if (object instanceof Button && name.equals("content") && StringUtil.isNotBlank((CharSequence)((Button)object).getType())) {
                    ButtonType buttonType = ButtonType.valueOf((String)((Button)object).getType());
                    if (ButtonType.view == buttonType || ButtonType.miniprogram == buttonType) {
                        return "url";
                    }
                    if (ButtonType.media_id == buttonType || ButtonType.view_limited == buttonType) {
                        return "media_id";
                    }
                    return "key";
                }
                return name;
            }
        }, (SerializerFeature[])new SerializerFeature[0]));
    }

    public List<Button> getMenu() throws WeixinException {
        return this.buttonsConvertor(this.getMenu0().getJSONObject("menu"));
    }

    private JSONObject getMenu0() throws WeixinException {
        String menu_get_uri = this.getRequestUri("menu_get_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(menu_get_uri, token.getAccessToken()), new URLParameter[0]);
        return response.getAsJson();
    }

    public List<Menu> getAllMenu() throws WeixinException {
        JSONObject response = this.getMenu0();
        ArrayList<Menu> menus = new ArrayList<Menu>();
        JSONObject menuObj = response.getJSONObject("menu");
        menus.add(new Menu(menuObj.getString("menuid"), this.buttonsConvertor(menuObj), null));
        JSONArray menuObjs = response.getJSONArray("conditionalmenu");
        if (menuObjs != null && !menuObjs.isEmpty()) {
            for (int i = 0; i < menuObjs.size(); ++i) {
                menuObj = menuObjs.getJSONObject(i);
                menus.add(new Menu(menuObj.getString("menuid"), this.buttonsConvertor(menuObj), (MenuMatchRule)menuObj.getObject("matchrule", MenuMatchRule.class)));
            }
        }
        return menus;
    }

    public ApiResult deleteMenu() throws WeixinException {
        String menu_delete_uri = this.getRequestUri("menu_delete_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(menu_delete_uri, token.getAccessToken()), new URLParameter[0]);
        return response.getAsResult();
    }

    public String createCustomMenu(List<Button> buttons, MenuMatchRule matchRule) throws WeixinException {
        String menu_create_uri = this.getRequestUri("menu_custom_create_uri");
        JSONObject obj = new JSONObject();
        obj.put("button", buttons);
        obj.put("matchrule", (Object)matchRule.getRule());
        return this.createMenu0(menu_create_uri, obj).getAsJson().getString("menuid");
    }

    public ApiResult deleteCustomMenu(String menuId) throws WeixinException {
        String menu_delete_uri = this.getRequestUri("menu_delete_custom_uri");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("menuid", (Object)menuId);
        WeixinResponse response = this.weixinExecutor.post(String.format(menu_delete_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public List<Button> matchCustomMenu(String userId) throws WeixinException {
        String menu_trymatch_uri = this.getRequestUri("menu_trymatch_uri");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("user_id", (Object)userId);
        WeixinResponse response = this.weixinExecutor.post(String.format(menu_trymatch_uri, token.getAccessToken()), obj.toJSONString());
        return this.buttonsConvertor(response.getAsJson().getJSONObject("menu"));
    }

    private List<Button> buttonsConvertor(JSONObject menu) {
        JSONArray buttons = menu.getJSONArray("button");
        ArrayList<Button> buttonList = new ArrayList<Button>(buttons.size());
        for (int i = 0; i < buttons.size(); ++i) {
            buttonList.add((Button)JSON.parseObject((String)buttons.getString(i), Button.class, (ParseProcess)this.buttonProcess, (Feature[])new Feature[0]));
        }
        return buttonList;
    }
}

