/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.tuple.MassTuple;
import com.foxinmy.weixin4j.tuple.MpArticle;
import com.foxinmy.weixin4j.tuple.MpNews;
import com.foxinmy.weixin4j.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MassApi
extends MpApi {
    private final TokenManager tokenManager;
    private static final Map<String, String> massStatusMap = new HashMap<String, String>();

    public MassApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public String uploadArticle(List<MpArticle> articles) throws WeixinException {
        String article_upload_uri = this.getRequestUri("article_upload_uri");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("articles", articles);
        WeixinResponse response = this.weixinExecutor.post(String.format(article_upload_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsJson().getString("media_id");
    }

    @Deprecated
    public String[] massByGroupId(MassTuple tuple, boolean isToAll, int groupId) throws WeixinException {
        if (tuple instanceof MpNews) {
            MpNews _news = (MpNews)tuple;
            List _articles = _news.getArticles();
            if (StringUtil.isBlank((CharSequence)_news.getMediaId())) {
                if (_articles.isEmpty()) {
                    throw new WeixinException("mass fail:mediaId or articles is required");
                }
                tuple = new MpNews(this.uploadArticle(_articles));
            }
        }
        String msgtype = tuple.getMessageType();
        JSONObject obj = new JSONObject();
        JSONObject item = new JSONObject();
        item.put("is_to_all", (Object)isToAll);
        if (!isToAll) {
            item.put("group_id", (Object)groupId);
        }
        obj.put("filter", (Object)item);
        obj.put(msgtype, JSON.toJSON((Object)tuple));
        obj.put("msgtype", (Object)msgtype);
        String mass_group_uri = this.getRequestUri("mass_group_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(mass_group_uri, token.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        return new String[]{obj.getString("msg_id"), obj.getString("msg_data_id")};
    }

    @Deprecated
    public String[] massArticleByGroupId(List<MpArticle> articles, int groupId) throws WeixinException {
        String mediaId = this.uploadArticle(articles);
        return this.massByGroupId((MassTuple)new MpNews(mediaId), false, groupId);
    }

    private String[] mass(MassTuple tuple, JSONObject filter) throws WeixinException {
        if (tuple instanceof MpNews) {
            MpNews _news = (MpNews)tuple;
            List _articles = _news.getArticles();
            if (StringUtil.isBlank((CharSequence)_news.getMediaId())) {
                if (_articles.isEmpty()) {
                    throw new WeixinException("mass fail:mediaId or articles is required");
                }
                tuple = new MpNews(this.uploadArticle(_articles));
            }
            if (!filter.containsKey((Object)"send_ignore_reprint")) {
                filter.put("send_ignore_reprint", (Object)0);
            }
        }
        String msgtype = tuple.getMessageType();
        JSONObject obj = new JSONObject();
        obj.putAll((Map)filter);
        obj.put(msgtype, JSON.toJSON((Object)tuple));
        obj.put("msgtype", (Object)msgtype);
        String mass_group_uri = this.getRequestUri("mass_group_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(mass_group_uri, token.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        return new String[]{obj.getString("msg_id"), obj.getString("msg_data_id")};
    }

    public String[] massToAll(MassTuple tuple) throws WeixinException {
        String filter = String.format("{\"filter\":{\"is_to_all\":true}}", new Object[0]);
        return this.mass(tuple, JSON.parseObject((String)filter));
    }

    public String[] massByTagId(MassTuple tuple, int tagId) throws WeixinException {
        String filter = String.format("{\"filter\":{\"is_to_all\":false,\"tag_id\":%d}}", tagId);
        return this.mass(tuple, JSON.parseObject((String)filter));
    }

    public String[] massArticleByTagId(List<MpArticle> articles, int tagId, boolean ignoreReprint) throws WeixinException {
        String mediaId = this.uploadArticle(articles);
        String text = String.format("{\"filter\":{\"is_to_all\":false,\"tag_id\":%d}}", tagId);
        JSONObject filter = JSON.parseObject((String)text);
        filter.put("send_ignore_reprint", (Object)(ignoreReprint ? 1 : 0));
        return this.mass((MassTuple)new MpNews(mediaId), filter);
    }

    public String[] massByOpenIds(MassTuple tuple, String ... openIds) throws WeixinException {
        JSONObject filter = new JSONObject();
        filter.put("touser", (Object)openIds);
        return this.mass(tuple, filter);
    }

    public String[] massArticleByOpenIds(List<MpArticle> articles, boolean ignoreReprint, String ... openIds) throws WeixinException {
        String mediaId = this.uploadArticle(articles);
        JSONObject filter = new JSONObject();
        filter.put("touser", (Object)openIds);
        filter.put("send_ignore_reprint", (Object)(ignoreReprint ? 1 : 0));
        return this.mass((MassTuple)new MpNews(mediaId), filter);
    }

    public ApiResult deleteMassNews(String msgid) throws WeixinException {
        return this.deleteMassNews(msgid, 0);
    }

    public ApiResult deleteMassNews(String msgid, int articleIndex) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("msgid", (Object)msgid);
        if (articleIndex > 0) {
            obj.put("article_idx", (Object)articleIndex);
        }
        String mass_delete_uri = this.getRequestUri("mass_delete_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(mass_delete_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult previewMassNews(String toUser, String toWxName, MassTuple tuple) throws WeixinException {
        String msgtype = tuple.getMessageType();
        JSONObject obj = new JSONObject();
        obj.put("touser", (Object)toUser);
        obj.put("towxname", (Object)toWxName);
        obj.put(msgtype, JSON.toJSON((Object)tuple));
        obj.put("msgtype", (Object)msgtype);
        String mass_preview_uri = this.getRequestUri("mass_preview_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(mass_preview_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public String getMassNewStatus(String msgId) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("msg_id", (Object)msgId);
        String mass_get_uri = this.getRequestUri("mass_get_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(mass_get_uri, token.getAccessToken()), obj.toJSONString());
        String status = response.getAsJson().getString("msg_status");
        String desc = massStatusMap.get(status);
        return String.format("%s:%s", status, desc);
    }

    static {
        massStatusMap.put("sendsuccess", "\u53d1\u9001\u6210\u529f");
        massStatusMap.put("send_success", "\u53d1\u9001\u6210\u529f");
        massStatusMap.put("success", "\u53d1\u9001\u6210\u529f");
        massStatusMap.put("send success", "\u53d1\u9001\u6210\u529f");
        massStatusMap.put("sendfail", "\u53d1\u9001\u5931\u8d25");
        massStatusMap.put("send_fail", "\u53d1\u9001\u5931\u8d25");
        massStatusMap.put("fail", "\u53d1\u9001\u5931\u8d25");
        massStatusMap.put("send fail", "\u53d1\u9001\u5931\u8d25");
        massStatusMap.put("err(10001)", "\u6d89\u5acc\u5e7f\u544a");
        massStatusMap.put("err(20001)", "\u6d89\u5acc\u653f\u6cbb");
        massStatusMap.put("err(20004)", "\u6d89\u5acc\u793e\u4f1a");
        massStatusMap.put("err(20006)", "\u6d89\u5acc\u8fdd\u6cd5\u72af\u7f6a");
        massStatusMap.put("err(20008)", "\u6d89\u5acc\u6b3a\u8bc8");
        massStatusMap.put("err(20013)", "\u6d89\u5acc\u7248\u6743");
        massStatusMap.put("err(22000)", "\u6d89\u5acc\u4e92\u63a8(\u4e92\u76f8\u5ba3\u4f20)");
        massStatusMap.put("err(21000)", "\u6d89\u5acc\u5176\u4ed6");
    }
}

