/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Button;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.mp.model.AutoReplySetting;
import com.foxinmy.weixin4j.mp.model.MenuSetting;
import com.foxinmy.weixin4j.mp.model.SemQuery;
import com.foxinmy.weixin4j.mp.model.SemResult;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.tuple.MpArticle;
import java.util.ArrayList;
import java.util.List;

public class HelperApi
extends MpApi {
    private final TokenManager tokenManager;

    public HelperApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public String getShorturl(String url) throws WeixinException {
        String shorturl_uri = this.getRequestUri("shorturl_uri");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("action", (Object)"long2short");
        obj.put("long_url", (Object)url);
        WeixinResponse response = this.weixinExecutor.post(String.format(shorturl_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsJson().getString("short_url");
    }

    public SemResult semantic(SemQuery semQuery) throws WeixinException {
        String semantic_uri = this.getRequestUri("semantic_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(semantic_uri, token.getAccessToken()), semQuery.toJson());
        return (SemResult)((Object)response.getAsObject((TypeReference)new TypeReference<SemResult>(){}));
    }

    public List<String> getWechatServerIp() throws WeixinException {
        String getcallbackip_uri = this.getRequestUri("getcallbackip_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(getcallbackip_uri, token.getAccessToken()), new URLParameter[0]);
        return JSON.parseArray((String)response.getAsJson().getString("ip_list"), String.class);
    }

    public MenuSetting getMenuSetting() throws WeixinException {
        String menu_get_selfmenu_uri = this.getRequestUri("menu_get_selfmenu_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(menu_get_selfmenu_uri, token.getAccessToken()), new URLParameter[0]);
        JSONObject result = response.getAsJson();
        JSONArray buttons = result.getJSONObject("selfmenu_info").getJSONArray("button");
        ArrayList<Button> buttonList = new ArrayList<Button>(buttons.size());
        JSONObject buttonObj = null;
        for (int i = 0; i < buttons.size(); ++i) {
            buttonObj = buttons.getJSONObject(i);
            if (buttonObj.containsKey((Object)"sub_button")) {
                buttonObj.put("sub_button", (Object)buttonObj.getJSONObject("sub_button").getJSONArray("list"));
                buttonObj.put("type", (Object)"popups");
            }
            buttonList.add((Button)JSON.parseObject((String)buttonObj.toJSONString(), Button.class, (ParseProcess)ButtonExtraProcessor.global, (Feature[])new Feature[0]));
        }
        return new MenuSetting(result.getBooleanValue("is_menu_open"), buttonList);
    }

    public AutoReplySetting getAutoReplySetting() throws WeixinException {
        String autoreply_setting_get_uri = this.getRequestUri("autoreply_setting_get_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(autoreply_setting_get_uri, token.getAccessToken()), new URLParameter[0]);
        JSONObject result = response.getAsJson();
        AutoReplySetting replySetting = (AutoReplySetting)JSON.toJavaObject((JSON)result, AutoReplySetting.class);
        ArrayList<AutoReplySetting.Rule> ruleList = null;
        if (result.containsKey((Object)"keyword_autoreply_info")) {
            JSONArray keywordList = result.getJSONObject("keyword_autoreply_info").getJSONArray("list");
            ruleList = new ArrayList<AutoReplySetting.Rule>(keywordList.size());
            JSONObject keywordObj = null;
            JSONArray replyList = null;
            JSONObject replyObj = null;
            for (int i = 0; i < keywordList.size(); ++i) {
                keywordObj = keywordList.getJSONObject(i);
                AutoReplySetting.Rule rule = (AutoReplySetting.Rule)JSON.toJavaObject((JSON)keywordObj, AutoReplySetting.Rule.class);
                replyList = keywordObj.getJSONArray("reply_list_info");
                ArrayList<AutoReplySetting.Entry> entryList = new ArrayList<AutoReplySetting.Entry>(replyList.size());
                for (int j = 0; j < replyList.size(); ++j) {
                    replyObj = replyList.getJSONObject(j);
                    if (replyObj.getString("type").equals("news")) {
                        entryList.add((AutoReplySetting.Entry)JSON.parseObject((String)replyObj.toJSONString(), AutoReplySetting.Entry.class, (ParseProcess)ButtonExtraProcessor.global, (Feature[])new Feature[0]));
                        continue;
                    }
                    entryList.add((AutoReplySetting.Entry)JSON.toJavaObject((JSON)replyObj, AutoReplySetting.Entry.class));
                }
                rule.setReplyList(entryList);
                ruleList.add(rule);
            }
        }
        replySetting.setKeywordReplyList(ruleList);
        return replySetting;
    }

    public ApiResult clearQuota(String appId) throws WeixinException {
        String clearquota_uri = this.getRequestUri("clearquota_uri");
        String body = String.format("{\"appid\":\"%s\"}", appId);
        WeixinResponse response = this.weixinExecutor.post(String.format(clearquota_uri, this.tokenManager.getAccessToken()), body);
        return response.getAsResult();
    }

    private static final class ButtonExtraProcessor
    implements ExtraProcessor {
        private static ButtonExtraProcessor global = new ButtonExtraProcessor();
        private static final String KEY = "news_info";

        private ButtonExtraProcessor() {
        }

        public void processExtra(Object object, String key, Object value) {
            if (KEY.equalsIgnoreCase(key)) {
                JSONArray news = ((JSONObject)value).getJSONArray("list");
                ArrayList<Object> newsList = new ArrayList<Object>(news.size());
                JSONObject article = null;
                for (int i = 0; i < news.size(); ++i) {
                    article = news.getJSONObject(i);
                    article.put("show_cover_pic", article.remove((Object)"show_cover"));
                    article.put("thumb_url", article.remove((Object)"cover_url"));
                    article.put("url", article.remove((Object)"content_url"));
                    article.put("content_source_url", article.remove((Object)"source_url"));
                    newsList.add(JSON.toJavaObject((JSON)article, MpArticle.class));
                }
                ((Button)object).setExtra(newsList);
            } else {
                ((Button)object).setContent(String.valueOf(value));
            }
        }
    }
}

