/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.MimeType;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.apache.ContentBody;
import com.foxinmy.weixin4j.http.apache.FormBodyPart;
import com.foxinmy.weixin4j.http.apache.InputStreamBody;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.mp.model.KfAccount;
import com.foxinmy.weixin4j.mp.model.KfChatRecord;
import com.foxinmy.weixin4j.mp.model.KfOnlineAccount;
import com.foxinmy.weixin4j.mp.model.KfSession;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.util.FileUtil;
import com.foxinmy.weixin4j.util.ObjectId;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CustomApi
extends MpApi {
    private final TokenManager tokenManager;

    public CustomApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public List<KfChatRecord> getKfChatRecord(Date startTime, Date endTime, int number) throws WeixinException {
        WeixinResponse response;
        String text;
        ArrayList<KfChatRecord> records = new ArrayList<KfChatRecord>();
        String kf_chatrecord_uri = this.getRequestUri("kf_chatrecord_uri");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("starttime", (Object)(startTime.getTime() / 1000L));
        obj.put("endtime", (Object)(endTime.getTime() / 1000L));
        obj.put("msgid", (Object)"1");
        obj.put("number", (Object)Math.min(10000, number));
        JSONObject result = null;
        while (!StringUtil.isBlank((CharSequence)(text = (result = (response = this.weixinExecutor.post(String.format(kf_chatrecord_uri, token.getAccessToken()), obj.toJSONString())).getAsJson()).getString("recordlist"))) && !"[]".equals(text)) {
            records.addAll(JSON.parseArray((String)text, KfChatRecord.class));
            obj.put("msgid", (Object)result.getString("msgid"));
            if (obj.getIntValue("number") == result.getIntValue("number")) continue;
        }
        return records;
    }

    public List<KfAccount> listKfAccount() throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String kf_list_uri = this.getRequestUri("kf_list_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(kf_list_uri, token.getAccessToken()), new URLParameter[0]);
        String text = response.getAsJson().getString("kf_list");
        return JSON.parseArray((String)text, KfAccount.class);
    }

    public List<KfOnlineAccount> listOnlineKfAccount() throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String kf_onlinelist_uri = this.getRequestUri("kf_onlinelist_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(kf_onlinelist_uri, token.getAccessToken()), new URLParameter[0]);
        String text = response.getAsJson().getString("kf_online_list");
        return JSON.parseArray((String)text, KfOnlineAccount.class);
    }

    public ApiResult createKfAccount(String id, String name) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("kf_account", (Object)id);
        obj.put("nickname", (Object)name);
        String kf_create_uri = this.getRequestUri("kf_create_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(kf_create_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult updateKfAccount(String id, String name) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("kf_account", (Object)id);
        obj.put("nickname", (Object)name);
        String kf_update_uri = this.getRequestUri("kf_update_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(kf_update_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult inviteKfAccount(String kfAccount, String inviteAccount) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("kf_account", (Object)kfAccount);
        obj.put("invite_wx", (Object)inviteAccount);
        String kf_invite_uri = this.getRequestUri("kf_invite_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(kf_invite_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult uploadKfAvatar(String accountId, InputStream is, String fileName) throws WeixinException {
        if (StringUtil.isBlank((CharSequence)fileName)) {
            fileName = ObjectId.get().toHexString();
        }
        if (StringUtil.isBlank((CharSequence)FileUtil.getFileExtension((String)fileName))) {
            fileName = String.format("%s.jpg", fileName);
        }
        MimeType mimeType = new MimeType("image", FileUtil.getFileExtension((String)fileName));
        Token token = (Token)this.tokenManager.getCache();
        String kf_avatar_uri = this.getRequestUri("kf_avatar_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(kf_avatar_uri, token.getAccessToken(), accountId), new FormBodyPart[]{new FormBodyPart("media", (ContentBody)new InputStreamBody(is, mimeType.toString(), fileName))});
        return response.getAsResult();
    }

    public ApiResult deleteKfAccount(String id) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String kf_delete_uri = this.getRequestUri("kf_delete_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(kf_delete_uri, token.getAccessToken(), id), new URLParameter[0]);
        return response.getAsResult();
    }

    public ApiResult createKfSession(String userOpenId, String kfAccount, String text) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String kfsession_create_uri = this.getRequestUri("kfsession_create_uri");
        JSONObject obj = new JSONObject();
        obj.put("openid", (Object)userOpenId);
        obj.put("kf_account", (Object)kfAccount);
        obj.put("text", (Object)text);
        WeixinResponse response = this.weixinExecutor.post(String.format(kfsession_create_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult closeKfSession(String userOpenId, String kfAccount, String text) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String kfsession_close_uri = this.getRequestUri("kfsession_close_uri");
        JSONObject obj = new JSONObject();
        obj.put("openid", (Object)userOpenId);
        obj.put("kf_account", (Object)kfAccount);
        obj.put("text", (Object)text);
        WeixinResponse response = this.weixinExecutor.post(String.format(kfsession_close_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public KfSession getKfSession(String userOpenId) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String kfsession_get_uri = this.getRequestUri("kfsession_get_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(kfsession_get_uri, token.getAccessToken(), userOpenId), new URLParameter[0]);
        KfSession session = (KfSession)response.getAsObject((TypeReference)new TypeReference<KfSession>(){});
        session.setUserOpenId(userOpenId);
        return session;
    }

    public List<KfSession> listKfSession(String kfAccount) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String kfsession_list_uri = this.getRequestUri("kfsession_list_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(kfsession_list_uri, token.getAccessToken(), kfAccount), new URLParameter[0]);
        List sessionList = JSON.parseArray((String)response.getAsJson().getString("sessionlist"), KfSession.class);
        return sessionList;
    }

    public KfSession.KfSessionCounter listKfWaitSession() throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String kfsession_wait_uri = this.getRequestUri("kfsession_wait_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(kfsession_wait_uri, token.getAccessToken()), new URLParameter[0]);
        return (KfSession.KfSessionCounter)response.getAsObject((TypeReference)new TypeReference<KfSession.KfSessionCounter>(){});
    }
}

