/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.model.paging.Pageable;
import com.foxinmy.weixin4j.model.paging.Pagedata;
import com.foxinmy.weixin4j.mp.api.MpApi;
import com.foxinmy.weixin4j.mp.model.ArticleComment;
import com.foxinmy.weixin4j.token.TokenManager;
import java.util.ArrayList;
import java.util.List;

public class CommentApi
extends MpApi {
    private final TokenManager tokenManager;

    public CommentApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public ApiResult openComment(boolean open, String msgid, int index) throws WeixinException {
        String news_comment = open ? this.getRequestUri("news_comment_open") : this.getRequestUri("news_comment_close");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("msg_data_id", (Object)msgid);
        obj.put("index", (Object)index);
        WeixinResponse response = this.weixinExecutor.post(String.format(news_comment, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public Pagedata<ArticleComment> listArticleComments(Pageable page, ArticleComment.ArticleCommentType commentType, String msgid, int index) throws WeixinException {
        String news_comment_list = this.getRequestUri("news_comment_list");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("msg_data_id", (Object)"msgid");
        obj.put("index", (Object)index);
        obj.put("begin", (Object)page.getOffset());
        obj.put("count", (Object)Math.max(50, page.getPageSize()));
        if (commentType != null) {
            obj.put("type", (Object)(commentType.ordinal() + 1));
        } else {
            obj.put("type", (Object)0);
        }
        WeixinResponse response = this.weixinExecutor.post(String.format(news_comment_list, token.getAccessToken()), obj.toJSONString());
        JSONObject result = response.getAsJson();
        int total = result.getIntValue("total");
        List content = JSON.parseArray((String)result.getString("comment"), ArticleComment.class);
        return new Pagedata(page, total, content);
    }

    public List<ArticleComment> listAllArticleComments(ArticleComment.ArticleCommentType commentType, String msgid, int index) throws WeixinException {
        ArrayList<ArticleComment> comments = new ArrayList<ArticleComment>();
        Pagedata<ArticleComment> page = null;
        Pageable pageable = null;
        pageable = new Pageable(1, 50);
        while ((page = this.listArticleComments(pageable, commentType, msgid, index)).hasContent()) {
            comments.addAll(page.getContent());
            pageable = pageable.next();
        }
        return comments;
    }

    public ApiResult markelectComment(boolean markelect, String msgid, int index, String commentId) throws WeixinException {
        String news_comment = markelect ? this.getRequestUri("news_comment_markelect") : this.getRequestUri("news_comment_unmarkelect");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("msg_data_id", (Object)"msgid");
        obj.put("index", (Object)index);
        obj.put("user_comment_id", (Object)commentId);
        WeixinResponse response = this.weixinExecutor.post(String.format(news_comment, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult deleteComment(String msgid, int index, String commentId) throws WeixinException {
        String news_comment_delete = this.getRequestUri("news_comment_delete");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("msg_data_id", (Object)"msgid");
        obj.put("index", (Object)index);
        obj.put("user_comment_id", (Object)commentId);
        WeixinResponse response = this.weixinExecutor.post(String.format(news_comment_delete, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult replyComment(String msgid, int index, String commentId, String content) throws WeixinException {
        String news_comment_reply = this.getRequestUri("news_comment_reply_add");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("msg_data_id", (Object)"msgid");
        obj.put("index", (Object)index);
        obj.put("user_comment_id", (Object)commentId);
        obj.put("content", (Object)content);
        WeixinResponse response = this.weixinExecutor.post(String.format(news_comment_reply, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult deleteCommentReply(String msgid, int index, String commentId) throws WeixinException {
        String news_comment_reply = this.getRequestUri("news_comment_reply_delete");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("msg_data_id", (Object)"msgid");
        obj.put("index", (Object)index);
        obj.put("user_comment_id", (Object)commentId);
        WeixinResponse response = this.weixinExecutor.post(String.format(news_comment_reply, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }
}

