/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.mp;

import com.foxinmy.weixin4j.cache.CacheStorager;
import com.foxinmy.weixin4j.cache.FileCacheStorager;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.model.Button;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.model.WeixinAccount;
import com.foxinmy.weixin4j.model.card.CardCoupon;
import com.foxinmy.weixin4j.model.card.CardQR;
import com.foxinmy.weixin4j.model.media.MediaCounter;
import com.foxinmy.weixin4j.model.media.MediaDownloadResult;
import com.foxinmy.weixin4j.model.media.MediaItem;
import com.foxinmy.weixin4j.model.media.MediaRecord;
import com.foxinmy.weixin4j.model.media.MediaUploadResult;
import com.foxinmy.weixin4j.model.paging.Pageable;
import com.foxinmy.weixin4j.model.paging.Pagedata;
import com.foxinmy.weixin4j.model.qr.QRParameter;
import com.foxinmy.weixin4j.model.qr.QRResult;
import com.foxinmy.weixin4j.mp.api.CardApi;
import com.foxinmy.weixin4j.mp.api.CommentApi;
import com.foxinmy.weixin4j.mp.api.CustomApi;
import com.foxinmy.weixin4j.mp.api.DataApi;
import com.foxinmy.weixin4j.mp.api.GroupApi;
import com.foxinmy.weixin4j.mp.api.HelperApi;
import com.foxinmy.weixin4j.mp.api.MassApi;
import com.foxinmy.weixin4j.mp.api.MediaApi;
import com.foxinmy.weixin4j.mp.api.MenuApi;
import com.foxinmy.weixin4j.mp.api.NotifyApi;
import com.foxinmy.weixin4j.mp.api.OauthApi;
import com.foxinmy.weixin4j.mp.api.QrApi;
import com.foxinmy.weixin4j.mp.api.TagApi;
import com.foxinmy.weixin4j.mp.api.TmplApi;
import com.foxinmy.weixin4j.mp.api.UserApi;
import com.foxinmy.weixin4j.mp.component.WeixinTokenComponentCreator;
import com.foxinmy.weixin4j.mp.message.NotifyMessage;
import com.foxinmy.weixin4j.mp.message.TemplateMessage;
import com.foxinmy.weixin4j.mp.model.ArticleComment;
import com.foxinmy.weixin4j.mp.model.AutoReplySetting;
import com.foxinmy.weixin4j.mp.model.Following;
import com.foxinmy.weixin4j.mp.model.Group;
import com.foxinmy.weixin4j.mp.model.KfAccount;
import com.foxinmy.weixin4j.mp.model.KfChatRecord;
import com.foxinmy.weixin4j.mp.model.KfOnlineAccount;
import com.foxinmy.weixin4j.mp.model.KfSession;
import com.foxinmy.weixin4j.mp.model.Menu;
import com.foxinmy.weixin4j.mp.model.MenuMatchRule;
import com.foxinmy.weixin4j.mp.model.MenuSetting;
import com.foxinmy.weixin4j.mp.model.SemQuery;
import com.foxinmy.weixin4j.mp.model.SemResult;
import com.foxinmy.weixin4j.mp.model.Tag;
import com.foxinmy.weixin4j.mp.model.TemplateMessageInfo;
import com.foxinmy.weixin4j.mp.model.User;
import com.foxinmy.weixin4j.mp.token.WeixinTicketCreator;
import com.foxinmy.weixin4j.mp.token.WeixinTokenCreator;
import com.foxinmy.weixin4j.mp.type.DatacubeType;
import com.foxinmy.weixin4j.mp.type.IndustryType;
import com.foxinmy.weixin4j.mp.type.Lang;
import com.foxinmy.weixin4j.token.PerTicketManager;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.tuple.MassTuple;
import com.foxinmy.weixin4j.tuple.MpArticle;
import com.foxinmy.weixin4j.tuple.MpVideo;
import com.foxinmy.weixin4j.type.MediaType;
import com.foxinmy.weixin4j.type.TicketType;
import com.foxinmy.weixin4j.util.Weixin4jConfigUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

public class WeixinProxy {
    private final OauthApi oauthApi;
    private final MediaApi mediaApi;
    private final NotifyApi notifyApi;
    private final CustomApi customApi;
    private final MassApi massApi;
    private final UserApi userApi;
    private final GroupApi groupApi;
    private final MenuApi menuApi;
    private final QrApi qrApi;
    private final TmplApi tmplApi;
    private final HelperApi helperApi;
    private final DataApi dataApi;
    private final TagApi tagApi;
    private final CardApi cardApi;
    private final CommentApi commentApi;
    private final TokenManager tokenManager;
    private final WeixinAccount weixinAccount;
    private final CacheStorager<Token> cacheStorager;
    public static final String VERSION = "1.7.7";

    public WeixinProxy() {
        this((CacheStorager<Token>)new FileCacheStorager());
    }

    public WeixinProxy(CacheStorager<Token> cacheStorager) {
        this(Weixin4jConfigUtil.getWeixinAccount(), cacheStorager);
    }

    public WeixinProxy(WeixinAccount weixinAccount, CacheStorager<Token> cacheStorager) {
        this(weixinAccount, new WeixinTokenCreator(weixinAccount.getId(), weixinAccount.getSecret()), cacheStorager);
    }

    public WeixinProxy(PerTicketManager perTicketManager, TokenManager componentTokenManager) {
        this(new WeixinAccount(perTicketManager.getThirdId(), perTicketManager.getThirdSecret()), new WeixinTokenComponentCreator(perTicketManager, componentTokenManager), (CacheStorager<Token>)perTicketManager.getCacheStorager());
    }

    private WeixinProxy(WeixinAccount weixinAccount, TokenCreator tokenCreator, CacheStorager<Token> cacheStorager) {
        if (weixinAccount == null) {
            throw new IllegalArgumentException("weixinAccount must not be empty");
        }
        if (tokenCreator == null) {
            throw new IllegalArgumentException("tokenCreator must not be empty");
        }
        if (cacheStorager == null) {
            throw new IllegalArgumentException("cacheStorager must not be empty");
        }
        this.tokenManager = new TokenManager(tokenCreator, cacheStorager);
        this.weixinAccount = weixinAccount;
        this.cacheStorager = cacheStorager;
        this.oauthApi = new OauthApi(weixinAccount);
        this.mediaApi = new MediaApi(this.tokenManager);
        this.notifyApi = new NotifyApi(this.tokenManager);
        this.customApi = new CustomApi(this.tokenManager);
        this.massApi = new MassApi(this.tokenManager);
        this.userApi = new UserApi(this.tokenManager);
        this.groupApi = new GroupApi(this.tokenManager);
        this.menuApi = new MenuApi(this.tokenManager);
        this.qrApi = new QrApi(this.tokenManager);
        this.tmplApi = new TmplApi(this.tokenManager);
        this.helperApi = new HelperApi(this.tokenManager);
        this.dataApi = new DataApi(this.tokenManager);
        this.tagApi = new TagApi(this.tokenManager);
        this.cardApi = new CardApi(this.tokenManager);
        this.commentApi = new CommentApi(this.tokenManager);
    }

    public WeixinAccount getWeixinAccount() {
        return this.weixinAccount;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public OauthApi getOauthApi() {
        return this.oauthApi;
    }

    public TokenManager getTicketManager(TicketType ticketType) {
        return new TokenManager((TokenCreator)new WeixinTicketCreator(this.weixinAccount.getId(), ticketType, this.tokenManager), this.cacheStorager);
    }

    public String uploadImage(InputStream is, String fileName) throws WeixinException {
        return this.mediaApi.uploadImage(is, fileName);
    }

    public MpVideo uploadVideo(InputStream is, String fileName, String title, String description) throws WeixinException {
        return this.mediaApi.uploadVideo(is, fileName, title, description);
    }

    public MediaUploadResult uploadMedia(boolean isMaterial, InputStream is, String fileName) throws WeixinException {
        return this.mediaApi.uploadMedia(isMaterial, is, fileName);
    }

    public MediaDownloadResult downloadMedia(String mediaId, boolean isMaterial) throws WeixinException {
        return this.mediaApi.downloadMedia(mediaId, isMaterial);
    }

    public String uploadMaterialArticle(List<MpArticle> articles) throws WeixinException {
        return this.mediaApi.uploadMaterialArticle(articles);
    }

    public List<MpArticle> downloadArticle(String mediaId) throws WeixinException {
        return this.mediaApi.downloadArticle(mediaId);
    }

    public ApiResult updateMaterialArticle(String mediaId, int index, MpArticle article) throws WeixinException {
        return this.mediaApi.updateMaterialArticle(mediaId, index, article);
    }

    public ApiResult deleteMaterialMedia(String mediaId) throws WeixinException {
        return this.mediaApi.deleteMaterialMedia(mediaId);
    }

    public String uploadMaterialVideo(InputStream is, String fileName, String title, String introduction) throws WeixinException {
        return this.mediaApi.uploadMaterialVideo(is, fileName, title, introduction);
    }

    public MediaCounter countMaterialMedia() throws WeixinException {
        return this.mediaApi.countMaterialMedia();
    }

    public MediaRecord listMaterialMedia(MediaType mediaType, Pageable pageable) throws WeixinException {
        return this.mediaApi.listMaterialMedia(mediaType, pageable);
    }

    public List<MediaItem> listAllMaterialMedia(MediaType mediaType) throws WeixinException {
        return this.mediaApi.listAllMaterialMedia(mediaType);
    }

    public ApiResult sendNotify(NotifyMessage notify) throws WeixinException {
        return this.notifyApi.sendNotify(notify);
    }

    public ApiResult sendNotify(NotifyMessage notify, String kfAccount) throws WeixinException {
        return this.notifyApi.sendNotify(notify, kfAccount);
    }

    public List<KfChatRecord> getKfChatRecord(Date startTime, Date endTime, int number) throws WeixinException {
        return this.customApi.getKfChatRecord(startTime, endTime, number);
    }

    public List<KfAccount> listKfAccount() throws WeixinException {
        return this.customApi.listKfAccount();
    }

    public List<KfOnlineAccount> listOnlineKfAccount() throws WeixinException {
        return this.customApi.listOnlineKfAccount();
    }

    public ApiResult createKfAccount(String id, String name) throws WeixinException {
        return this.customApi.createKfAccount(id, name);
    }

    public ApiResult updateKfAccount(String id, String name) throws WeixinException {
        return this.customApi.updateKfAccount(id, name);
    }

    public ApiResult inviteKfAccount(String kfAccount, String inviteAccount) throws WeixinException {
        return this.customApi.inviteKfAccount(kfAccount, inviteAccount);
    }

    public ApiResult uploadKfAvatar(String accountId, InputStream is, String fileName) throws WeixinException {
        return this.customApi.uploadKfAvatar(accountId, is, fileName);
    }

    public ApiResult deleteKfAccount(String id) throws WeixinException {
        return this.customApi.deleteKfAccount(id);
    }

    public ApiResult createKfSession(String userOpenId, String kfAccount, String text) throws WeixinException {
        return this.customApi.createKfSession(userOpenId, kfAccount, text);
    }

    public ApiResult closeKfSession(String userOpenId, String kfAccount, String text) throws WeixinException {
        return this.customApi.closeKfSession(userOpenId, kfAccount, text);
    }

    public KfSession getKfSession(String userOpenId) throws WeixinException {
        return this.customApi.getKfSession(userOpenId);
    }

    public List<KfSession> listKfSession(String kfAccount) throws WeixinException {
        return this.customApi.listKfSession(kfAccount);
    }

    public KfSession.KfSessionCounter listKfWaitSession() throws WeixinException {
        return this.customApi.listKfWaitSession();
    }

    public String uploadMassArticle(List<MpArticle> articles) throws WeixinException {
        return this.massApi.uploadArticle(articles);
    }

    public String[] massByGroupId(MassTuple tuple, boolean isToAll, int groupId) throws WeixinException {
        return this.massApi.massByGroupId(tuple, isToAll, groupId);
    }

    public String[] massArticleByGroupId(List<MpArticle> articles, int groupId) throws WeixinException {
        return this.massApi.massArticleByGroupId(articles, groupId);
    }

    public String[] massToAll(MassTuple tuple) throws WeixinException {
        return this.massApi.massToAll(tuple);
    }

    public String[] massByTagId(MassTuple tuple, int tagId) throws WeixinException {
        return this.massApi.massByTagId(tuple, tagId);
    }

    public String[] massArticleByTagId(List<MpArticle> articles, int tagId, boolean ignoreReprint) throws WeixinException {
        return this.massApi.massArticleByTagId(articles, tagId, ignoreReprint);
    }

    public String[] massByOpenIds(MassTuple tuple, String ... openIds) throws WeixinException {
        return this.massApi.massByOpenIds(tuple, openIds);
    }

    public String[] massArticleByOpenIds(List<MpArticle> articles, boolean ignoreReprint, String ... openIds) throws WeixinException {
        return this.massApi.massArticleByOpenIds(articles, ignoreReprint, openIds);
    }

    public ApiResult deleteMassNews(String msgid) throws WeixinException {
        return this.massApi.deleteMassNews(msgid);
    }

    public ApiResult deleteMassNews(String msgid, int articleIndex) throws WeixinException {
        return this.massApi.deleteMassNews(msgid, articleIndex);
    }

    public ApiResult previewMassNews(String toUser, String toWxName, MassTuple tuple) throws WeixinException {
        return this.massApi.previewMassNews(toUser, toWxName, tuple);
    }

    public String getMassNewStatus(String msgId) throws WeixinException {
        return this.massApi.getMassNewStatus(msgId);
    }

    public User getUser(String openId) throws WeixinException {
        return this.userApi.getUser(openId);
    }

    public User getUser(String openId, Lang lang) throws WeixinException {
        return this.userApi.getUser(openId, lang);
    }

    public List<User> getUsers(String ... openIds) throws WeixinException {
        return this.userApi.getUsers(openIds);
    }

    public List<User> getUsers(Lang lang, String ... openIds) throws WeixinException {
        return this.userApi.getUsers(lang, openIds);
    }

    public Following getFollowing(String nextOpenId) throws WeixinException {
        return this.userApi.getFollowing(nextOpenId);
    }

    public Following getFollowingOpenIds(String nextOpenId) throws WeixinException {
        return this.userApi.getFollowingOpenIds(nextOpenId);
    }

    public List<User> getAllFollowing() throws WeixinException {
        return this.userApi.getAllFollowing();
    }

    public List<String> getAllFollowingOpenIds() throws WeixinException {
        return this.userApi.getAllFollowingOpenIds();
    }

    public ApiResult remarkUserName(String openId, String remark) throws WeixinException {
        return this.userApi.remarkUserName(openId, remark);
    }

    public Group createGroup(String name) throws WeixinException {
        return this.groupApi.createGroup(name);
    }

    public List<Group> getGroups() throws WeixinException {
        return this.groupApi.getGroups();
    }

    public int getGroupByOpenId(String openId) throws WeixinException {
        return this.groupApi.getGroupByOpenId(openId);
    }

    public ApiResult modifyGroup(int groupId, String name) throws WeixinException {
        return this.groupApi.modifyGroup(groupId, name);
    }

    public ApiResult moveGroup(int groupId, String openId) throws WeixinException {
        return this.groupApi.moveGroup(groupId, openId);
    }

    public ApiResult moveGroup(int groupId, String ... openIds) throws WeixinException {
        return this.groupApi.moveGroup(groupId, openIds);
    }

    public ApiResult deleteGroup(int groupId) throws WeixinException {
        return this.groupApi.deleteGroup(groupId);
    }

    public ApiResult createMenu(List<Button> buttons) throws WeixinException {
        return this.menuApi.createMenu(buttons);
    }

    public List<Button> getMenu() throws WeixinException {
        return this.menuApi.getMenu();
    }

    public List<Menu> getAllMenu() throws WeixinException {
        return this.menuApi.getAllMenu();
    }

    public ApiResult deleteMenu() throws WeixinException {
        return this.menuApi.deleteMenu();
    }

    public String createCustomMenu(List<Button> buttons, MenuMatchRule matchRule) throws WeixinException {
        return this.menuApi.createCustomMenu(buttons, matchRule);
    }

    public ApiResult deleteCustomMenu(String menuId) throws WeixinException {
        return this.menuApi.deleteCustomMenu(menuId);
    }

    public List<Button> matchCustomMenu(String userId) throws WeixinException {
        return this.menuApi.matchCustomMenu(userId);
    }

    public QRResult createQR(QRParameter parameter) throws WeixinException {
        return this.qrApi.createQR(parameter);
    }

    public ApiResult setTmplIndustry(IndustryType ... industryTypes) throws WeixinException {
        return this.tmplApi.setTmplIndustry(industryTypes);
    }

    public String getTemplateId(String shortId) throws WeixinException {
        return this.tmplApi.getTemplateId(shortId);
    }

    public List<TemplateMessageInfo> getAllTemplates() throws WeixinException {
        return this.tmplApi.getAllTemplates();
    }

    public ApiResult deleteTemplate(String templateId) throws WeixinException {
        return this.tmplApi.deleteTemplate(templateId);
    }

    public String sendTmplMessage(TemplateMessage tplMessage) throws WeixinException {
        return this.tmplApi.sendTmplMessage(tplMessage);
    }

    public String getShorturl(String url) throws WeixinException {
        return this.helperApi.getShorturl(url);
    }

    public SemResult semantic(SemQuery semQuery) throws WeixinException {
        return this.helperApi.semantic(semQuery);
    }

    public List<String> getWechatServerIp() throws WeixinException {
        return this.helperApi.getWechatServerIp();
    }

    public ApiResult clearQuota() throws WeixinException {
        return this.helperApi.clearQuota(this.weixinAccount.getId());
    }

    public MenuSetting getMenuSetting() throws WeixinException {
        return this.helperApi.getMenuSetting();
    }

    public AutoReplySetting getAutoReplySetting() throws WeixinException {
        return this.helperApi.getAutoReplySetting();
    }

    public List<?> datacube(DatacubeType datacubeType, Date beginDate, Date endDate) throws WeixinException {
        return this.dataApi.datacube(datacubeType, beginDate, endDate);
    }

    public List<?> datacube(DatacubeType datacubeType, Date beginDate, int offset) throws WeixinException {
        return this.dataApi.datacube(datacubeType, beginDate, offset);
    }

    public List<?> datacube(DatacubeType datacubeType, int offset, Date endDate) throws WeixinException {
        return this.dataApi.datacube(datacubeType, offset, endDate);
    }

    public List<?> datacube(DatacubeType datacubeType, Date date) throws WeixinException {
        return this.dataApi.datacube(datacubeType, date);
    }

    public Tag createTag(String name) throws WeixinException {
        return this.tagApi.createTag(name);
    }

    public List<Tag> listTags() throws WeixinException {
        return this.tagApi.listTags();
    }

    public ApiResult updateTag(Tag tag) throws WeixinException {
        return this.tagApi.updateTag(tag);
    }

    public ApiResult deleteTag(int tagId) throws WeixinException {
        return this.tagApi.deleteTag(tagId);
    }

    public ApiResult taggingUsers(int tagId, String ... openIds) throws WeixinException {
        return this.tagApi.taggingUsers(tagId, openIds);
    }

    public ApiResult untaggingUsers(int tagId, String ... openIds) throws WeixinException {
        return this.tagApi.untaggingUsers(tagId, openIds);
    }

    public Following getTagFollowingOpenIds(int tagId, String nextOpenId) throws WeixinException {
        return this.tagApi.getTagFollowingOpenIds(tagId, nextOpenId);
    }

    public Following getTagFollowing(int tagId, String nextOpenId) throws WeixinException {
        return this.tagApi.getTagFollowing(tagId, nextOpenId);
    }

    public List<String> getAllTagFollowingOpenIds(int tagId) throws WeixinException {
        return this.tagApi.getAllTagFollowingOpenIds(tagId);
    }

    public List<User> getAllTagFollowing(int tagId) throws WeixinException {
        return this.tagApi.getAllTagFollowing(tagId);
    }

    public Integer[] getUserTags(String openId) throws WeixinException {
        return this.tagApi.getUserTags(openId);
    }

    public Following getBalcklistOpenIds(String nextOpenId) throws WeixinException {
        return this.tagApi.getBalcklistOpenIds(nextOpenId);
    }

    public List<String> getAllBalcklistOpenIds() throws WeixinException {
        return this.tagApi.getAllBalcklistOpenIds();
    }

    public ApiResult batchBlacklist(boolean blacklist, String ... openIds) throws WeixinException {
        return this.tagApi.batchBlacklist(blacklist, openIds);
    }

    public String createCardCoupon(CardCoupon cardCoupon) throws WeixinException {
        return this.cardApi.createCardCoupon(cardCoupon);
    }

    public ApiResult setCardPayCell(String cardId, boolean isOpen) throws WeixinException {
        return this.cardApi.setCardPayCell(cardId, isOpen);
    }

    public ApiResult setCardSelfConsumeCell(String cardId, boolean isOpen) throws WeixinException {
        return this.cardApi.setCardSelfConsumeCell(cardId, isOpen);
    }

    public QRResult createCardQR(Integer expireSeconds, CardQR ... cardQRs) throws WeixinException {
        return this.cardApi.createCardQR(expireSeconds, cardQRs);
    }

    public ApiResult openComment(boolean open, String msgid, int index) throws WeixinException {
        return this.commentApi.openComment(open, msgid, index);
    }

    public Pagedata<ArticleComment> listArticleComments(Pageable page, ArticleComment.ArticleCommentType commentType, String msgid, int index) throws WeixinException {
        return this.commentApi.listArticleComments(page, commentType, msgid, index);
    }

    public List<ArticleComment> listAllArticleComments(ArticleComment.ArticleCommentType commentType, String msgid, int index) throws WeixinException {
        return this.commentApi.listAllArticleComments(commentType, msgid, index);
    }

    public ApiResult markelectComment(boolean markelect, String msgid, int index, String commentId) throws WeixinException {
        return this.commentApi.markelectComment(markelect, msgid, index, commentId);
    }

    public ApiResult deleteComment(String msgid, int index, String commentId) throws WeixinException {
        return this.commentApi.deleteComment(msgid, index, commentId);
    }

    public ApiResult replyComment(String msgid, int index, String commentId, String content) throws WeixinException {
        return this.commentApi.replyComment(msgid, index, commentId, content);
    }

    public ApiResult deleteCommentReply(String msgid, int index, String commentId) throws WeixinException {
        return this.commentApi.deleteCommentReply(msgid, index, commentId);
    }
}

