package com.sforce.soap.partner;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.bind.XMLizable;
import com.sforce.ws.bind.TypeMapper;

import java.util.HashMap;

import javax.xml.namespace.QName;

/**
 * This is a generated class for the SObject Enterprise API.
 * Do not edit this file, as your changes will be lost.
 */
public class PartnerConnection {

  private TypeMapper __typeMapper = new TypeMapper();
  private ConnectorConfig __config;
  private HashMap<QName, XMLizable> __extraHeaders = new HashMap<QName, XMLizable>();

  public ConnectorConfig getConfig() {
    return __config;
  }

  private com.sforce.soap.partner.QueryOptions_element __QueryOptions;

  public void setQueryOptions(int batchSize) {
    __QueryOptions = new com.sforce.soap.partner.QueryOptions_element();
    __QueryOptions.setBatchSize(batchSize);
  }

  public void clearQueryOptions() {
    __QueryOptions = null;
  }

  public com.sforce.soap.partner.QueryOptions_element getQueryOptions() {
    return  __QueryOptions;
  }

  public void __setQueryOptions(com.sforce.soap.partner.QueryOptions_element __header) {
    __QueryOptions = __header ;
  }

  private com.sforce.soap.partner.AssignmentRuleHeader_element __AssignmentRuleHeader;

  public void setAssignmentRuleHeader(java.lang.String assignmentRuleId,java.lang.Boolean useDefaultRule) {
    __AssignmentRuleHeader = new com.sforce.soap.partner.AssignmentRuleHeader_element();
    __AssignmentRuleHeader.setAssignmentRuleId(assignmentRuleId);
    __AssignmentRuleHeader.setUseDefaultRule(useDefaultRule);
  }

  public void clearAssignmentRuleHeader() {
    __AssignmentRuleHeader = null;
  }

  public com.sforce.soap.partner.AssignmentRuleHeader_element getAssignmentRuleHeader() {
    return  __AssignmentRuleHeader;
  }

  public void __setAssignmentRuleHeader(com.sforce.soap.partner.AssignmentRuleHeader_element __header) {
    __AssignmentRuleHeader = __header ;
  }

  private com.sforce.soap.partner.DisableFeedTrackingHeader_element __DisableFeedTrackingHeader;

  public void setDisableFeedTrackingHeader(boolean disableFeedTracking) {
    __DisableFeedTrackingHeader = new com.sforce.soap.partner.DisableFeedTrackingHeader_element();
    __DisableFeedTrackingHeader.setDisableFeedTracking(disableFeedTracking);
  }

  public void clearDisableFeedTrackingHeader() {
    __DisableFeedTrackingHeader = null;
  }

  public com.sforce.soap.partner.DisableFeedTrackingHeader_element getDisableFeedTrackingHeader() {
    return  __DisableFeedTrackingHeader;
  }

  public void __setDisableFeedTrackingHeader(com.sforce.soap.partner.DisableFeedTrackingHeader_element __header) {
    __DisableFeedTrackingHeader = __header ;
  }

  private com.sforce.soap.partner.ConditionalRequestHeader_element __ConditionalRequestHeader;

  public void setConditionalRequestHeader(java.util.Calendar ifModifiedBefore,java.util.Calendar ifModifiedSince) {
    __ConditionalRequestHeader = new com.sforce.soap.partner.ConditionalRequestHeader_element();
    __ConditionalRequestHeader.setIfModifiedBefore(ifModifiedBefore);
    __ConditionalRequestHeader.setIfModifiedSince(ifModifiedSince);
  }

  public void clearConditionalRequestHeader() {
    __ConditionalRequestHeader = null;
  }

  public com.sforce.soap.partner.ConditionalRequestHeader_element getConditionalRequestHeader() {
    return  __ConditionalRequestHeader;
  }

  public void __setConditionalRequestHeader(com.sforce.soap.partner.ConditionalRequestHeader_element __header) {
    __ConditionalRequestHeader = __header ;
  }

  private com.sforce.soap.partner.EmailHeader_element __EmailHeader;

  public void setEmailHeader(boolean triggerAutoResponseEmail,boolean triggerOtherEmail,boolean triggerUserEmail) {
    __EmailHeader = new com.sforce.soap.partner.EmailHeader_element();
    __EmailHeader.setTriggerAutoResponseEmail(triggerAutoResponseEmail);
    __EmailHeader.setTriggerOtherEmail(triggerOtherEmail);
    __EmailHeader.setTriggerUserEmail(triggerUserEmail);
  }

  public void clearEmailHeader() {
    __EmailHeader = null;
  }

  public com.sforce.soap.partner.EmailHeader_element getEmailHeader() {
    return  __EmailHeader;
  }

  public void __setEmailHeader(com.sforce.soap.partner.EmailHeader_element __header) {
    __EmailHeader = __header ;
  }

  private com.sforce.soap.partner.LocaleOptions_element __LocaleOptions;

  public void setLocaleOptions(java.lang.String language,boolean localizeErrors) {
    __LocaleOptions = new com.sforce.soap.partner.LocaleOptions_element();
    __LocaleOptions.setLanguage(language);
    __LocaleOptions.setLocalizeErrors(localizeErrors);
  }

  public void clearLocaleOptions() {
    __LocaleOptions = null;
  }

  public com.sforce.soap.partner.LocaleOptions_element getLocaleOptions() {
    return  __LocaleOptions;
  }

  public void __setLocaleOptions(com.sforce.soap.partner.LocaleOptions_element __header) {
    __LocaleOptions = __header ;
  }

  private com.sforce.soap.partner.DebuggingHeader_element __DebuggingHeader;

  public void setDebuggingHeader(com.sforce.soap.partner.LogInfo[] categories,com.sforce.soap.partner.DebugLevel debugLevel) {
    __DebuggingHeader = new com.sforce.soap.partner.DebuggingHeader_element();
    __DebuggingHeader.setCategories(categories);
    __DebuggingHeader.setDebugLevel(debugLevel);
  }

  public void clearDebuggingHeader() {
    __DebuggingHeader = null;
  }

  public com.sforce.soap.partner.DebuggingHeader_element getDebuggingHeader() {
    return  __DebuggingHeader;
  }

  public void __setDebuggingHeader(com.sforce.soap.partner.DebuggingHeader_element __header) {
    __DebuggingHeader = __header ;
  }

  private com.sforce.soap.partner.OwnerChangeOptions_element __OwnerChangeOptions;

  public void setOwnerChangeOptions(com.sforce.soap.partner.OwnerChangeOption[] options) {
    __OwnerChangeOptions = new com.sforce.soap.partner.OwnerChangeOptions_element();
    __OwnerChangeOptions.setOptions(options);
  }

  public void clearOwnerChangeOptions() {
    __OwnerChangeOptions = null;
  }

  public com.sforce.soap.partner.OwnerChangeOptions_element getOwnerChangeOptions() {
    return  __OwnerChangeOptions;
  }

  public void __setOwnerChangeOptions(com.sforce.soap.partner.OwnerChangeOptions_element __header) {
    __OwnerChangeOptions = __header ;
  }

  private com.sforce.soap.partner.AllowFieldTruncationHeader_element __AllowFieldTruncationHeader;

  public void setAllowFieldTruncationHeader(boolean allowFieldTruncation) {
    __AllowFieldTruncationHeader = new com.sforce.soap.partner.AllowFieldTruncationHeader_element();
    __AllowFieldTruncationHeader.setAllowFieldTruncation(allowFieldTruncation);
  }

  public void clearAllowFieldTruncationHeader() {
    __AllowFieldTruncationHeader = null;
  }

  public com.sforce.soap.partner.AllowFieldTruncationHeader_element getAllowFieldTruncationHeader() {
    return  __AllowFieldTruncationHeader;
  }

  public void __setAllowFieldTruncationHeader(com.sforce.soap.partner.AllowFieldTruncationHeader_element __header) {
    __AllowFieldTruncationHeader = __header ;
  }

  private com.sforce.soap.partner.LimitInfoHeader_element __LimitInfoHeader;

  public void setLimitInfoHeader(com.sforce.soap.partner.LimitInfo[] limitInfo) {
    __LimitInfoHeader = new com.sforce.soap.partner.LimitInfoHeader_element();
    __LimitInfoHeader.setLimitInfo(limitInfo);
  }

  public void clearLimitInfoHeader() {
    __LimitInfoHeader = null;
  }

  public com.sforce.soap.partner.LimitInfoHeader_element getLimitInfoHeader() {
    return  __LimitInfoHeader;
  }

  public void __setLimitInfoHeader(com.sforce.soap.partner.LimitInfoHeader_element __header) {
    __LimitInfoHeader = __header ;
  }

  private com.sforce.soap.partner.DebuggingInfo_element __DebuggingInfo;

  public void setDebuggingInfo(java.lang.String debugLog) {
    __DebuggingInfo = new com.sforce.soap.partner.DebuggingInfo_element();
    __DebuggingInfo.setDebugLog(debugLog);
  }

  public void clearDebuggingInfo() {
    __DebuggingInfo = null;
  }

  public com.sforce.soap.partner.DebuggingInfo_element getDebuggingInfo() {
    return  __DebuggingInfo;
  }

  public void __setDebuggingInfo(com.sforce.soap.partner.DebuggingInfo_element __header) {
    __DebuggingInfo = __header ;
  }

  private com.sforce.soap.partner.PackageVersionHeader_element __PackageVersionHeader;

  public void setPackageVersionHeader(com.sforce.soap.partner.PackageVersion[] packageVersions) {
    __PackageVersionHeader = new com.sforce.soap.partner.PackageVersionHeader_element();
    __PackageVersionHeader.setPackageVersions(packageVersions);
  }

  public void clearPackageVersionHeader() {
    __PackageVersionHeader = null;
  }

  public com.sforce.soap.partner.PackageVersionHeader_element getPackageVersionHeader() {
    return  __PackageVersionHeader;
  }

  public void __setPackageVersionHeader(com.sforce.soap.partner.PackageVersionHeader_element __header) {
    __PackageVersionHeader = __header ;
  }

  private com.sforce.soap.partner.AllOrNoneHeader_element __AllOrNoneHeader;

  public void setAllOrNoneHeader(boolean allOrNone) {
    __AllOrNoneHeader = new com.sforce.soap.partner.AllOrNoneHeader_element();
    __AllOrNoneHeader.setAllOrNone(allOrNone);
  }

  public void clearAllOrNoneHeader() {
    __AllOrNoneHeader = null;
  }

  public com.sforce.soap.partner.AllOrNoneHeader_element getAllOrNoneHeader() {
    return  __AllOrNoneHeader;
  }

  public void __setAllOrNoneHeader(com.sforce.soap.partner.AllOrNoneHeader_element __header) {
    __AllOrNoneHeader = __header ;
  }

  private com.sforce.soap.partner.MruHeader_element __MruHeader;

  public void setMruHeader(boolean updateMru) {
    __MruHeader = new com.sforce.soap.partner.MruHeader_element();
    __MruHeader.setUpdateMru(updateMru);
  }

  public void clearMruHeader() {
    __MruHeader = null;
  }

  public com.sforce.soap.partner.MruHeader_element getMruHeader() {
    return  __MruHeader;
  }

  public void __setMruHeader(com.sforce.soap.partner.MruHeader_element __header) {
    __MruHeader = __header ;
  }

  private com.sforce.soap.partner.SessionHeader_element __SessionHeader;

  public void setSessionHeader(java.lang.String sessionId) {
    __SessionHeader = new com.sforce.soap.partner.SessionHeader_element();
    __SessionHeader.setSessionId(sessionId);
  }

  public void clearSessionHeader() {
    __SessionHeader = null;
  }

  public com.sforce.soap.partner.SessionHeader_element getSessionHeader() {
    return  __SessionHeader;
  }

  public void __setSessionHeader(com.sforce.soap.partner.SessionHeader_element __header) {
    __SessionHeader = __header ;
  }

  private com.sforce.soap.partner.CallOptions_element __CallOptions;

  public void setCallOptions(java.lang.String client,java.lang.String defaultNamespace) {
    __CallOptions = new com.sforce.soap.partner.CallOptions_element();
    __CallOptions.setClient(client);
    __CallOptions.setDefaultNamespace(defaultNamespace);
  }

  public void clearCallOptions() {
    __CallOptions = null;
  }

  public com.sforce.soap.partner.CallOptions_element getCallOptions() {
    return  __CallOptions;
  }

  public void __setCallOptions(com.sforce.soap.partner.CallOptions_element __header) {
    __CallOptions = __header ;
  }

  private com.sforce.soap.partner.StreamingEnabledHeader_element __StreamingEnabledHeader;

  public void setStreamingEnabledHeader(boolean streamingEnabled) {
    __StreamingEnabledHeader = new com.sforce.soap.partner.StreamingEnabledHeader_element();
    __StreamingEnabledHeader.setStreamingEnabled(streamingEnabled);
  }

  public void clearStreamingEnabledHeader() {
    __StreamingEnabledHeader = null;
  }

  public com.sforce.soap.partner.StreamingEnabledHeader_element getStreamingEnabledHeader() {
    return  __StreamingEnabledHeader;
  }

  public void __setStreamingEnabledHeader(com.sforce.soap.partner.StreamingEnabledHeader_element __header) {
    __StreamingEnabledHeader = __header ;
  }

  private com.sforce.soap.partner.LoginScopeHeader_element __LoginScopeHeader;

  public void setLoginScopeHeader(java.lang.String organizationId,java.lang.String portalId) {
    __LoginScopeHeader = new com.sforce.soap.partner.LoginScopeHeader_element();
    __LoginScopeHeader.setOrganizationId(organizationId);
    __LoginScopeHeader.setPortalId(portalId);
  }

  public void clearLoginScopeHeader() {
    __LoginScopeHeader = null;
  }

  public com.sforce.soap.partner.LoginScopeHeader_element getLoginScopeHeader() {
    return  __LoginScopeHeader;
  }

  public void __setLoginScopeHeader(com.sforce.soap.partner.LoginScopeHeader_element __header) {
    __LoginScopeHeader = __header ;
  }

  private com.sforce.soap.partner.UserTerritoryDeleteHeader_element __UserTerritoryDeleteHeader;

  public void setUserTerritoryDeleteHeader(java.lang.String transferToUserId) {
    __UserTerritoryDeleteHeader = new com.sforce.soap.partner.UserTerritoryDeleteHeader_element();
    __UserTerritoryDeleteHeader.setTransferToUserId(transferToUserId);
  }

  public void clearUserTerritoryDeleteHeader() {
    __UserTerritoryDeleteHeader = null;
  }

  public com.sforce.soap.partner.UserTerritoryDeleteHeader_element getUserTerritoryDeleteHeader() {
    return  __UserTerritoryDeleteHeader;
  }

  public void __setUserTerritoryDeleteHeader(com.sforce.soap.partner.UserTerritoryDeleteHeader_element __header) {
    __UserTerritoryDeleteHeader = __header ;
  }

  private com.sforce.soap.partner.DuplicateRuleHeader_element __DuplicateRuleHeader;

  public void setDuplicateRuleHeader(boolean allowSave,boolean includeRecordDetails,boolean runAsCurrentUser) {
    __DuplicateRuleHeader = new com.sforce.soap.partner.DuplicateRuleHeader_element();
    __DuplicateRuleHeader.setAllowSave(allowSave);
    __DuplicateRuleHeader.setIncludeRecordDetails(includeRecordDetails);
    __DuplicateRuleHeader.setRunAsCurrentUser(runAsCurrentUser);
  }

  public void clearDuplicateRuleHeader() {
    __DuplicateRuleHeader = null;
  }

  public com.sforce.soap.partner.DuplicateRuleHeader_element getDuplicateRuleHeader() {
    return  __DuplicateRuleHeader;
  }

  public void __setDuplicateRuleHeader(com.sforce.soap.partner.DuplicateRuleHeader_element __header) {
    __DuplicateRuleHeader = __header ;
  }



  public PartnerConnection(ConnectorConfig config) throws ConnectionException {
    this.__config = config;
    this.__typeMapper.setPackagePrefix(null);
    this.__typeMapper.setConfig(config);

    config.verifyPartnerEndpoint();
    if (!config.isManualLogin()) {
      if (config.getSessionId()==null) {
        config.setServiceEndpoint(config.getAuthEndpoint());
        com.sforce.soap.partner.LoginResult result = login(config.getUsername(), config.getPassword());
        config.setSessionId(result.getSessionId());
        config.setServiceEndpoint(result.getServerUrl());
      } else {
        if (config.getServiceEndpoint() == null) {
          throw new com.sforce.ws.ConnectionException("Please set ServiceEndpoint");
        }
      }
    }

      __SessionHeader = new SessionHeader_element();
      __SessionHeader.setSessionId(config.getSessionId());
  }

  private com.sforce.ws.transport.SoapConnection newConnection() {
      com.sforce.ws.transport.SoapConnection __c   = new com.sforce.ws.transport.SoapConnection(
           __config.getServiceEndpoint(), "urn:sobject.partner.soap.sforce.com", __typeMapper, __config);

      __c.setConnection(this);
      __c.setKnownHeaders(knownHeaders);
      return __c;
   }

  public com.sforce.soap.partner.DescribeTab[] describeAllTabs()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeAllTabs_element __request = new com.sforce.soap.partner.DescribeAllTabs_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeAllTabsResponse_element __response = (com.sforce.soap.partner.DescribeAllTabsResponse_element) __connection.send("",
       describeAllTabs_qname, __request, describeAllTabsResponse_qname,
       com.sforce.soap.partner.DescribeAllTabsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeDataCategoryGroupStructureResult[] describeDataCategoryGroupStructures(com.sforce.soap.partner.DataCategoryGroupSobjectTypePair[] pairs,boolean topCategoriesOnly)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeDataCategoryGroupStructures_element __request = new com.sforce.soap.partner.DescribeDataCategoryGroupStructures_element();

    __request.setPairs(pairs);
    __request.setTopCategoriesOnly(topCategoriesOnly);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeDataCategoryGroupStructuresResponse_element __response = (com.sforce.soap.partner.DescribeDataCategoryGroupStructuresResponse_element) __connection.send("",
       describeDataCategoryGroupStructures_qname, __request, describeDataCategoryGroupStructuresResponse_qname,
       com.sforce.soap.partner.DescribeDataCategoryGroupStructuresResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeDataCategoryGroupResult[] describeDataCategoryGroups(java.lang.String[] sObjectType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeDataCategoryGroups_element __request = new com.sforce.soap.partner.DescribeDataCategoryGroups_element();

    __request.setSObjectType(sObjectType);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeDataCategoryGroupsResponse_element __response = (com.sforce.soap.partner.DescribeDataCategoryGroupsResponse_element) __connection.send("",
       describeDataCategoryGroups_qname, __request, describeDataCategoryGroupsResponse_qname,
       com.sforce.soap.partner.DescribeDataCategoryGroupsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.FindDuplicatesResult[] findDuplicates(com.sforce.soap.partner.sobject.SObject[] sObjects)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.FindDuplicates_element __request = new com.sforce.soap.partner.FindDuplicates_element();

    __request.setSObjects(sObjects);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.FindDuplicatesResponse_element __response = (com.sforce.soap.partner.FindDuplicatesResponse_element) __connection.send("",
       findDuplicates_qname, __request, findDuplicatesResponse_qname,
       com.sforce.soap.partner.FindDuplicatesResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.ProcessResult[] process(com.sforce.soap.partner.ProcessRequest[] actions)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.Process_element __request = new com.sforce.soap.partner.Process_element();

    __request.setActions(actions);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.ProcessResponse_element __response = (com.sforce.soap.partner.ProcessResponse_element) __connection.send("",
       process_qname, __request, processResponse_qname,
       com.sforce.soap.partner.ProcessResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeGlobalResult describeGlobal()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeGlobal_element __request = new com.sforce.soap.partner.DescribeGlobal_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeGlobalResponse_element __response = (com.sforce.soap.partner.DescribeGlobalResponse_element) __connection.send("",
       describeGlobal_qname, __request, describeGlobalResponse_qname,
       com.sforce.soap.partner.DescribeGlobalResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.GetUserInfoResult getUserInfo()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.GetUserInfo_element __request = new com.sforce.soap.partner.GetUserInfo_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.GetUserInfoResponse_element __response = (com.sforce.soap.partner.GetUserInfoResponse_element) __connection.send("",
       getUserInfo_qname, __request, getUserInfoResponse_qname,
       com.sforce.soap.partner.GetUserInfoResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeGlobalTheme describeGlobalTheme()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeGlobalTheme_element __request = new com.sforce.soap.partner.DescribeGlobalTheme_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeGlobalThemeResponse_element __response = (com.sforce.soap.partner.DescribeGlobalThemeResponse_element) __connection.send("",
       describeGlobalTheme_qname, __request, describeGlobalThemeResponse_qname,
       com.sforce.soap.partner.DescribeGlobalThemeResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeApprovalLayoutResult describeApprovalLayout(java.lang.String sObjectType,java.lang.String[] approvalProcessNames)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeApprovalLayout_element __request = new com.sforce.soap.partner.DescribeApprovalLayout_element();

    __request.setSObjectType(sObjectType);
    __request.setApprovalProcessNames(approvalProcessNames);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeApprovalLayoutResponse_element __response = (com.sforce.soap.partner.DescribeApprovalLayoutResponse_element) __connection.send("",
       describeApprovalLayout_qname, __request, describeApprovalLayoutResponse_qname,
       com.sforce.soap.partner.DescribeApprovalLayoutResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeCompactLayout[] describePrimaryCompactLayouts(java.lang.String[] sObjectTypes)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribePrimaryCompactLayouts_element __request = new com.sforce.soap.partner.DescribePrimaryCompactLayouts_element();

    __request.setSObjectTypes(sObjectTypes);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribePrimaryCompactLayoutsResponse_element __response = (com.sforce.soap.partner.DescribePrimaryCompactLayoutsResponse_element) __connection.send("",
       describePrimaryCompactLayouts_qname, __request, describePrimaryCompactLayoutsResponse_qname,
       com.sforce.soap.partner.DescribePrimaryCompactLayoutsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.QueryResult queryMore(java.lang.String queryLocator)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.QueryMore_element __request = new com.sforce.soap.partner.QueryMore_element();

    __request.setQueryLocator(queryLocator);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__QueryOptions != null) __connection.addHeader(QueryOptions_qname, __QueryOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.QueryMoreResponse_element __response = (com.sforce.soap.partner.QueryMoreResponse_element) __connection.send("",
       queryMore_qname, __request, queryMoreResponse_qname,
       com.sforce.soap.partner.QueryMoreResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeSearchableEntityResult[] describeSearchableEntities(boolean includeOnlyEntitiesWithTabs)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeSearchableEntities_element __request = new com.sforce.soap.partner.DescribeSearchableEntities_element();

    __request.setIncludeOnlyEntitiesWithTabs(includeOnlyEntitiesWithTabs);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeSearchableEntitiesResponse_element __response = (com.sforce.soap.partner.DescribeSearchableEntitiesResponse_element) __connection.send("",
       describeSearchableEntities_qname, __request, describeSearchableEntitiesResponse_qname,
       com.sforce.soap.partner.DescribeSearchableEntitiesResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeLayoutResult describeLayout(java.lang.String sObjectType,java.lang.String layoutName,java.lang.String[] recordTypeIds)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeLayout_element __request = new com.sforce.soap.partner.DescribeLayout_element();

    __request.setSObjectType(sObjectType);
    __request.setLayoutName(layoutName);
    __request.setRecordTypeIds(recordTypeIds);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeLayoutResponse_element __response = (com.sforce.soap.partner.DescribeLayoutResponse_element) __connection.send("",
       describeLayout_qname, __request, describeLayoutResponse_qname,
       com.sforce.soap.partner.DescribeLayoutResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeAppMenuResult describeAppMenu(com.sforce.soap.partner.AppMenuType appMenuType,java.lang.String networkId)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeAppMenu_element __request = new com.sforce.soap.partner.DescribeAppMenu_element();

    __request.setAppMenuType(appMenuType);
    __request.setNetworkId(networkId);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeAppMenuResponse_element __response = (com.sforce.soap.partner.DescribeAppMenuResponse_element) __connection.send("",
       describeAppMenu_qname, __request, describeAppMenuResponse_qname,
       com.sforce.soap.partner.DescribeAppMenuResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeLookupLayoutResult[] describeLookupLayouts(java.lang.String[] sObjectType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeLookupLayouts_element __request = new com.sforce.soap.partner.DescribeLookupLayouts_element();

    __request.setSObjectType(sObjectType);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeLookupLayoutsResponse_element __response = (com.sforce.soap.partner.DescribeLookupLayoutsResponse_element) __connection.send("",
       describeLookupLayouts_qname, __request, describeLookupLayoutsResponse_qname,
       com.sforce.soap.partner.DescribeLookupLayoutsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.LeadConvertResult[] convertLead(com.sforce.soap.partner.LeadConvert[] leadConverts)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.ConvertLead_element __request = new com.sforce.soap.partner.ConvertLead_element();

    __request.setLeadConverts(leadConverts);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.ConvertLeadResponse_element __response = (com.sforce.soap.partner.ConvertLeadResponse_element) __connection.send("",
       convertLead_qname, __request, convertLeadResponse_qname,
       com.sforce.soap.partner.ConvertLeadResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeSoqlListViewResult describeSObjectListViews(java.lang.String sObjectType,boolean recentsOnly,com.sforce.soap.partner.ListViewIsSoqlCompatible isSoqlCompatible,int limit,int offset)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeSObjectListViews_element __request = new com.sforce.soap.partner.DescribeSObjectListViews_element();

    __request.setSObjectType(sObjectType);
    __request.setRecentsOnly(recentsOnly);
    __request.setIsSoqlCompatible(isSoqlCompatible);
    __request.setLimit(limit);
    __request.setOffset(offset);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeSObjectListViewsResponse_element __response = (com.sforce.soap.partner.DescribeSObjectListViewsResponse_element) __connection.send("",
       describeSObjectListViews_qname, __request, describeSObjectListViewsResponse_qname,
       com.sforce.soap.partner.DescribeSObjectListViewsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DeleteResult[] delete(java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.Delete_element __request = new com.sforce.soap.partner.Delete_element();

    __request.setIds(ids);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);
    if (__UserTerritoryDeleteHeader != null) __connection.addHeader(UserTerritoryDeleteHeader_qname, __UserTerritoryDeleteHeader);
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DeleteResponse_element __response = (com.sforce.soap.partner.DeleteResponse_element) __connection.send("",
       delete_qname, __request, deleteResponse_qname,
       com.sforce.soap.partner.DeleteResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.LoginResult login(java.lang.String username,java.lang.String password)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.Login_element __request = new com.sforce.soap.partner.Login_element();

    __request.setUsername(username);
    __request.setPassword(password);

    if (__LoginScopeHeader != null) __connection.addHeader(LoginScopeHeader_qname, __LoginScopeHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.LoginResponse_element __response = (com.sforce.soap.partner.LoginResponse_element) __connection.send("",
       login_qname, __request, loginResponse_qname,
       com.sforce.soap.partner.LoginResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.QueryResult queryAll(java.lang.String queryString)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.QueryAll_element __request = new com.sforce.soap.partner.QueryAll_element();

    __request.setQueryString(queryString);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__QueryOptions != null) __connection.addHeader(QueryOptions_qname, __QueryOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.QueryAllResponse_element __response = (com.sforce.soap.partner.QueryAllResponse_element) __connection.send("",
       queryAll_qname, __request, queryAllResponse_qname,
       com.sforce.soap.partner.QueryAllResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.SaveResult[] update(com.sforce.soap.partner.sobject.SObject[] sObjects)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.Update_element __request = new com.sforce.soap.partner.Update_element();

    __request.setSObjects(sObjects);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__AssignmentRuleHeader != null) __connection.addHeader(AssignmentRuleHeader_qname, __AssignmentRuleHeader);
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);
    if (__OwnerChangeOptions != null) __connection.addHeader(OwnerChangeOptions_qname, __OwnerChangeOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.UpdateResponse_element __response = (com.sforce.soap.partner.UpdateResponse_element) __connection.send("",
       update_qname, __request, updateResponse_qname,
       com.sforce.soap.partner.UpdateResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.EmptyRecycleBinResult[] emptyRecycleBin(java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.EmptyRecycleBin_element __request = new com.sforce.soap.partner.EmptyRecycleBin_element();

    __request.setIds(ids);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.EmptyRecycleBinResponse_element __response = (com.sforce.soap.partner.EmptyRecycleBinResponse_element) __connection.send("",
       emptyRecycleBin_qname, __request, emptyRecycleBinResponse_qname,
       com.sforce.soap.partner.EmptyRecycleBinResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeCompactLayoutsResult describeCompactLayouts(java.lang.String sObjectType,java.lang.String[] recordTypeIds)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeCompactLayouts_element __request = new com.sforce.soap.partner.DescribeCompactLayouts_element();

    __request.setSObjectType(sObjectType);
    __request.setRecordTypeIds(recordTypeIds);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeCompactLayoutsResponse_element __response = (com.sforce.soap.partner.DescribeCompactLayoutsResponse_element) __connection.send("",
       describeCompactLayouts_qname, __request, describeCompactLayoutsResponse_qname,
       com.sforce.soap.partner.DescribeCompactLayoutsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.ChangeOwnPasswordResult changeOwnPassword(java.lang.String oldPassword,java.lang.String newPassword)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.ChangeOwnPassword_element __request = new com.sforce.soap.partner.ChangeOwnPassword_element();

    __request.setOldPassword(oldPassword);
    __request.setNewPassword(newPassword);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.ChangeOwnPasswordResponse_element __response = (com.sforce.soap.partner.ChangeOwnPasswordResponse_element) __connection.send("",
       changeOwnPassword_qname, __request, changeOwnPasswordResponse_qname,
       com.sforce.soap.partner.ChangeOwnPasswordResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeSoqlListViewResult describeSoqlListViews(com.sforce.soap.partner.DescribeSoqlListViewsRequest request)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeSoqlListViews_element __request = new com.sforce.soap.partner.DescribeSoqlListViews_element();

    __request.setRequest(request);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeSoqlListViewsResponse_element __response = (com.sforce.soap.partner.DescribeSoqlListViewsResponse_element) __connection.send("",
       describeSoqlListViews_qname, __request, describeSoqlListViewsResponse_qname,
       com.sforce.soap.partner.DescribeSoqlListViewsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribePathAssistantsResult describePathAssistants(java.lang.String sObjectType,java.lang.String picklistValue,java.lang.String[] recordTypeIds)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribePathAssistants_element __request = new com.sforce.soap.partner.DescribePathAssistants_element();

    __request.setSObjectType(sObjectType);
    __request.setPicklistValue(picklistValue);
    __request.setRecordTypeIds(recordTypeIds);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribePathAssistantsResponse_element __response = (com.sforce.soap.partner.DescribePathAssistantsResponse_element) __connection.send("",
       describePathAssistants_qname, __request, describePathAssistantsResponse_qname,
       com.sforce.soap.partner.DescribePathAssistantsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeAvailableQuickActionResult[] describeAvailableQuickActions(java.lang.String contextType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeAvailableQuickActions_element __request = new com.sforce.soap.partner.DescribeAvailableQuickActions_element();

    __request.setContextType(contextType);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeAvailableQuickActionsResponse_element __response = (com.sforce.soap.partner.DescribeAvailableQuickActionsResponse_element) __connection.send("",
       describeAvailableQuickActions_qname, __request, describeAvailableQuickActionsResponse_qname,
       com.sforce.soap.partner.DescribeAvailableQuickActionsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.GetDeletedResult getDeleted(java.lang.String sObjectType,java.util.Calendar startDate,java.util.Calendar endDate)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.GetDeleted_element __request = new com.sforce.soap.partner.GetDeleted_element();

    __request.setSObjectType(sObjectType);
    __request.setStartDate(startDate);
    __request.setEndDate(endDate);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.GetDeletedResponse_element __response = (com.sforce.soap.partner.GetDeletedResponse_element) __connection.send("",
       getDeleted_qname, __request, getDeletedResponse_qname,
       com.sforce.soap.partner.GetDeletedResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeTabSetResult[] describeTabs()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeTabs_element __request = new com.sforce.soap.partner.DescribeTabs_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeTabsResponse_element __response = (com.sforce.soap.partner.DescribeTabsResponse_element) __connection.send("",
       describeTabs_qname, __request, describeTabsResponse_qname,
       com.sforce.soap.partner.DescribeTabsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.QuickActionTemplateResult[] retrieveMassQuickActionTemplates(java.lang.String quickActionName,java.lang.String[] contextIds)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.RetrieveMassQuickActionTemplates_element __request = new com.sforce.soap.partner.RetrieveMassQuickActionTemplates_element();

    __request.setQuickActionName(quickActionName);
    __request.setContextIds(contextIds);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.RetrieveMassQuickActionTemplatesResponse_element __response = (com.sforce.soap.partner.RetrieveMassQuickActionTemplatesResponse_element) __connection.send("",
       retrieveMassQuickActionTemplates_qname, __request, retrieveMassQuickActionTemplatesResponse_qname,
       com.sforce.soap.partner.RetrieveMassQuickActionTemplatesResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.SearchResult search(java.lang.String searchString)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.Search_element __request = new com.sforce.soap.partner.Search_element();

    __request.setSearchString(searchString);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.SearchResponse_element __response = (com.sforce.soap.partner.SearchResponse_element) __connection.send("",
       search_qname, __request, searchResponse_qname,
       com.sforce.soap.partner.SearchResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.SendEmailResult[] sendEmail(com.sforce.soap.partner.Email[] messages)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.SendEmail_element __request = new com.sforce.soap.partner.SendEmail_element();

    __request.setMessages(messages);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.SendEmailResponse_element __response = (com.sforce.soap.partner.SendEmailResponse_element) __connection.send("",
       sendEmail_qname, __request, sendEmailResponse_qname,
       com.sforce.soap.partner.SendEmailResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.GetUpdatedResult getUpdated(java.lang.String sObjectType,java.util.Calendar startDate,java.util.Calendar endDate)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.GetUpdated_element __request = new com.sforce.soap.partner.GetUpdated_element();

    __request.setSObjectType(sObjectType);
    __request.setStartDate(startDate);
    __request.setEndDate(endDate);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.GetUpdatedResponse_element __response = (com.sforce.soap.partner.GetUpdatedResponse_element) __connection.send("",
       getUpdated_qname, __request, getUpdatedResponse_qname,
       com.sforce.soap.partner.GetUpdatedResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.SendEmailResult[] sendEmailMessage(java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.SendEmailMessage_element __request = new com.sforce.soap.partner.SendEmailMessage_element();

    __request.setIds(ids);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.SendEmailMessageResponse_element __response = (com.sforce.soap.partner.SendEmailMessageResponse_element) __connection.send("",
       sendEmailMessage_qname, __request, sendEmailMessageResponse_qname,
       com.sforce.soap.partner.SendEmailMessageResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeQuickActionResult[] describeQuickActionsForRecordType(java.lang.String[] quickActions,java.lang.String recordTypeId)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeQuickActionsForRecordType_element __request = new com.sforce.soap.partner.DescribeQuickActionsForRecordType_element();

    __request.setQuickActions(quickActions);
    __request.setRecordTypeId(recordTypeId);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeQuickActionsForRecordTypeResponse_element __response = (com.sforce.soap.partner.DescribeQuickActionsForRecordTypeResponse_element) __connection.send("",
       describeQuickActionsForRecordType_qname, __request, describeQuickActionsForRecordTypeResponse_qname,
       com.sforce.soap.partner.DescribeQuickActionsForRecordTypeResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.RenderEmailTemplateResult[] renderEmailTemplate(com.sforce.soap.partner.RenderEmailTemplateRequest[] renderRequests)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.RenderEmailTemplate_element __request = new com.sforce.soap.partner.RenderEmailTemplate_element();

    __request.setRenderRequests(renderRequests);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.RenderEmailTemplateResponse_element __response = (com.sforce.soap.partner.RenderEmailTemplateResponse_element) __connection.send("",
       renderEmailTemplate_qname, __request, renderEmailTemplateResponse_qname,
       com.sforce.soap.partner.RenderEmailTemplateResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.UpsertResult[] upsert(java.lang.String externalIDFieldName,com.sforce.soap.partner.sobject.SObject[] sObjects)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.Upsert_element __request = new com.sforce.soap.partner.Upsert_element();

    __request.setExternalIDFieldName(externalIDFieldName);
    __request.setSObjects(sObjects);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__AssignmentRuleHeader != null) __connection.addHeader(AssignmentRuleHeader_qname, __AssignmentRuleHeader);
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);
    if (__OwnerChangeOptions != null) __connection.addHeader(OwnerChangeOptions_qname, __OwnerChangeOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.UpsertResponse_element __response = (com.sforce.soap.partner.UpsertResponse_element) __connection.send("",
       upsert_qname, __request, upsertResponse_qname,
       com.sforce.soap.partner.UpsertResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.QueryResult query(java.lang.String queryString)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.Query_element __request = new com.sforce.soap.partner.Query_element();

    __request.setQueryString(queryString);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__QueryOptions != null) __connection.addHeader(QueryOptions_qname, __QueryOptions);
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.QueryResponse_element __response = (com.sforce.soap.partner.QueryResponse_element) __connection.send("",
       query_qname, __request, queryResponse_qname,
       com.sforce.soap.partner.QueryResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeQuickActionResult[] describeQuickActions(java.lang.String[] quickActions)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeQuickActions_element __request = new com.sforce.soap.partner.DescribeQuickActions_element();

    __request.setQuickActions(quickActions);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeQuickActionsResponse_element __response = (com.sforce.soap.partner.DescribeQuickActionsResponse_element) __connection.send("",
       describeQuickActions_qname, __request, describeQuickActionsResponse_qname,
       com.sforce.soap.partner.DescribeQuickActionsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.PerformQuickActionResult[] performQuickActions(com.sforce.soap.partner.PerformQuickActionRequest[] quickActions)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.PerformQuickActions_element __request = new com.sforce.soap.partner.PerformQuickActions_element();

    __request.setQuickActions(quickActions);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__AssignmentRuleHeader != null) __connection.addHeader(AssignmentRuleHeader_qname, __AssignmentRuleHeader);
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);
    if (__OwnerChangeOptions != null) __connection.addHeader(OwnerChangeOptions_qname, __OwnerChangeOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.PerformQuickActionsResponse_element __response = (com.sforce.soap.partner.PerformQuickActionsResponse_element) __connection.send("",
       performQuickActions_qname, __request, performQuickActionsResponse_qname,
       com.sforce.soap.partner.PerformQuickActionsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeSObjectResult[] describeSObjects(java.lang.String[] sObjectType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeSObjects_element __request = new com.sforce.soap.partner.DescribeSObjects_element();

    __request.setSObjectType(sObjectType);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeSObjectsResponse_element __response = (com.sforce.soap.partner.DescribeSObjectsResponse_element) __connection.send("",
       describeSObjects_qname, __request, describeSObjectsResponse_qname,
       com.sforce.soap.partner.DescribeSObjectsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.KnowledgeSettings describeKnowledgeSettings()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeKnowledgeSettings_element __request = new com.sforce.soap.partner.DescribeKnowledgeSettings_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeKnowledgeSettingsResponse_element __response = (com.sforce.soap.partner.DescribeKnowledgeSettingsResponse_element) __connection.send("",
       describeKnowledgeSettings_qname, __request, describeKnowledgeSettingsResponse_qname,
       com.sforce.soap.partner.DescribeKnowledgeSettingsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.UndeleteResult[] undelete(java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.Undelete_element __request = new com.sforce.soap.partner.Undelete_element();

    __request.setIds(ids);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.UndeleteResponse_element __response = (com.sforce.soap.partner.UndeleteResponse_element) __connection.send("",
       undelete_qname, __request, undeleteResponse_qname,
       com.sforce.soap.partner.UndeleteResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.sobject.SObject[] retrieve(java.lang.String fieldList,java.lang.String sObjectType,java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.Retrieve_element __request = new com.sforce.soap.partner.Retrieve_element();

    __request.setFieldList(fieldList);
    __request.setSObjectType(sObjectType);
    __request.setIds(ids);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__QueryOptions != null) __connection.addHeader(QueryOptions_qname, __QueryOptions);
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.RetrieveResponse_element __response = (com.sforce.soap.partner.RetrieveResponse_element) __connection.send("",
       retrieve_qname, __request, retrieveResponse_qname,
       com.sforce.soap.partner.RetrieveResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeThemeResult describeTheme(java.lang.String[] sobjectType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeTheme_element __request = new com.sforce.soap.partner.DescribeTheme_element();

    __request.setSobjectType(sobjectType);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeThemeResponse_element __response = (com.sforce.soap.partner.DescribeThemeResponse_element) __connection.send("",
       describeTheme_qname, __request, describeThemeResponse_qname,
       com.sforce.soap.partner.DescribeThemeResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DeleteByExampleResult[] deleteByExample(com.sforce.soap.partner.sobject.SObject[] sObjects)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DeleteByExample_element __request = new com.sforce.soap.partner.DeleteByExample_element();

    __request.setSObjects(sObjects);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);
    if (__UserTerritoryDeleteHeader != null) __connection.addHeader(UserTerritoryDeleteHeader_qname, __UserTerritoryDeleteHeader);
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DeleteByExampleResponse_element __response = (com.sforce.soap.partner.DeleteByExampleResponse_element) __connection.send("",
       deleteByExample_qname, __request, deleteByExampleResponse_qname,
       com.sforce.soap.partner.DeleteByExampleResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeNounResult[] describeNouns(java.lang.String[] nouns,boolean onlyRenamed,boolean includeFields)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeNouns_element __request = new com.sforce.soap.partner.DescribeNouns_element();

    __request.setNouns(nouns);
    __request.setOnlyRenamed(onlyRenamed);
    __request.setIncludeFields(includeFields);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeNounsResponse_element __response = (com.sforce.soap.partner.DescribeNounsResponse_element) __connection.send("",
       describeNouns_qname, __request, describeNounsResponse_qname,
       com.sforce.soap.partner.DescribeNounsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.FindDuplicatesResult[] findDuplicatesByIds(java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.FindDuplicatesByIds_element __request = new com.sforce.soap.partner.FindDuplicatesByIds_element();

    __request.setIds(ids);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.FindDuplicatesByIdsResponse_element __response = (com.sforce.soap.partner.FindDuplicatesByIdsResponse_element) __connection.send("",
       findDuplicatesByIds_qname, __request, findDuplicatesByIdsResponse_qname,
       com.sforce.soap.partner.FindDuplicatesByIdsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.ExecuteListViewResult executeListView(com.sforce.soap.partner.ExecuteListViewRequest request)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.ExecuteListView_element __request = new com.sforce.soap.partner.ExecuteListView_element();

    __request.setRequest(request);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.ExecuteListViewResponse_element __response = (com.sforce.soap.partner.ExecuteListViewResponse_element) __connection.send("",
       executeListView_qname, __request, executeListViewResponse_qname,
       com.sforce.soap.partner.ExecuteListViewResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.RenderStoredEmailTemplateResult renderStoredEmailTemplate(com.sforce.soap.partner.RenderStoredEmailTemplateRequest request)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.RenderStoredEmailTemplate_element __request = new com.sforce.soap.partner.RenderStoredEmailTemplate_element();

    __request.setRequest(request);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.RenderStoredEmailTemplateResponse_element __response = (com.sforce.soap.partner.RenderStoredEmailTemplateResponse_element) __connection.send("",
       renderStoredEmailTemplate_qname, __request, renderStoredEmailTemplateResponse_qname,
       com.sforce.soap.partner.RenderStoredEmailTemplateResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeVisualForceResult describeVisualForce(boolean includeAllDetails,java.lang.String namespacePrefix)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeVisualForce_element __request = new com.sforce.soap.partner.DescribeVisualForce_element();

    __request.setIncludeAllDetails(includeAllDetails);
    __request.setNamespacePrefix(namespacePrefix);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeVisualForceResponse_element __response = (com.sforce.soap.partner.DescribeVisualForceResponse_element) __connection.send("",
       describeVisualForce_qname, __request, describeVisualForceResponse_qname,
       com.sforce.soap.partner.DescribeVisualForceResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeSObjectResult describeSObject(java.lang.String sObjectType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeSObject_element __request = new com.sforce.soap.partner.DescribeSObject_element();

    __request.setSObjectType(sObjectType);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeSObjectResponse_element __response = (com.sforce.soap.partner.DescribeSObjectResponse_element) __connection.send("",
       describeSObject_qname, __request, describeSObjectResponse_qname,
       com.sforce.soap.partner.DescribeSObjectResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.GetServerTimestampResult getServerTimestamp()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.GetServerTimestamp_element __request = new com.sforce.soap.partner.GetServerTimestamp_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.GetServerTimestampResponse_element __response = (com.sforce.soap.partner.GetServerTimestampResponse_element) __connection.send("",
       getServerTimestamp_qname, __request, getServerTimestampResponse_qname,
       com.sforce.soap.partner.GetServerTimestampResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.QuickActionTemplateResult[] retrieveQuickActionTemplates(java.lang.String[] quickActionNames,java.lang.String contextId)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.RetrieveQuickActionTemplates_element __request = new com.sforce.soap.partner.RetrieveQuickActionTemplates_element();

    __request.setQuickActionNames(quickActionNames);
    __request.setContextId(contextId);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.RetrieveQuickActionTemplatesResponse_element __response = (com.sforce.soap.partner.RetrieveQuickActionTemplatesResponse_element) __connection.send("",
       retrieveQuickActionTemplates_qname, __request, retrieveQuickActionTemplatesResponse_qname,
       com.sforce.soap.partner.RetrieveQuickActionTemplatesResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.SetPasswordResult setPassword(java.lang.String userId,java.lang.String password)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.SetPassword_element __request = new com.sforce.soap.partner.SetPassword_element();

    __request.setUserId(userId);
    __request.setPassword(password);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.SetPasswordResponse_element __response = (com.sforce.soap.partner.SetPasswordResponse_element) __connection.send("",
       setPassword_qname, __request, setPasswordResponse_qname,
       com.sforce.soap.partner.SetPasswordResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.ResetPasswordResult resetPassword(java.lang.String userId)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.ResetPassword_element __request = new com.sforce.soap.partner.ResetPassword_element();

    __request.setUserId(userId);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.ResetPasswordResponse_element __response = (com.sforce.soap.partner.ResetPasswordResponse_element) __connection.send("",
       resetPassword_qname, __request, resetPasswordResponse_qname,
       com.sforce.soap.partner.ResetPasswordResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeSoftphoneLayoutResult describeSoftphoneLayout()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeSoftphoneLayout_element __request = new com.sforce.soap.partner.DescribeSoftphoneLayout_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeSoftphoneLayoutResponse_element __response = (com.sforce.soap.partner.DescribeSoftphoneLayoutResponse_element) __connection.send("",
       describeSoftphoneLayout_qname, __request, describeSoftphoneLayoutResponse_qname,
       com.sforce.soap.partner.DescribeSoftphoneLayoutResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.SaveResult[] create(com.sforce.soap.partner.sobject.SObject[] sObjects)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.Create_element __request = new com.sforce.soap.partner.Create_element();

    __request.setSObjects(sObjects);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__AssignmentRuleHeader != null) __connection.addHeader(AssignmentRuleHeader_qname, __AssignmentRuleHeader);
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.CreateResponse_element __response = (com.sforce.soap.partner.CreateResponse_element) __connection.send("",
       create_qname, __request, createResponse_qname,
       com.sforce.soap.partner.CreateResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeSearchLayoutResult[] describeSearchLayouts(java.lang.String[] sObjectType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeSearchLayouts_element __request = new com.sforce.soap.partner.DescribeSearchLayouts_element();

    __request.setSObjectType(sObjectType);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeSearchLayoutsResponse_element __response = (com.sforce.soap.partner.DescribeSearchLayoutsResponse_element) __connection.send("",
       describeSearchLayouts_qname, __request, describeSearchLayoutsResponse_qname,
       com.sforce.soap.partner.DescribeSearchLayoutsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.MergeResult[] merge(com.sforce.soap.partner.MergeRequest[] request)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.Merge_element __request = new com.sforce.soap.partner.Merge_element();

    __request.setRequest(request);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__AssignmentRuleHeader != null) __connection.addHeader(AssignmentRuleHeader_qname, __AssignmentRuleHeader);
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.MergeResponse_element __response = (com.sforce.soap.partner.MergeResponse_element) __connection.send("",
       merge_qname, __request, mergeResponse_qname,
       com.sforce.soap.partner.MergeResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.InvalidateSessionsResult[] invalidateSessions(java.lang.String[] sessionIds)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.InvalidateSessions_element __request = new com.sforce.soap.partner.InvalidateSessions_element();

    __request.setSessionIds(sessionIds);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

    com.sforce.soap.partner.InvalidateSessionsResponse_element __response = (com.sforce.soap.partner.InvalidateSessionsResponse_element) __connection.send("",
       invalidateSessions_qname, __request, invalidateSessionsResponse_qname,
       com.sforce.soap.partner.InvalidateSessionsResponse_element.class);

    return __response.getResult();
  }public com.sforce.soap.partner.DescribeListViewResult[] describeListViews(java.lang.String[] sObjectType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeListViews_element __request = new com.sforce.soap.partner.DescribeListViews_element();

    __request.setSObjectType(sObjectType);

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    if (__ConditionalRequestHeader != null) __connection.addHeader(ConditionalRequestHeader_qname, __ConditionalRequestHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeListViewsResponse_element __response = (com.sforce.soap.partner.DescribeListViewsResponse_element) __connection.send("",
       describeListViews_qname, __request, describeListViewsResponse_qname,
       com.sforce.soap.partner.DescribeListViewsResponse_element.class);

    return __response.getResult();
  }public void logout()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.Logout_element __request = new com.sforce.soap.partner.Logout_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);

    addHeaders(__connection);

__connection.send("",
       logout_qname, __request, logoutResponse_qname,
       com.sforce.soap.partner.LogoutResponse_element.class);

  }public com.sforce.soap.partner.DescribeSearchScopeOrderResult[] describeSearchScopeOrder()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.partner.DescribeSearchScopeOrder_element __request = new com.sforce.soap.partner.DescribeSearchScopeOrder_element();

    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    if (__CallOptions != null) __connection.addHeader(CallOptions_qname, __CallOptions);
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);

    addHeaders(__connection);

    com.sforce.soap.partner.DescribeSearchScopeOrderResponse_element __response = (com.sforce.soap.partner.DescribeSearchScopeOrderResponse_element) __connection.send("",
       describeSearchScopeOrder_qname, __request, describeSearchScopeOrderResponse_qname,
       com.sforce.soap.partner.DescribeSearchScopeOrderResponse_element.class);

    return __response.getResult();
  }

  private void addHeaders(com.sforce.ws.transport.SoapConnection __connection) {
    for(java.util.Map.Entry<QName, XMLizable> entry : __extraHeaders.entrySet()) {
      __connection.addHeader(entry.getKey(), entry.getValue());
    }
  }

  public void addExtraHeader(QName __headerName, XMLizable __value) {
    __extraHeaders.put(__headerName, __value);
  }

  public void removeExtraHeader(QName __headerName) {
    __extraHeaders.remove(__headerName);
  }

  public XMLizable getExtraHeader(QName __headerName) {
    return __extraHeaders.get(__headerName);
  }

  public void clearExtraHeaders() {
    __extraHeaders = new HashMap<QName, XMLizable>();
  }

    private static final javax.xml.namespace.QName describeAllTabs_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeAllTabs");
    private static final javax.xml.namespace.QName describeAllTabsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeAllTabsResponse");
    private static final javax.xml.namespace.QName describeDataCategoryGroupStructures_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeDataCategoryGroupStructures");
    private static final javax.xml.namespace.QName describeDataCategoryGroupStructuresResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeDataCategoryGroupStructuresResponse");
    private static final javax.xml.namespace.QName describeDataCategoryGroups_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeDataCategoryGroups");
    private static final javax.xml.namespace.QName describeDataCategoryGroupsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeDataCategoryGroupsResponse");
    private static final javax.xml.namespace.QName findDuplicates_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "findDuplicates");
    private static final javax.xml.namespace.QName findDuplicatesResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "findDuplicatesResponse");
    private static final javax.xml.namespace.QName process_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "process");
    private static final javax.xml.namespace.QName processResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "processResponse");
    private static final javax.xml.namespace.QName describeGlobal_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeGlobal");
    private static final javax.xml.namespace.QName describeGlobalResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeGlobalResponse");
    private static final javax.xml.namespace.QName getUserInfo_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "getUserInfo");
    private static final javax.xml.namespace.QName getUserInfoResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "getUserInfoResponse");
    private static final javax.xml.namespace.QName describeGlobalTheme_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeGlobalTheme");
    private static final javax.xml.namespace.QName describeGlobalThemeResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeGlobalThemeResponse");
    private static final javax.xml.namespace.QName describeApprovalLayout_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeApprovalLayout");
    private static final javax.xml.namespace.QName describeApprovalLayoutResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeApprovalLayoutResponse");
    private static final javax.xml.namespace.QName describePrimaryCompactLayouts_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describePrimaryCompactLayouts");
    private static final javax.xml.namespace.QName describePrimaryCompactLayoutsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describePrimaryCompactLayoutsResponse");
    private static final javax.xml.namespace.QName queryMore_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "queryMore");
    private static final javax.xml.namespace.QName queryMoreResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "queryMoreResponse");
    private static final javax.xml.namespace.QName describeSearchableEntities_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSearchableEntities");
    private static final javax.xml.namespace.QName describeSearchableEntitiesResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSearchableEntitiesResponse");
    private static final javax.xml.namespace.QName describeLayout_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeLayout");
    private static final javax.xml.namespace.QName describeLayoutResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeLayoutResponse");
    private static final javax.xml.namespace.QName describeAppMenu_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeAppMenu");
    private static final javax.xml.namespace.QName describeAppMenuResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeAppMenuResponse");
    private static final javax.xml.namespace.QName describeLookupLayouts_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeLookupLayouts");
    private static final javax.xml.namespace.QName describeLookupLayoutsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeLookupLayoutsResponse");
    private static final javax.xml.namespace.QName convertLead_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "convertLead");
    private static final javax.xml.namespace.QName convertLeadResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "convertLeadResponse");
    private static final javax.xml.namespace.QName describeSObjectListViews_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSObjectListViews");
    private static final javax.xml.namespace.QName describeSObjectListViewsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSObjectListViewsResponse");
    private static final javax.xml.namespace.QName delete_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "delete");
    private static final javax.xml.namespace.QName deleteResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "deleteResponse");
    private static final javax.xml.namespace.QName login_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "login");
    private static final javax.xml.namespace.QName loginResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "loginResponse");
    private static final javax.xml.namespace.QName queryAll_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "queryAll");
    private static final javax.xml.namespace.QName queryAllResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "queryAllResponse");
    private static final javax.xml.namespace.QName update_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "update");
    private static final javax.xml.namespace.QName updateResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "updateResponse");
    private static final javax.xml.namespace.QName emptyRecycleBin_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "emptyRecycleBin");
    private static final javax.xml.namespace.QName emptyRecycleBinResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "emptyRecycleBinResponse");
    private static final javax.xml.namespace.QName describeCompactLayouts_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeCompactLayouts");
    private static final javax.xml.namespace.QName describeCompactLayoutsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeCompactLayoutsResponse");
    private static final javax.xml.namespace.QName changeOwnPassword_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "changeOwnPassword");
    private static final javax.xml.namespace.QName changeOwnPasswordResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "changeOwnPasswordResponse");
    private static final javax.xml.namespace.QName describeSoqlListViews_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSoqlListViews");
    private static final javax.xml.namespace.QName describeSoqlListViewsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSoqlListViewsResponse");
    private static final javax.xml.namespace.QName describePathAssistants_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describePathAssistants");
    private static final javax.xml.namespace.QName describePathAssistantsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describePathAssistantsResponse");
    private static final javax.xml.namespace.QName describeAvailableQuickActions_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeAvailableQuickActions");
    private static final javax.xml.namespace.QName describeAvailableQuickActionsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeAvailableQuickActionsResponse");
    private static final javax.xml.namespace.QName getDeleted_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "getDeleted");
    private static final javax.xml.namespace.QName getDeletedResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "getDeletedResponse");
    private static final javax.xml.namespace.QName describeTabs_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeTabs");
    private static final javax.xml.namespace.QName describeTabsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeTabsResponse");
    private static final javax.xml.namespace.QName retrieveMassQuickActionTemplates_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "retrieveMassQuickActionTemplates");
    private static final javax.xml.namespace.QName retrieveMassQuickActionTemplatesResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "retrieveMassQuickActionTemplatesResponse");
    private static final javax.xml.namespace.QName search_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "search");
    private static final javax.xml.namespace.QName searchResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "searchResponse");
    private static final javax.xml.namespace.QName sendEmail_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "sendEmail");
    private static final javax.xml.namespace.QName sendEmailResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "sendEmailResponse");
    private static final javax.xml.namespace.QName getUpdated_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "getUpdated");
    private static final javax.xml.namespace.QName getUpdatedResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "getUpdatedResponse");
    private static final javax.xml.namespace.QName sendEmailMessage_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "sendEmailMessage");
    private static final javax.xml.namespace.QName sendEmailMessageResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "sendEmailMessageResponse");
    private static final javax.xml.namespace.QName describeQuickActionsForRecordType_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeQuickActionsForRecordType");
    private static final javax.xml.namespace.QName describeQuickActionsForRecordTypeResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeQuickActionsForRecordTypeResponse");
    private static final javax.xml.namespace.QName renderEmailTemplate_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "renderEmailTemplate");
    private static final javax.xml.namespace.QName renderEmailTemplateResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "renderEmailTemplateResponse");
    private static final javax.xml.namespace.QName upsert_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "upsert");
    private static final javax.xml.namespace.QName upsertResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "upsertResponse");
    private static final javax.xml.namespace.QName query_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "query");
    private static final javax.xml.namespace.QName queryResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "queryResponse");
    private static final javax.xml.namespace.QName describeQuickActions_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeQuickActions");
    private static final javax.xml.namespace.QName describeQuickActionsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeQuickActionsResponse");
    private static final javax.xml.namespace.QName performQuickActions_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "performQuickActions");
    private static final javax.xml.namespace.QName performQuickActionsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "performQuickActionsResponse");
    private static final javax.xml.namespace.QName describeSObjects_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSObjects");
    private static final javax.xml.namespace.QName describeSObjectsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSObjectsResponse");
    private static final javax.xml.namespace.QName describeKnowledgeSettings_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeKnowledgeSettings");
    private static final javax.xml.namespace.QName describeKnowledgeSettingsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeKnowledgeSettingsResponse");
    private static final javax.xml.namespace.QName undelete_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "undelete");
    private static final javax.xml.namespace.QName undeleteResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "undeleteResponse");
    private static final javax.xml.namespace.QName retrieve_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "retrieve");
    private static final javax.xml.namespace.QName retrieveResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "retrieveResponse");
    private static final javax.xml.namespace.QName describeTheme_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeTheme");
    private static final javax.xml.namespace.QName describeThemeResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeThemeResponse");
    private static final javax.xml.namespace.QName deleteByExample_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "deleteByExample");
    private static final javax.xml.namespace.QName deleteByExampleResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "deleteByExampleResponse");
    private static final javax.xml.namespace.QName describeNouns_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeNouns");
    private static final javax.xml.namespace.QName describeNounsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeNounsResponse");
    private static final javax.xml.namespace.QName findDuplicatesByIds_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "findDuplicatesByIds");
    private static final javax.xml.namespace.QName findDuplicatesByIdsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "findDuplicatesByIdsResponse");
    private static final javax.xml.namespace.QName executeListView_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "executeListView");
    private static final javax.xml.namespace.QName executeListViewResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "executeListViewResponse");
    private static final javax.xml.namespace.QName renderStoredEmailTemplate_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "renderStoredEmailTemplate");
    private static final javax.xml.namespace.QName renderStoredEmailTemplateResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "renderStoredEmailTemplateResponse");
    private static final javax.xml.namespace.QName describeVisualForce_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeVisualForce");
    private static final javax.xml.namespace.QName describeVisualForceResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeVisualForceResponse");
    private static final javax.xml.namespace.QName describeSObject_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSObject");
    private static final javax.xml.namespace.QName describeSObjectResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSObjectResponse");
    private static final javax.xml.namespace.QName getServerTimestamp_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "getServerTimestamp");
    private static final javax.xml.namespace.QName getServerTimestampResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "getServerTimestampResponse");
    private static final javax.xml.namespace.QName retrieveQuickActionTemplates_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "retrieveQuickActionTemplates");
    private static final javax.xml.namespace.QName retrieveQuickActionTemplatesResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "retrieveQuickActionTemplatesResponse");
    private static final javax.xml.namespace.QName setPassword_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "setPassword");
    private static final javax.xml.namespace.QName setPasswordResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "setPasswordResponse");
    private static final javax.xml.namespace.QName resetPassword_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "resetPassword");
    private static final javax.xml.namespace.QName resetPasswordResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "resetPasswordResponse");
    private static final javax.xml.namespace.QName describeSoftphoneLayout_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSoftphoneLayout");
    private static final javax.xml.namespace.QName describeSoftphoneLayoutResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSoftphoneLayoutResponse");
    private static final javax.xml.namespace.QName create_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "create");
    private static final javax.xml.namespace.QName createResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "createResponse");
    private static final javax.xml.namespace.QName describeSearchLayouts_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSearchLayouts");
    private static final javax.xml.namespace.QName describeSearchLayoutsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSearchLayoutsResponse");
    private static final javax.xml.namespace.QName merge_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "merge");
    private static final javax.xml.namespace.QName mergeResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "mergeResponse");
    private static final javax.xml.namespace.QName invalidateSessions_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "invalidateSessions");
    private static final javax.xml.namespace.QName invalidateSessionsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "invalidateSessionsResponse");
    private static final javax.xml.namespace.QName describeListViews_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeListViews");
    private static final javax.xml.namespace.QName describeListViewsResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeListViewsResponse");
    private static final javax.xml.namespace.QName logout_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "logout");
    private static final javax.xml.namespace.QName logoutResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "logoutResponse");
    private static final javax.xml.namespace.QName describeSearchScopeOrder_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSearchScopeOrder");
    private static final javax.xml.namespace.QName describeSearchScopeOrderResponse_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "describeSearchScopeOrderResponse");
    private static final javax.xml.namespace.QName QueryOptions_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "QueryOptions");
    private static final javax.xml.namespace.QName AssignmentRuleHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "AssignmentRuleHeader");
    private static final javax.xml.namespace.QName DisableFeedTrackingHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "DisableFeedTrackingHeader");
    private static final javax.xml.namespace.QName ConditionalRequestHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "ConditionalRequestHeader");
    private static final javax.xml.namespace.QName EmailHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "EmailHeader");
    private static final javax.xml.namespace.QName LocaleOptions_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "LocaleOptions");
    private static final javax.xml.namespace.QName DebuggingHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "DebuggingHeader");
    private static final javax.xml.namespace.QName OwnerChangeOptions_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "OwnerChangeOptions");
    private static final javax.xml.namespace.QName AllowFieldTruncationHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "AllowFieldTruncationHeader");
    private static final javax.xml.namespace.QName LimitInfoHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "LimitInfoHeader");
    private static final javax.xml.namespace.QName DebuggingInfo_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "DebuggingInfo");
    private static final javax.xml.namespace.QName PackageVersionHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "PackageVersionHeader");
    private static final javax.xml.namespace.QName AllOrNoneHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "AllOrNoneHeader");
    private static final javax.xml.namespace.QName MruHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "MruHeader");
    private static final javax.xml.namespace.QName SessionHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "SessionHeader");
    private static final javax.xml.namespace.QName CallOptions_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "CallOptions");
    private static final javax.xml.namespace.QName StreamingEnabledHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "StreamingEnabledHeader");
    private static final javax.xml.namespace.QName LoginScopeHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "LoginScopeHeader");
    private static final javax.xml.namespace.QName UserTerritoryDeleteHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "UserTerritoryDeleteHeader");
    private static final javax.xml.namespace.QName DuplicateRuleHeader_qname = new javax.xml.namespace.QName("urn:partner.soap.sforce.com", "DuplicateRuleHeader");


  private static HashMap<QName, java.lang.Class> knownHeaders = new HashMap<QName, java.lang.Class>();

  static {
      knownHeaders.put(QueryOptions_qname,com.sforce.soap.partner.QueryOptions_element.class);
      knownHeaders.put(AssignmentRuleHeader_qname,com.sforce.soap.partner.AssignmentRuleHeader_element.class);
      knownHeaders.put(DisableFeedTrackingHeader_qname,com.sforce.soap.partner.DisableFeedTrackingHeader_element.class);
      knownHeaders.put(ConditionalRequestHeader_qname,com.sforce.soap.partner.ConditionalRequestHeader_element.class);
      knownHeaders.put(EmailHeader_qname,com.sforce.soap.partner.EmailHeader_element.class);
      knownHeaders.put(LocaleOptions_qname,com.sforce.soap.partner.LocaleOptions_element.class);
      knownHeaders.put(DebuggingHeader_qname,com.sforce.soap.partner.DebuggingHeader_element.class);
      knownHeaders.put(OwnerChangeOptions_qname,com.sforce.soap.partner.OwnerChangeOptions_element.class);
      knownHeaders.put(AllowFieldTruncationHeader_qname,com.sforce.soap.partner.AllowFieldTruncationHeader_element.class);
      knownHeaders.put(LimitInfoHeader_qname,com.sforce.soap.partner.LimitInfoHeader_element.class);
      knownHeaders.put(DebuggingInfo_qname,com.sforce.soap.partner.DebuggingInfo_element.class);
      knownHeaders.put(PackageVersionHeader_qname,com.sforce.soap.partner.PackageVersionHeader_element.class);
      knownHeaders.put(AllOrNoneHeader_qname,com.sforce.soap.partner.AllOrNoneHeader_element.class);
      knownHeaders.put(MruHeader_qname,com.sforce.soap.partner.MruHeader_element.class);
      knownHeaders.put(SessionHeader_qname,com.sforce.soap.partner.SessionHeader_element.class);
      knownHeaders.put(CallOptions_qname,com.sforce.soap.partner.CallOptions_element.class);
      knownHeaders.put(StreamingEnabledHeader_qname,com.sforce.soap.partner.StreamingEnabledHeader_element.class);
      knownHeaders.put(LoginScopeHeader_qname,com.sforce.soap.partner.LoginScopeHeader_element.class);
      knownHeaders.put(UserTerritoryDeleteHeader_qname,com.sforce.soap.partner.UserTerritoryDeleteHeader_element.class);
      knownHeaders.put(DuplicateRuleHeader_qname,com.sforce.soap.partner.DuplicateRuleHeader_element.class);
  }
}
