/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.apistarter.utils;

import com.fengwenyi.api.result.IReturnCode;
import com.fengwenyi.apistarter.exception.ApiException;
import java.util.Collection;
import java.util.Objects;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class Asserts {
    public static void fail(String msg) {
        throw new ApiException(msg);
    }

    public static void fail(IReturnCode returnCode) {
        throw new ApiException(returnCode);
    }

    public static void fail(IReturnCode returnCode, String msg) {
        throw new ApiException(returnCode, msg);
    }

    public static void notBlank(String str, String msg) {
        if (!StringUtils.hasText((String)str)) {
            Asserts.fail(msg);
        }
    }

    public static void notNull(Object obj, String msg) {
        if (Objects.isNull(obj)) {
            Asserts.fail(msg);
        }
    }

    public static void notEmpty(Collection<?> collection, String msg) {
        if (CollectionUtils.isEmpty(collection)) {
            Asserts.fail(msg);
        }
    }
}

