/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.apistarter.advice;

import com.fengwenyi.api.result.ResponseTemplate;
import com.fengwenyi.apistarter.annotation.IgnoreResponseAdvice;
import com.fengwenyi.apistarter.utils.JacksonJsonUtils;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class ApiResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        if (returnType.getDeclaringClass().isAnnotationPresent(IgnoreResponseAdvice.class)) {
            return false;
        }
        Method method = returnType.getMethod();
        if (Objects.isNull(method)) {
            return true;
        }
        return !method.isAnnotationPresent(IgnoreResponseAdvice.class);
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        ResponseTemplate responseTemplate = ResponseTemplate.success();
        if (Objects.isNull(body)) {
            return responseTemplate;
        }
        if (body instanceof ResponseTemplate) {
            return body;
        }
        if (body instanceof String) {
            return JacksonJsonUtils.convertString(ResponseTemplate.success((Object)body));
        }
        return responseTemplate.setBody(body);
    }
}

