/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.touch.CatalystInterceptingViewGroup;
import com.facebook.react.touch.OnInterceptTouchEventListener;
import com.facebook.react.uimanager.MeasureSpecAssertions;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactPointerEventsView;
import com.facebook.react.views.view.ReactClippingViewGroup;
import com.facebook.react.views.view.ReactClippingViewGroupHelper;
import com.facebook.react.views.view.ReactViewBackgroundDrawable;
import javax.annotation.Nullable;

public class ReactViewGroup
extends ViewGroup
implements CatalystInterceptingViewGroup,
ReactClippingViewGroup,
ReactPointerEventsView {
    private static final int ARRAY_CAPACITY_INCREMENT = 12;
    private static final int DEFAULT_BACKGROUND_COLOR = 0;
    private static final ViewGroup.LayoutParams sDefaultLayoutParam = new ViewGroup.LayoutParams(0, 0);
    private static final Rect sHelperRect = new Rect();
    private boolean mRemoveClippedSubviews = false;
    @Nullable
    private View[] mAllChildren = null;
    private int mAllChildrenCount;
    @Nullable
    private Rect mClippingRect;
    private PointerEvents mPointerEvents = PointerEvents.AUTO;
    @Nullable
    private ChildrenLayoutChangeListener mChildrenLayoutChangeListener;
    @Nullable
    private ReactViewBackgroundDrawable mReactBackgroundDrawable;
    @Nullable
    private OnInterceptTouchEventListener mOnInterceptTouchEventListener;
    private boolean mNeedsOffscreenAlphaCompositing = false;

    public ReactViewGroup(Context context) {
        super(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecAssertions.assertExplicitMeasureSpec(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    public void requestLayout() {
    }

    public void setBackgroundColor(int color) {
        if (color != 0 || this.mReactBackgroundDrawable != null) {
            this.getOrCreateReactViewBackground().setColor(color);
        }
    }

    public void setBackground(Drawable drawable) {
        throw new UnsupportedOperationException("This method is not supported for ReactViewGroup instances");
    }

    public void setTranslucentBackgroundDrawable(@Nullable Drawable background) {
        super.setBackground(null);
        if (this.mReactBackgroundDrawable != null && background != null) {
            LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.mReactBackgroundDrawable, background});
            super.setBackground((Drawable)layerDrawable);
        } else if (background != null) {
            super.setBackground(background);
        }
    }

    @Override
    public void setOnInterceptTouchEventListener(OnInterceptTouchEventListener listener) {
        this.mOnInterceptTouchEventListener = listener;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mOnInterceptTouchEventListener != null && this.mOnInterceptTouchEventListener.onInterceptTouchEvent(this, ev)) {
            return true;
        }
        if (this.mPointerEvents == PointerEvents.NONE || this.mPointerEvents == PointerEvents.BOX_ONLY) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        return this.mPointerEvents != PointerEvents.NONE && this.mPointerEvents != PointerEvents.BOX_NONE;
    }

    public boolean hasOverlappingRendering() {
        return this.mNeedsOffscreenAlphaCompositing;
    }

    public void setNeedsOffscreenAlphaCompositing(boolean needsOffscreenAlphaCompositing) {
        this.mNeedsOffscreenAlphaCompositing = needsOffscreenAlphaCompositing;
    }

    public void setBorderWidth(int position, float width) {
        this.getOrCreateReactViewBackground().setBorderWidth(position, width);
    }

    public void setBorderColor(int position, float color) {
        this.getOrCreateReactViewBackground().setBorderColor(position, color);
    }

    public void setBorderRadius(float borderRadius) {
        this.getOrCreateReactViewBackground().setRadius(borderRadius);
    }

    public void setBorderStyle(@Nullable String style2) {
        this.getOrCreateReactViewBackground().setBorderStyle(style2);
    }

    @Override
    public void setRemoveClippedSubviews(boolean removeClippedSubviews) {
        if (removeClippedSubviews == this.mRemoveClippedSubviews) {
            return;
        }
        this.mRemoveClippedSubviews = removeClippedSubviews;
        if (removeClippedSubviews) {
            this.mClippingRect = new Rect();
            ReactClippingViewGroupHelper.calculateClippingRect((View)this, this.mClippingRect);
            this.mAllChildrenCount = this.getChildCount();
            int initialSize = Math.max(12, this.mAllChildrenCount);
            this.mAllChildren = new View[initialSize];
            this.mChildrenLayoutChangeListener = new ChildrenLayoutChangeListener(this);
            for (int i = 0; i < this.mAllChildrenCount; ++i) {
                View child;
                this.mAllChildren[i] = child = this.getChildAt(i);
                child.addOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
            }
            this.updateClippingRect();
        } else {
            Assertions.assertNotNull((Object)this.mClippingRect);
            Assertions.assertNotNull((Object)this.mAllChildren);
            Assertions.assertNotNull((Object)this.mChildrenLayoutChangeListener);
            for (int i = 0; i < this.mAllChildrenCount; ++i) {
                this.mAllChildren[i].removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
            }
            this.getDrawingRect(this.mClippingRect);
            this.updateClippingToRect(this.mClippingRect);
            this.mAllChildren = null;
            this.mClippingRect = null;
            this.mAllChildrenCount = 0;
            this.mChildrenLayoutChangeListener = null;
        }
    }

    @Override
    public boolean getRemoveClippedSubviews() {
        return this.mRemoveClippedSubviews;
    }

    @Override
    public void getClippingRect(Rect outClippingRect) {
        outClippingRect.set(this.mClippingRect);
    }

    @Override
    public void updateClippingRect() {
        if (!this.mRemoveClippedSubviews) {
            return;
        }
        Assertions.assertNotNull((Object)this.mClippingRect);
        Assertions.assertNotNull((Object)this.mAllChildren);
        ReactClippingViewGroupHelper.calculateClippingRect((View)this, this.mClippingRect);
        this.updateClippingToRect(this.mClippingRect);
    }

    private void updateClippingToRect(Rect clippingRect) {
        Assertions.assertNotNull((Object)this.mAllChildren);
        int clippedSoFar = 0;
        for (int i = 0; i < this.mAllChildrenCount; ++i) {
            this.updateSubviewClipStatus(clippingRect, i, clippedSoFar);
            if (this.mAllChildren[i].getParent() != null) continue;
            ++clippedSoFar;
        }
    }

    private void updateSubviewClipStatus(Rect clippingRect, int idx, int clippedSoFar) {
        ReactClippingViewGroup clippingChild;
        boolean isAnimating;
        View child = ((View[])Assertions.assertNotNull((Object)this.mAllChildren))[idx];
        sHelperRect.set(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
        boolean intersects = clippingRect.intersects(ReactViewGroup.sHelperRect.left, ReactViewGroup.sHelperRect.top, ReactViewGroup.sHelperRect.right, ReactViewGroup.sHelperRect.bottom);
        boolean needUpdateClippingRecursive = false;
        Animation animation = child.getAnimation();
        boolean bl = isAnimating = animation != null && !animation.hasEnded();
        if (!intersects && child.getParent() != null && !isAnimating) {
            super.removeViewsInLayout(idx - clippedSoFar, 1);
            needUpdateClippingRecursive = true;
        } else if (intersects && child.getParent() == null) {
            super.addViewInLayout(child, idx - clippedSoFar, sDefaultLayoutParam, true);
            this.invalidate();
            needUpdateClippingRecursive = true;
        } else if (intersects) {
            needUpdateClippingRecursive = true;
        }
        if (needUpdateClippingRecursive && child instanceof ReactClippingViewGroup && (clippingChild = (ReactClippingViewGroup)child).getRemoveClippedSubviews()) {
            clippingChild.updateClippingRect();
        }
    }

    private void updateSubviewClipStatus(View subview) {
        boolean oldIntersects;
        if (!this.mRemoveClippedSubviews || this.getParent() == null) {
            return;
        }
        Assertions.assertNotNull((Object)this.mClippingRect);
        Assertions.assertNotNull((Object)this.mAllChildren);
        sHelperRect.set(subview.getLeft(), subview.getTop(), subview.getRight(), subview.getBottom());
        boolean intersects = this.mClippingRect.intersects(ReactViewGroup.sHelperRect.left, ReactViewGroup.sHelperRect.top, ReactViewGroup.sHelperRect.right, ReactViewGroup.sHelperRect.bottom);
        boolean bl = oldIntersects = subview.getParent() != null;
        if (intersects != oldIntersects) {
            int clippedSoFar = 0;
            for (int i = 0; i < this.mAllChildrenCount; ++i) {
                if (this.mAllChildren[i] == subview) {
                    this.updateSubviewClipStatus(this.mClippingRect, i, clippedSoFar);
                    break;
                }
                if (this.mAllChildren[i].getParent() != null) continue;
                ++clippedSoFar;
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateClippingRect();
    }

    @Override
    public PointerEvents getPointerEvents() {
        return this.mPointerEvents;
    }

    void setPointerEvents(PointerEvents pointerEvents) {
        this.mPointerEvents = pointerEvents;
    }

    int getAllChildrenCount() {
        return this.mAllChildrenCount;
    }

    View getChildAtWithSubviewClippingEnabled(int index) {
        return ((View[])Assertions.assertNotNull((Object)this.mAllChildren))[index];
    }

    void addViewWithSubviewClippingEnabled(View child, int index) {
        this.addViewWithSubviewClippingEnabled(child, index, sDefaultLayoutParam);
    }

    void addViewWithSubviewClippingEnabled(View child, int index, ViewGroup.LayoutParams params) {
        Assertions.assertCondition((boolean)this.mRemoveClippedSubviews);
        Assertions.assertNotNull((Object)this.mClippingRect);
        Assertions.assertNotNull((Object)this.mAllChildren);
        this.addInArray(child, index);
        int clippedSoFar = 0;
        for (int i = 0; i < index; ++i) {
            if (this.mAllChildren[i].getParent() != null) continue;
            ++clippedSoFar;
        }
        this.updateSubviewClipStatus(this.mClippingRect, index, clippedSoFar);
        child.addOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
    }

    void removeViewWithSubviewClippingEnabled(View view) {
        Assertions.assertCondition((boolean)this.mRemoveClippedSubviews);
        Assertions.assertNotNull((Object)this.mClippingRect);
        Assertions.assertNotNull((Object)this.mAllChildren);
        view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
        int index = this.indexOfChildInAllChildren(view);
        if (this.mAllChildren[index].getParent() != null) {
            int clippedSoFar = 0;
            for (int i = 0; i < index; ++i) {
                if (this.mAllChildren[i].getParent() != null) continue;
                ++clippedSoFar;
            }
            super.removeViewsInLayout(index - clippedSoFar, 1);
        }
        this.removeFromArray(index);
    }

    void removeAllViewsWithSubviewClippingEnabled() {
        Assertions.assertCondition((boolean)this.mRemoveClippedSubviews);
        Assertions.assertNotNull((Object)this.mAllChildren);
        for (int i = 0; i < this.mAllChildrenCount; ++i) {
            this.mAllChildren[i].removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
        }
        this.removeAllViewsInLayout();
        this.mAllChildrenCount = 0;
    }

    private int indexOfChildInAllChildren(View child) {
        int count = this.mAllChildrenCount;
        View[] children = (View[])Assertions.assertNotNull((Object)this.mAllChildren);
        for (int i = 0; i < count; ++i) {
            if (children[i] != child) continue;
            return i;
        }
        return -1;
    }

    private void addInArray(View child, int index) {
        View[] children = (View[])Assertions.assertNotNull((Object)this.mAllChildren);
        int count = this.mAllChildrenCount;
        int size = children.length;
        if (index == count) {
            if (size == count) {
                this.mAllChildren = new View[size + 12];
                System.arraycopy(children, 0, this.mAllChildren, 0, size);
                children = this.mAllChildren;
            }
            children[this.mAllChildrenCount++] = child;
        } else if (index < count) {
            if (size == count) {
                this.mAllChildren = new View[size + 12];
                System.arraycopy(children, 0, this.mAllChildren, 0, index);
                System.arraycopy(children, index, this.mAllChildren, index + 1, count - index);
                children = this.mAllChildren;
            } else {
                System.arraycopy(children, index, children, index + 1, count - index);
            }
            children[index] = child;
            ++this.mAllChildrenCount;
        } else {
            throw new IndexOutOfBoundsException("index=" + index + " count=" + count);
        }
    }

    private void removeFromArray(int index) {
        int count;
        View[] children = (View[])Assertions.assertNotNull((Object)this.mAllChildren);
        if (index == (count = this.mAllChildrenCount--) - 1) {
            children[this.mAllChildrenCount] = null;
        } else if (index >= 0 && index < count) {
            System.arraycopy(children, index + 1, children, index, count - index - 1);
            children[--this.mAllChildrenCount] = null;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @VisibleForTesting
    public int getBackgroundColor() {
        if (this.getBackground() != null) {
            return ((ReactViewBackgroundDrawable)this.getBackground()).getColor();
        }
        return 0;
    }

    private ReactViewBackgroundDrawable getOrCreateReactViewBackground() {
        if (this.mReactBackgroundDrawable == null) {
            this.mReactBackgroundDrawable = new ReactViewBackgroundDrawable();
            Drawable backgroundDrawable = this.getBackground();
            super.setBackground(null);
            if (backgroundDrawable == null) {
                super.setBackground((Drawable)this.mReactBackgroundDrawable);
            } else {
                LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.mReactBackgroundDrawable, backgroundDrawable});
                super.setBackground((Drawable)layerDrawable);
            }
        }
        return this.mReactBackgroundDrawable;
    }

    private static final class ChildrenLayoutChangeListener
    implements View.OnLayoutChangeListener {
        private final ReactViewGroup mParent;

        private ChildrenLayoutChangeListener(ReactViewGroup parent) {
            this.mParent = parent;
        }

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            if (this.mParent.getRemoveClippedSubviews()) {
                this.mParent.updateSubviewClipStatus(v);
            }
        }
    }
}

