/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.swiperefresh;

import android.os.SystemClock;
import android.support.v4.widget.SwipeRefreshLayout;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.swiperefresh.ReactSwipeRefreshLayout;
import com.facebook.react.views.swiperefresh.RefreshEvent;
import java.util.Map;
import javax.annotation.Nullable;

public class SwipeRefreshLayoutManager
extends ViewGroupManager<ReactSwipeRefreshLayout> {
    @Override
    protected ReactSwipeRefreshLayout createViewInstance(ThemedReactContext reactContext) {
        return new ReactSwipeRefreshLayout(reactContext);
    }

    @Override
    public String getName() {
        return "AndroidSwipeRefreshLayout";
    }

    @ReactProp(name="enabled", defaultBoolean=true)
    public void setEnabled(ReactSwipeRefreshLayout view, boolean enabled) {
        view.setEnabled(enabled);
    }

    @ReactProp(name="colors")
    public void setColors(ReactSwipeRefreshLayout view, @Nullable ReadableArray colors) {
        if (colors != null) {
            int[] colorValues = new int[colors.size()];
            for (int i = 0; i < colors.size(); ++i) {
                colorValues[i] = colors.getInt(i);
            }
            view.setColorSchemeColors(colorValues);
        } else {
            view.setColorSchemeColors(new int[0]);
        }
    }

    @ReactProp(name="progressBackgroundColor", defaultInt=0, customType="Color")
    public void setProgressBackgroundColor(ReactSwipeRefreshLayout view, int color) {
        view.setProgressBackgroundColorSchemeColor(color);
    }

    @ReactProp(name="size", defaultInt=1)
    public void setSize(ReactSwipeRefreshLayout view, int size) {
        view.setSize(size);
    }

    @ReactProp(name="refreshing")
    public void setRefreshing(ReactSwipeRefreshLayout view, boolean refreshing) {
        view.setRefreshing(refreshing);
    }

    @Override
    protected void addEventEmitters(final ThemedReactContext reactContext, final ReactSwipeRefreshLayout view) {
        view.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(new RefreshEvent(view.getId(), SystemClock.uptimeMillis()));
            }
        });
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedViewConstants() {
        return MapBuilder.of("SIZE", MapBuilder.of("DEFAULT", 1, "LARGE", 0));
    }

    @Override
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put("topRefresh", MapBuilder.of("registrationName", "onRefresh")).build();
    }
}

