/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.clipboard;

import android.annotation.SuppressLint;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.os.Build;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;

public class ClipboardModule
extends ReactContextBaseJavaModule {
    public ClipboardModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return "Clipboard";
    }

    private ClipboardManager getClipboardService() {
        ReactApplicationContext reactContext = this.getReactApplicationContext();
        return (ClipboardManager)reactContext.getSystemService("clipboard");
    }

    @ReactMethod
    public void getString(Callback cb) {
        try {
            ClipboardManager clipboard = this.getClipboardService();
            ClipData clipData = clipboard.getPrimaryClip();
            if (clipData == null) {
                cb.invoke("");
                return;
            }
            if (clipData.getItemCount() >= 1) {
                ClipData.Item firstItem = clipboard.getPrimaryClip().getItemAt(0);
                String text = "" + firstItem.getText();
                cb.invoke(text);
            } else {
                cb.invoke("");
            }
        }
        catch (Exception e) {
            FLog.w((String)"React", (String)("Cannot get clipboard contents: " + e.getMessage()));
        }
    }

    @ReactMethod
    @SuppressLint(value={"DeprecatedMethod"})
    public void setString(String text) {
        ReactApplicationContext reactContext = this.getReactApplicationContext();
        if (Build.VERSION.SDK_INT >= 11) {
            ClipData clipdata = ClipData.newPlainText(null, (CharSequence)text);
            ClipboardManager clipboard = this.getClipboardService();
            clipboard.setPrimaryClip(clipdata);
        } else {
            ClipboardManager clipboard = this.getClipboardService();
            clipboard.setText((CharSequence)text);
        }
    }
}

