/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.appstate;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;

public class AppStateModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    public static final String APP_STATE_ACTIVE = "active";
    public static final String APP_STATE_BACKGROUND = "background";
    private String mAppState = "uninitialized";

    public AppStateModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return "AppState";
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
    }

    @ReactMethod
    public void getCurrentAppState(Callback success, Callback error) {
        success.invoke(this.createAppStateEventMap());
    }

    @Override
    public void onHostResume() {
        this.mAppState = APP_STATE_ACTIVE;
        this.sendAppStateChangeEvent();
    }

    @Override
    public void onHostPause() {
        this.mAppState = APP_STATE_BACKGROUND;
        this.sendAppStateChangeEvent();
    }

    @Override
    public void onHostDestroy() {
    }

    private WritableMap createAppStateEventMap() {
        WritableMap appState = Arguments.createMap();
        appState.putString("app_state", this.mAppState);
        return appState;
    }

    private void sendAppStateChangeEvent() {
        this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("appStateDidChange", this.createAppStateEventMap());
    }
}

